/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.work;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.resource.NotSupportedException;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.TransactionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkAdapter;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkContextProvider;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import org.apache.geronimo.connector.work.WorkContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerContext
implements Work {
    private static final Logger log = LoggerFactory.getLogger(WorkerContext.class);
    private static final List<WorkContext> NO_INFLOW_CONTEXT = Collections.emptyList();
    private static final WorkListener NULL_WORK_LISTENER = new WorkAdapter(){

        public void workRejected(WorkEvent event) {
            if (event.getException() != null) {
                if (event.getException() instanceof WorkCompletedException && event.getException().getCause() != null) {
                    log.error(event.getWork().toString(), event.getException().getCause());
                } else {
                    log.error(event.getWork().toString(), event.getException());
                }
            }
        }
    };
    private int threadPriority;
    private Work adaptee;
    private boolean isAccepted;
    private long acceptedTime;
    private int nbRetry;
    private long startTimeOut;
    private final WorkListener workListener;
    private WorkException workException;
    private CountDownLatch startLatch = new CountDownLatch(1);
    private CountDownLatch endLatch = new CountDownLatch(1);
    private final ExecutionContext executionContext;
    private final List<WorkContextHandler> workContextHandlers;

    public WorkerContext(Work work, Collection<WorkContextHandler> workContextHandlers) {
        this.adaptee = work;
        this.workContextHandlers = new ArrayList<WorkContextHandler>(workContextHandlers);
        this.executionContext = null;
        this.workListener = NULL_WORK_LISTENER;
    }

    public WorkerContext(Work aWork, long aStartTimeout, ExecutionContext execContext, WorkListener workListener, Collection<WorkContextHandler> workContextHandlers) throws WorkRejectedException {
        this.adaptee = aWork;
        this.startTimeOut = aStartTimeout;
        this.workListener = null == workListener ? NULL_WORK_LISTENER : workListener;
        if (aWork instanceof WorkContextProvider) {
            if (execContext != null) {
                throw new WorkRejectedException("Execution context provided but Work implements WorkContextProvider");
            }
            this.executionContext = null;
        } else {
            this.executionContext = execContext;
        }
        this.workContextHandlers = new ArrayList<WorkContextHandler>(workContextHandlers);
    }

    @Override
    public void release() {
        this.adaptee.release();
    }

    public void setThreadPriority(int aPriority) {
        this.threadPriority = aPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public synchronized void workAccepted(Object anObject) {
        this.isAccepted = true;
        this.acceptedTime = System.currentTimeMillis();
        this.workListener.workAccepted(new WorkEvent(anObject, 1, this.adaptee, null));
    }

    public synchronized long getAcceptedTime() {
        return this.acceptedTime;
    }

    public long getStartTimeout() {
        return this.startTimeOut;
    }

    public synchronized boolean isTimedOut() {
        boolean isTimeout;
        assert (this.isAccepted) : "The work is not accepted.";
        if (0L == this.startTimeOut || this.startTimeOut == Long.MAX_VALUE) {
            return false;
        }
        boolean bl = isTimeout = this.acceptedTime + this.startTimeOut > 0L && System.currentTimeMillis() > this.acceptedTime + this.startTimeOut;
        if (log.isDebugEnabled()) {
            log.debug(this + " accepted at " + this.acceptedTime + (isTimeout ? " has timed out." : " has not timed out. ") + this.nbRetry + " retries have been performed.");
        }
        if (isTimeout) {
            this.workException = new WorkRejectedException(this + " has timed out.", "1");
            this.workListener.workRejected(new WorkEvent(this, 2, this.adaptee, this.workException));
            return true;
        }
        ++this.nbRetry;
        return isTimeout;
    }

    public synchronized WorkException getWorkException() {
        return this.workException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isTimedOut()) {
            this.startLatch.countDown();
            this.endLatch.countDown();
            return;
        }
        this.workListener.workStarted(new WorkEvent(this, 3, this.adaptee, null));
        this.startLatch.countDown();
        try {
            try {
                int j2;
                List<WorkContext> workContexts = NO_INFLOW_CONTEXT;
                if (this.executionContext != null) {
                    TransactionContext txWorkContext = new TransactionContext();
                    try {
                        txWorkContext.setTransactionTimeout(this.executionContext.getTransactionTimeout());
                    }
                    catch (NotSupportedException e) {
                        // empty catch block
                    }
                    txWorkContext.setXid(this.executionContext.getXid());
                    workContexts = Collections.singletonList(txWorkContext);
                    log.info("Translated ExecutionContext to TransactionContext");
                } else if (this.adaptee instanceof WorkContextProvider) {
                    workContexts = ((WorkContextProvider)((Object)this.adaptee)).getWorkContexts();
                }
                ArrayList<WorkContextHandler> sortedHandlers = new ArrayList<WorkContextHandler>(workContexts.size());
                for (WorkContext workContext : workContexts) {
                    boolean found = false;
                    Iterator<WorkContextHandler> it = this.workContextHandlers.iterator();
                    while (it.hasNext()) {
                        WorkContextHandler workContextHandler = it.next();
                        log.info("sorting WorkContextHandler: " + workContextHandler + " for work context: " + workContext);
                        if (!workContextHandler.supports(workContext.getClass())) continue;
                        it.remove();
                        log.info("adding sorted WorkContextHandler: " + workContextHandler);
                        sortedHandlers.add(workContextHandler);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    for (WorkContextHandler workContextHandler : sortedHandlers) {
                        if (!workContextHandler.supports(workContext.getClass())) continue;
                        throw new WorkCompletedException("Duplicate WorkContext: " + workContext, "2");
                    }
                    throw new WorkCompletedException("Unhandled WorkContext: " + workContext, "1");
                }
                Iterator<WorkContextHandler> it = this.workContextHandlers.iterator();
                while (it.hasNext()) {
                    WorkContextHandler workContextHandler = it.next();
                    if (workContextHandler.required()) continue;
                    log.info("Removing non-required WorkContextHandler with no context: " + workContextHandler);
                    it.remove();
                }
                int i = 0;
                for (WorkContext workContext : workContexts) {
                    WorkContextHandler contextHandler = (WorkContextHandler)sortedHandlers.get(i++);
                    log.info("calling before on WorkContextHandler: " + contextHandler + " with workContext: " + workContext);
                    contextHandler.before(workContext);
                }
                for (WorkContextHandler workContextHandler : this.workContextHandlers) {
                    log.info("calling before on WorkContextHandler: " + workContextHandler + " with null workContext");
                    workContextHandler.before(null);
                }
                try {
                    this.adaptee.run();
                    Object var9_14 = null;
                    j2 = 0;
                }
                catch (Throwable throwable) {
                    Object var9_15 = null;
                    int j2 = 0;
                    for (WorkContext workContext : workContexts) {
                        WorkContextHandler contextHandler = (WorkContextHandler)sortedHandlers.get(j2++);
                        log.info("calling after on WorkContextHandler: " + contextHandler + " with workContext: " + workContext);
                        contextHandler.after(workContext);
                    }
                    for (WorkContextHandler workContextHandler : this.workContextHandlers) {
                        log.info("calling after on WorkContextHandler: " + workContextHandler + " with null workContext");
                        workContextHandler.after(null);
                    }
                    throw throwable;
                }
                for (WorkContext workContext : workContexts) {
                    WorkContextHandler contextHandler = (WorkContextHandler)sortedHandlers.get(j2++);
                    log.info("calling after on WorkContextHandler: " + contextHandler + " with workContext: " + workContext);
                    contextHandler.after(workContext);
                }
                for (WorkContextHandler workContextHandler : this.workContextHandlers) {
                    log.info("calling after on WorkContextHandler: " + workContextHandler + " with null workContext");
                    workContextHandler.after(null);
                }
                this.workListener.workCompleted(new WorkEvent(this, 4, this.adaptee, null));
            }
            catch (Throwable e) {
                this.workException = (WorkException)(e instanceof WorkCompletedException ? e : new WorkCompletedException("Unknown error", "0").initCause(e));
                this.workListener.workCompleted(new WorkEvent(this, 2, this.adaptee, this.workException));
                Object var15_26 = null;
                this.endLatch.countDown();
            }
            Object var15_25 = null;
            this.endLatch.countDown();
        }
        catch (Throwable throwable) {
            Object var15_27 = null;
            this.endLatch.countDown();
            throw throwable;
        }
    }

    public synchronized CountDownLatch provideStartLatch() {
        return this.startLatch;
    }

    public synchronized CountDownLatch provideEndLatch() {
        return this.endLatch;
    }

    public String toString() {
        return "Work :" + this.adaptee;
    }
}

