/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector;

import java.util.Set;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.geronimo.connector.ResourceAdapterWrapper;

public class AdminObjectWrapper {
    private final String adminObjectInterface;
    private final String adminObjectClass;
    protected ResourceAdapterWrapper resourceAdapterWrapper;
    protected Object adminObject;
    private final ValidatorFactory validatorFactory;

    public AdminObjectWrapper(String adminObjectInterface, String adminObjectClass, ResourceAdapterWrapper resourceAdapterWrapper, ClassLoader cl, ValidatorFactory validatorFactory) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.adminObjectInterface = adminObjectInterface;
        this.adminObjectClass = adminObjectClass;
        this.resourceAdapterWrapper = resourceAdapterWrapper;
        this.validatorFactory = validatorFactory;
        Class<?> clazz = cl.loadClass(adminObjectClass);
        this.adminObject = clazz.newInstance();
    }

    public String getAdminObjectInterface() {
        return this.adminObjectInterface;
    }

    public String getAdminObjectClass() {
        return this.adminObjectClass;
    }

    public void doStart() throws Exception {
        Validator validator;
        Set<ConstraintViolation<?>> generalSet;
        if (this.validatorFactory != null && !(generalSet = (validator = this.validatorFactory.getValidator()).validate(this.adminObject, new Class[0])).isEmpty()) {
            throw new ConstraintViolationException("Constraint violation for AdminObject " + this.adminObjectClass, generalSet);
        }
        if (this.adminObject instanceof ResourceAdapterAssociation) {
            if (this.resourceAdapterWrapper == null) {
                throw new IllegalStateException("Admin object expects to be registered with a ResourceAdapter, but there is no ResourceAdapter");
            }
            this.resourceAdapterWrapper.registerResourceAdapterAssociation((ResourceAdapterAssociation)this.adminObject);
        }
    }

    public void doStop() throws Exception {
    }

    public void doFail() {
    }
}

