/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg.manifest;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.manifest.EncryptionDataElement;
import org.odftoolkit.odfdom.pkg.manifest.FileEntryElement;
import org.odftoolkit.odfdom.pkg.manifest.SizeAttribute;
import org.w3c.dom.Node;

public class OdfFileEntry {
    private FileEntryElement mFileEntryElement;
    private static Map<String, String> MEDIA_TYPE_MAP = null;
    private static final String EMPTY_STRING = "";
    private static final String DEFAULT_TYPE = "application/octet-stream";
    private static final String APPLICATION_POSTSCRIPT = "application/postscript";
    private static final String APPLICATION_RTF = "application/rtf";
    private static final String APPLICATION_X_TEX = "application/x-tex";
    private static final String APPLICATION_X_TEXINFO = "application/x-texinfo";
    private static final String APPLICATION_X_TROFF = "application/x-troff";
    private static final String AUDIO_BASIC = "audio/basic";
    private static final String AUDIO_MIDI = "audio/midi";
    private static final String AUDIO_X_AIFC = "audio/x-aifc";
    private static final String AUDIO_X_AIFF = "audio/x-aiff";
    private static final String AUDIO_X_MPEG = "audio/x-mpeg";
    private static final String AUDIO_X_WAV = "audio/x-wav";
    private static final String IMAGE_GIF = "image/gif";
    private static final String IMAGE_IEF = "image/ief";
    private static final String IMAGE_JPEG = "image/jpeg";
    private static final String IMAGE_PNG = "image/png";
    private static final String IMAGE_TIFF = "image/tiff";
    private static final String IMAGE_X_XWINDOWDUMP = "image/x-xwindowdump";
    private static final String TEXT_HTML = "text/html";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String TEXT_XML = "text/xml";
    private static final String VIDEO_MEPG = "video/mpeg";
    private static final String VIDEO_QUICKTIME = "video/quicktime";
    private static final String VIDEO_X_MSVIDEO = "video/x-msvideo";

    public OdfFileEntry(FileEntryElement fileEntryElement) {
        this.mFileEntryElement = fileEntryElement;
    }

    public void setPath(String path) {
        this.mFileEntryElement.setFullPathAttribute(path);
    }

    public String getPath() {
        return this.mFileEntryElement.getFullPathAttribute();
    }

    public void setMediaTypeString(String mediaType) {
        if (mediaType != null) {
            this.mFileEntryElement.setMediaTypeAttribute(mediaType);
        } else {
            this.mFileEntryElement.setMediaTypeAttribute(EMPTY_STRING);
        }
    }

    public String getMediaTypeString() {
        return this.mFileEntryElement.getMediaTypeAttribute();
    }

    public static String getMediaTypeString(String fileRef) {
        String mediaType = null;
        try {
            Class<?> mimetypesClass = Class.forName("javax.activation.MimetypesFileTypeMap");
            Method getContentTypeMethod = mimetypesClass.getMethod("getContentType", String.class);
            mediaType = (String)getContentTypeMethod.invoke((Object)getContentTypeMethod, fileRef);
        }
        catch (Exception e) {
            mediaType = OdfFileEntry.findMediaTypeString(fileRef);
        }
        return mediaType;
    }

    public void setSize(Integer size) {
        if (size == null) {
            this.mFileEntryElement.removeAttributeNS(SizeAttribute.ATTRIBUTE_NAME.getUri(), SizeAttribute.ATTRIBUTE_NAME.getLocalName());
        } else {
            this.mFileEntryElement.setSizeAttribute(size);
        }
    }

    public Integer getSize() {
        return this.mFileEntryElement.getSizeAttribute();
    }

    public void setEncryptionData(EncryptionDataElement encryptionData) {
        EncryptionDataElement encryptionDataEle = this.getEncryptionData();
        if (encryptionData != null) {
            if (encryptionDataEle != null) {
                this.mFileEntryElement.replaceChild((Node)((Object)encryptionData), (Node)((Object)encryptionDataEle));
            } else {
                this.mFileEntryElement.appendChild((Node)((Object)encryptionData));
            }
        } else if (encryptionDataEle != null) {
            this.mFileEntryElement.removeChild((Node)((Object)encryptionDataEle));
        }
    }

    public EncryptionDataElement getEncryptionData() {
        return OdfElement.findFirstChildNode(EncryptionDataElement.class, (Node)((Object)this.mFileEntryElement));
    }

    public FileEntryElement getOdfElement() {
        return this.mFileEntryElement;
    }

    private static String findMediaTypeString(String fileRef) {
        String fileSuffix = null;
        String mediaType = null;
        int suffixStart = fileRef.lastIndexOf(".");
        if (suffixStart < 0) {
            mediaType = DEFAULT_TYPE;
        } else {
            fileSuffix = fileRef.substring(suffixStart + 1);
            if (fileSuffix.length() == 0) {
                mediaType = DEFAULT_TYPE;
            } else {
                if (MEDIA_TYPE_MAP == null) {
                    OdfFileEntry.initializeMediaTypeMap();
                }
                if ((mediaType = MEDIA_TYPE_MAP.get(fileSuffix.toLowerCase())) == null) {
                    mediaType = DEFAULT_TYPE;
                }
            }
        }
        return mediaType;
    }

    private static void initializeMediaTypeMap() {
        MEDIA_TYPE_MAP = new HashMap<String, String>(39);
        MEDIA_TYPE_MAP.put("ai", APPLICATION_POSTSCRIPT);
        MEDIA_TYPE_MAP.put("eps", APPLICATION_POSTSCRIPT);
        MEDIA_TYPE_MAP.put("ps", APPLICATION_POSTSCRIPT);
        MEDIA_TYPE_MAP.put("rtf", APPLICATION_RTF);
        MEDIA_TYPE_MAP.put("tex", APPLICATION_X_TEX);
        MEDIA_TYPE_MAP.put("texi", APPLICATION_X_TEXINFO);
        MEDIA_TYPE_MAP.put("texinfo", APPLICATION_X_TEXINFO);
        MEDIA_TYPE_MAP.put("t", APPLICATION_X_TROFF);
        MEDIA_TYPE_MAP.put("tr", APPLICATION_X_TROFF);
        MEDIA_TYPE_MAP.put("roff", APPLICATION_X_TROFF);
        MEDIA_TYPE_MAP.put("au", AUDIO_BASIC);
        MEDIA_TYPE_MAP.put("midi", AUDIO_MIDI);
        MEDIA_TYPE_MAP.put("mid", AUDIO_MIDI);
        MEDIA_TYPE_MAP.put("aifc", AUDIO_X_AIFC);
        MEDIA_TYPE_MAP.put("aif", AUDIO_X_AIFF);
        MEDIA_TYPE_MAP.put("aiff", AUDIO_X_AIFF);
        MEDIA_TYPE_MAP.put("mpeg", AUDIO_X_MPEG);
        MEDIA_TYPE_MAP.put("mpg", AUDIO_X_MPEG);
        MEDIA_TYPE_MAP.put("wav", AUDIO_X_WAV);
        MEDIA_TYPE_MAP.put("gif", IMAGE_GIF);
        MEDIA_TYPE_MAP.put("ief", IMAGE_IEF);
        MEDIA_TYPE_MAP.put("jpeg", IMAGE_JPEG);
        MEDIA_TYPE_MAP.put("jpg", IMAGE_JPEG);
        MEDIA_TYPE_MAP.put("jpe", IMAGE_JPEG);
        MEDIA_TYPE_MAP.put("png", IMAGE_PNG);
        MEDIA_TYPE_MAP.put("tiff", IMAGE_TIFF);
        MEDIA_TYPE_MAP.put("tif", IMAGE_TIFF);
        MEDIA_TYPE_MAP.put("xwd", IMAGE_X_XWINDOWDUMP);
        MEDIA_TYPE_MAP.put("html", TEXT_HTML);
        MEDIA_TYPE_MAP.put("htm", TEXT_HTML);
        MEDIA_TYPE_MAP.put("xhtml", TEXT_HTML);
        MEDIA_TYPE_MAP.put("txt", TEXT_PLAIN);
        MEDIA_TYPE_MAP.put("text", TEXT_PLAIN);
        MEDIA_TYPE_MAP.put("xml", TEXT_XML);
        MEDIA_TYPE_MAP.put("mpeg", VIDEO_MEPG);
        MEDIA_TYPE_MAP.put("mpg", VIDEO_MEPG);
        MEDIA_TYPE_MAP.put("mpe", VIDEO_MEPG);
        MEDIA_TYPE_MAP.put("qt", VIDEO_QUICKTIME);
        MEDIA_TYPE_MAP.put("mov", VIDEO_QUICKTIME);
        MEDIA_TYPE_MAP.put("avi", VIDEO_X_MSVIDEO);
    }
}

