/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.bean.PropertyMap;
import org.apache.myfaces.trinidad.bean.ValueBindingValueExpression;
import org.apache.myfaces.trinidad.bean.ValueExpressionValueBinding;
import org.apache.myfaces.trinidad.bean.util.FlaggedPropertyMap;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FacesBeanImpl
implements FacesBean {
    private PropertyMap _properties;
    private PropertyMap _expressions;
    private transient boolean _initialStateMarked;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FacesBeanImpl.class);

    @Override
    public abstract FacesBean.Type getType();

    @Override
    public final Object getProperty(PropertyKey key) {
        ValueExpression expression;
        Object o = this.getLocalProperty(key);
        if (o != null) {
            return o;
        }
        if (key.getSupportsBinding() && (expression = this.getValueExpression(key)) != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            return expression.getValue(context.getELContext());
        }
        return null;
    }

    @Override
    public final Object getRawProperty(PropertyKey key) {
        Object local = this.getLocalProperty(key);
        if (local != null) {
            return local;
        }
        return key.getSupportsBinding() ? this.getValueExpression(key) : null;
    }

    @Override
    public void setProperty(PropertyKey key, Object value) {
        FacesBeanImpl._checkNotListKey(key);
        this.setPropertyImpl(key, value);
    }

    @Override
    public final Object getLocalProperty(PropertyKey key) {
        FacesBeanImpl._checkNotListKey(key);
        return this.getLocalPropertyImpl(key);
    }

    @Override
    public final ValueExpression getValueExpression(PropertyKey key) {
        FacesBeanImpl._checkNotListKey(key);
        PropertyMap map = this._getExpressionsMap(false);
        if (map == null) {
            return null;
        }
        return (ValueExpression)map.get(key);
    }

    @Override
    public final void setValueExpression(PropertyKey key, ValueExpression expression) {
        FacesBeanImpl._checkNotListKey(key);
        if (!key.getSupportsBinding()) {
            throw new IllegalArgumentException(_LOG.getMessage("CANNOT_FIND_PROPERTY", key.getName()));
        }
        if (expression == null) {
            PropertyMap map = this._getExpressionsMap(false);
            if (map != null) {
                map.remove(key);
            }
        } else {
            this._getExpressionsMap(true).put(key, expression);
        }
    }

    @Override
    public final ValueBinding getValueBinding(PropertyKey key) {
        ValueExpression ve = this.getValueExpression(key);
        if (ve == null) {
            return null;
        }
        return ValueExpressionValueBinding.getValueBinding(ve);
    }

    @Override
    public final void setValueBinding(PropertyKey key, ValueBinding binding) {
        ValueExpression ve = binding == null ? null : ValueBindingValueExpression.getValueExpression(binding);
        this.setValueExpression(key, ve);
    }

    @Override
    public final void addEntry(PropertyKey listKey, Object value) {
        FacesBeanImpl._checkListKey(listKey);
        List<Object> l = (List<Object>)this.getLocalPropertyImpl(listKey);
        if (l == null) {
            l = this._createList();
            this.setPropertyImpl(listKey, l);
        }
        l.add(value);
        if (this._initialStateMarked) {
            this.setPropertyImpl(listKey, l);
        }
    }

    @Override
    public final void removeEntry(PropertyKey listKey, Object value) {
        FacesBeanImpl._checkListKey(listKey);
        List l = (List)this.getLocalPropertyImpl(listKey);
        if (l != null) {
            l.remove(value);
        }
        if (this._initialStateMarked && l != null) {
            this.setPropertyImpl(listKey, l);
        }
    }

    public final Object[] getEntries(PropertyKey listKey, Class clazz) {
        FacesBeanImpl._checkListKey(listKey);
        List l = (List)this.getLocalPropertyImpl(listKey);
        if (l == null) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        int size = l.size();
        ArrayList tempList = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Object o = l.get(i);
            if (!clazz.isInstance(o)) continue;
            tempList.add(o);
        }
        return tempList.toArray((Object[])Array.newInstance(clazz, tempList.size()));
    }

    @Override
    public final boolean containsEntry(PropertyKey listKey, Class<?> clazz) {
        FacesBeanImpl._checkListKey(listKey);
        List l = (List)this.getLocalPropertyImpl(listKey);
        if (l == null) {
            return false;
        }
        int size = l.size();
        for (int i = 0; i < size; ++i) {
            Object o = l.get(i);
            if (!clazz.isInstance(o)) continue;
            return true;
        }
        return false;
    }

    public final Iterator<Object> entries(PropertyKey listKey) {
        FacesBeanImpl._checkListKey(listKey);
        List l = (List)this.getLocalPropertyImpl(listKey);
        if (l == null) {
            return Collections.emptyList().iterator();
        }
        return l.iterator();
    }

    @Override
    public void addAll(FacesBean from) {
        PropertyKey toKey;
        if (from == this) {
            return;
        }
        for (PropertyKey fromKey : from.keySet()) {
            toKey = this._convertKey(fromKey);
            if (toKey == null || !FacesBeanImpl._isCompatible(fromKey, toKey)) continue;
            if (!fromKey.isList()) {
                this.setProperty(toKey, from.getLocalProperty(fromKey));
                continue;
            }
            Iterator<? extends Object> entries = from.entries(fromKey);
            while (entries.hasNext()) {
                this.addEntry(toKey, entries.next());
            }
        }
        for (PropertyKey fromKey : from.bindingKeySet()) {
            toKey = this._convertKey(fromKey);
            if (!toKey.getSupportsBinding()) continue;
            this.setValueExpression(toKey, from.getValueExpression(fromKey));
        }
    }

    @Override
    public final Set<PropertyKey> keySet() {
        if (this._properties == null) {
            return Collections.emptySet();
        }
        return this._properties.keySet();
    }

    @Override
    public final Set<PropertyKey> bindingKeySet() {
        if (this._expressions == null) {
            return Collections.emptySet();
        }
        return this._expressions.keySet();
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
        if (this._properties != null) {
            this._properties.markInitialState();
        }
        if (this._expressions != null) {
            this._expressions.markInitialState();
        }
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (_LOG.isFiner()) {
            _LOG.finer("Restoring state into " + this);
        }
        if (state instanceof Object[]) {
            Object[] asArray = (Object[])state;
            if (asArray.length == 2) {
                Object propertyState = asArray[0];
                Object bindingsState = asArray[1];
                this._getPropertyMap().restoreState(context, this.getType(), propertyState);
                this._getExpressionsMap(true).restoreState(context, this.getType(), bindingsState);
                return;
            }
            if (asArray.length == 1) {
                Object propertyState = asArray[0];
                this._getPropertyMap().restoreState(context, this.getType(), propertyState);
                return;
            }
        }
        this._getPropertyMap().restoreState(context, this.getType(), state);
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] asArray;
        Object bindingsState;
        if (_LOG.isFiner()) {
            _LOG.finer("Saving state of " + this);
        }
        Object propertyState = this._properties == null ? null : this._properties.saveState(context);
        Object object = bindingsState = this._expressions == null ? null : this._expressions.saveState(context);
        if (bindingsState != null) {
            return new Object[]{propertyState, bindingsState};
        }
        if (propertyState == null) {
            return null;
        }
        if (propertyState instanceof Object[] && (asArray = (Object[])propertyState).length <= 2) {
            return new Object[]{propertyState};
        }
        return propertyState;
    }

    public String toString() {
        String className = this.getClass().getName();
        int lastPeriod = className.lastIndexOf(46);
        if (lastPeriod < 0) {
            return className;
        }
        return className.substring(lastPeriod + 1);
    }

    protected void setPropertyImpl(PropertyKey key, Object value) {
        if (value == null) {
            this._getPropertyMap().remove(key);
        } else {
            this._getPropertyMap().put(key, value);
        }
    }

    protected Object getLocalPropertyImpl(PropertyKey key) {
        return this._getPropertyMap().get(key);
    }

    protected PropertyMap createPropertyMap() {
        return new FlaggedPropertyMap();
    }

    protected PropertyMap createExpressionsMap() {
        return new FlaggedPropertyMap();
    }

    private List<Object> _createList() {
        return new ArrayList<Object>();
    }

    private PropertyKey _convertKey(PropertyKey fromKey) {
        FacesBean.Type type = this.getType();
        PropertyKey toKey = type.findKey(fromKey.getIndex());
        if (toKey == fromKey) {
            return toKey;
        }
        String name = fromKey.getName();
        toKey = type.findKey(name);
        if (toKey != null) {
            return toKey;
        }
        return new PropertyKey(name);
    }

    private static boolean _isCompatible(PropertyKey fromKey, PropertyKey toKey) {
        return fromKey.isList() == toKey.isList();
    }

    private PropertyMap _getPropertyMap() {
        if (this._properties == null) {
            this._properties = this.createPropertyMap();
        }
        return this._properties;
    }

    private PropertyMap _getExpressionsMap(boolean createIfNew) {
        if (this._expressions == null && createIfNew) {
            this._expressions = this.createExpressionsMap();
        }
        return this._expressions;
    }

    private static void _checkListKey(PropertyKey listKey) throws IllegalArgumentException {
        if (!listKey.isList()) {
            throw new IllegalArgumentException(_LOG.getMessage(">KEY_CANNOT_BE_USED_FOR_LISTS", listKey));
        }
    }

    private static void _checkNotListKey(PropertyKey key) throws IllegalArgumentException {
        if (key.isList()) {
            throw new IllegalArgumentException(_LOG.getMessage("KEY_IS_LIST_KEY", key));
        }
    }
}

