/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.common.junit4.Stoppable;
import org.apache.maven.surefire.util.internal.ConcurrencyUtils;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Notifier
extends RunNotifier
implements Stoppable {
    private final Collection<RunListener> listeners = new ArrayList<RunListener>();
    private final AtomicInteger skipAfterFailureCount;
    private final JUnit4RunListener reporter;

    public Notifier(JUnit4RunListener reporter, int skipAfterFailureCount) {
        this.addListener(reporter);
        this.reporter = reporter;
        this.skipAfterFailureCount = new AtomicInteger(skipAfterFailureCount);
    }

    @Override
    public void fireStopEvent() {
        if (ConcurrencyUtils.countDownToZero((AtomicInteger)this.skipAfterFailureCount)) {
            this.pleaseStop();
        }
        this.reporter.testExecutionSkippedByUser();
    }

    public void addListener(RunListener listener) {
        this.listeners.add(listener);
        super.addListener(listener);
    }

    public Notifier addListeners(Collection<RunListener> given) {
        for (RunListener listener : given) {
            this.addListener(listener);
        }
        return this;
    }

    public Notifier addListeners(RunListener ... given) {
        for (RunListener listener : given) {
            this.addListener(listener);
        }
        return this;
    }

    public void removeListener(RunListener listener) {
        this.listeners.remove(listener);
        super.removeListener(listener);
    }

    public void removeListeners() {
        Iterator<RunListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            RunListener listener = it.next();
            it.remove();
            super.removeListener(listener);
        }
    }
}

