/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitplatform;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.maven.surefire.api.report.OutputReportEntry;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.SafeThrowable;
import org.apache.maven.surefire.api.report.SimpleReportEntry;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.report.TestOutputReceiver;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestReportListener;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.api.util.internal.ObjectUtils;
import org.apache.maven.surefire.report.ClassMethodIndexer;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.RunModeSetter;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

final class RunListenerAdapter
implements TestExecutionListener,
TestOutputReceiver<OutputReportEntry>,
RunModeSetter {
    private final ClassMethodIndexer classMethodIndexer = new ClassMethodIndexer();
    private final ConcurrentMap<TestIdentifier, Long> testStartTime = new ConcurrentHashMap<TestIdentifier, Long>();
    private final ConcurrentMap<TestIdentifier, TestExecutionResult> failures = new ConcurrentHashMap<TestIdentifier, TestExecutionResult>();
    private final ConcurrentMap<String, TestIdentifier> runningTestIdentifiersByUniqueId = new ConcurrentHashMap<String, TestIdentifier>();
    private final TestReportListener<TestOutputReportEntry> runListener;
    private volatile TestPlan testPlan;
    private volatile RunMode runMode;

    RunListenerAdapter(TestReportListener<TestOutputReportEntry> runListener) {
        this.runListener = runListener;
    }

    public void setRunMode(RunMode runMode) {
        this.runMode = runMode;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.testPlan = null;
        this.testStartTime.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void executionStarted(TestIdentifier testIdentifier) {
        this.runningTestIdentifiersByUniqueId.put(testIdentifier.getUniqueId(), testIdentifier);
        if (testIdentifier.isContainer()) {
            if (testIdentifier.getSource().filter(ClassSource.class::isInstance).isPresent()) {
                this.testStartTime.put(testIdentifier, System.currentTimeMillis());
                this.runListener.testSetStarting((TestSetReportEntry)this.createReportEntry(testIdentifier));
                return;
            }
        }
        if (!testIdentifier.isTest()) return;
        this.testStartTime.put(testIdentifier, System.currentTimeMillis());
        this.runListener.testStarting((ReportEntry)this.createReportEntry(testIdentifier));
    }

    /*
     * Unable to fully structure code
     */
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (!testIdentifier.isContainer()) ** GOTO lbl-1000
        if (testIdentifier.getSource().filter((Predicate<TestSource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/junit/platform/engine/TestSource;)Z)(ClassSource.class)).isPresent()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isClass = v0;
        isTest = testIdentifier.isTest();
        failed = testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED;
        isAssertionError = testExecutionResult.getThrowable().filter((Predicate<Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Throwable;)Z)(AssertionError.class)).isPresent();
        v1 = isRootContainer = testIdentifier.isContainer() != false && testIdentifier.getParentId().isPresent() == false;
        if (failed || isClass || isTest) {
            elapsed = this.computeElapsedTime(testIdentifier);
            switch (1.$SwitchMap$org$junit$platform$engine$TestExecutionResult$Status[testExecutionResult.getStatus().ordinal()]) {
                case 1: {
                    if (isTest) {
                        this.runListener.testAssumptionFailure((ReportEntry)this.createReportEntry(testIdentifier, testExecutionResult, elapsed));
                        break;
                    }
                    this.runListener.testSetCompleted((TestSetReportEntry)this.createReportEntry(testIdentifier, testExecutionResult, ObjectUtils.systemProps(), null, elapsed));
                    break;
                }
                case 2: {
                    reason = this.safeGetMessage(testExecutionResult.getThrowable().orElse(null));
                    reportEntry = this.createReportEntry(testIdentifier, testExecutionResult, reason, elapsed);
                    if (isAssertionError) {
                        this.runListener.testFailed((ReportEntry)reportEntry);
                    } else {
                        this.runListener.testError((ReportEntry)reportEntry);
                    }
                    if (isClass || isRootContainer) {
                        this.runListener.testSetCompleted((TestSetReportEntry)this.createReportEntry(testIdentifier, null, ObjectUtils.systemProps(), null, elapsed));
                    }
                    this.failures.put(testIdentifier, testExecutionResult);
                    break;
                }
                default: {
                    if (isTest) {
                        this.runListener.testSucceeded((ReportEntry)this.createReportEntry(testIdentifier, null, elapsed));
                        break;
                    }
                    this.runListener.testSetCompleted((TestSetReportEntry)this.createReportEntry(testIdentifier, null, ObjectUtils.systemProps(), null, elapsed));
                }
            }
        }
        this.runningTestIdentifiersByUniqueId.remove(testIdentifier.getUniqueId());
    }

    private Integer computeElapsedTime(TestIdentifier testIdentifier) {
        Long startTime = (Long)this.testStartTime.remove(testIdentifier);
        long endTime = System.currentTimeMillis();
        return startTime == null ? null : Integer.valueOf((int)(endTime - startTime));
    }

    private Stream<TestIdentifier> collectAllTestIdentifiersInHierarchy(TestIdentifier testIdentifier) {
        return testIdentifier.getParentId().map(this.runningTestIdentifiersByUniqueId::get).map(parentTestIdentifier -> Stream.concat(Stream.of(parentTestIdentifier), this.collectAllTestIdentifiersInHierarchy((TestIdentifier)parentTestIdentifier))).orElseGet(Stream::empty);
    }

    private String safeGetMessage(Throwable throwable) {
        try {
            SafeThrowable t = throwable == null ? null : new SafeThrowable(throwable);
            return t == null ? null : t.getMessage();
        }
        catch (Throwable t) {
            return t.getMessage();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (!testIdentifier.isContainer()) ** GOTO lbl-1000
        if (testIdentifier.getSource().filter((Predicate<TestSource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/junit/platform/engine/TestSource;)Z)(ClassSource.class)).isPresent()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isClass = v0;
        isTest = testIdentifier.isTest();
        if (isClass) {
            report = this.createReportEntry(testIdentifier);
            this.runListener.testSetStarting((TestSetReportEntry)report);
            for (TestIdentifier child : this.testPlan.getChildren(testIdentifier)) {
                this.runListener.testSkipped((ReportEntry)this.createReportEntry(child, null, Collections.emptyMap(), reason, null));
            }
            this.runListener.testSetCompleted((TestSetReportEntry)report);
        } else if (isTest) {
            this.testStartTime.remove(testIdentifier);
            this.runListener.testSkipped((ReportEntry)this.createReportEntry(testIdentifier, null, Collections.emptyMap(), reason, null));
        }
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult, Map<String, String> systemProperties, String reason, Integer elapsedTime) {
        String methodText;
        String classText;
        String[] classMethodName = this.toClassMethodName(testIdentifier);
        String className = classMethodName[0];
        if (Objects.equals(className, classText = classMethodName[1])) {
            classText = null;
        }
        boolean failed = testExecutionResult != null && testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED;
        String methodName = failed || testIdentifier.isTest() ? classMethodName[2] : null;
        String string = methodText = failed || testIdentifier.isTest() ? classMethodName[3] : null;
        if (Objects.equals(methodName, methodText)) {
            methodText = null;
        }
        StackTraceWriter stw = testExecutionResult == null ? null : this.toStackTraceWriter(className, methodName, testExecutionResult);
        return new SimpleReportEntry(this.runMode, Long.valueOf(this.classMethodIndexer.indexClassMethod(className, methodName)), className, classText, methodName, methodText, stw, elapsedTime, reason, systemProperties);
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier) {
        return this.createReportEntry(testIdentifier, null, null);
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult, Integer elapsedTime) {
        return this.createReportEntry(testIdentifier, testExecutionResult, Collections.emptyMap(), null, elapsedTime);
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult, String reason, Integer elapsedTime) {
        return this.createReportEntry(testIdentifier, testExecutionResult, Collections.emptyMap(), reason, elapsedTime);
    }

    private StackTraceWriter toStackTraceWriter(String realClassName, String realMethodName, TestExecutionResult testExecutionResult) {
        switch (testExecutionResult.getStatus()) {
            case ABORTED: 
            case FAILED: {
                Throwable exception = testExecutionResult.getThrowable().orElse(null);
                return this.toStackTraceWriter(realClassName, realMethodName, exception);
            }
        }
        return testExecutionResult.getThrowable().map(t -> this.toStackTraceWriter(realClassName, realMethodName, (Throwable)t)).orElse(null);
    }

    private StackTraceWriter toStackTraceWriter(String realClassName, String realMethodName, Throwable throwable) {
        return new PojoStackTraceWriter(realClassName, realMethodName, throwable);
    }

    /*
     * Exception decompiling
     */
    private String[] toClassMethodName(TestIdentifier testIdentifier) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Map<TestIdentifier, TestExecutionResult> getFailures() {
        return this.failures;
    }

    boolean hasFailingTests() {
        return !this.getFailures().isEmpty();
    }

    void reset() {
        this.getFailures().clear();
        this.testPlan = null;
    }

    public void writeTestOutput(OutputReportEntry reportEntry) {
        Long testRunId = this.classMethodIndexer.getLocalIndex();
        this.runListener.writeTestOutput((OutputReportEntry)new TestOutputReportEntry(reportEntry, this.runMode, testRunId));
    }

    private static /* synthetic */ boolean lambda$toClassMethodName$7(TestIdentifier identifier) {
        return identifier.getSource().filter(ClassSource.class::isInstance).isPresent();
    }

    private static /* synthetic */ boolean lambda$toClassMethodName$6(String legacyReportingName) {
        return legacyReportingName.matches("^\\[.+]$");
    }

    private static /* synthetic */ boolean lambda$toClassMethodName$5(TestIdentifier identifier) {
        return !identifier.getSource().isPresent();
    }

    private static /* synthetic */ boolean lambda$toClassMethodName$4(TestIdentifier identifier) {
        return identifier.getSource().filter(MethodSource.class::isInstance).isPresent();
    }
}

