/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireReflector;
import org.apache.maven.surefire.providerapi.SurefireProvider;

public class ProviderFactory {
    private final StartupConfiguration startupConfiguration;
    private final ProviderConfiguration providerConfiguration;
    private final ClassLoader surefireClassLoader;
    private final ClassLoader testsClassLoader;
    private final SurefireReflector surefireReflector;
    static /* synthetic */ Class class$org$apache$maven$surefire$providerapi$SurefireProvider;

    public ProviderFactory(StartupConfiguration startupConfiguration, ProviderConfiguration providerConfiguration, ClassLoader surefireClassLoader, ClassLoader testsClassLoader) {
        this.providerConfiguration = providerConfiguration;
        this.surefireClassLoader = surefireClassLoader;
        this.startupConfiguration = startupConfiguration;
        this.surefireReflector = new SurefireReflector(surefireClassLoader);
        this.testsClassLoader = testsClassLoader;
    }

    public SurefireProvider createProvider() {
        ClassLoader context = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.surefireClassLoader);
        StartupConfiguration starterConfiguration = this.startupConfiguration;
        Object o = this.surefireReflector.createBooterConfiguration();
        this.surefireReflector.setTestSuiteDefinitionAware(o, this.providerConfiguration.getTestSuiteDefinition());
        this.surefireReflector.setProviderPropertiesAware(o, this.providerConfiguration.getProviderProperties());
        this.surefireReflector.setReporterConfigurationAware(o, this.providerConfiguration.getReporterConfiguration());
        this.surefireReflector.setTestClassLoaderAware(o, this.surefireClassLoader, this.testsClassLoader);
        this.surefireReflector.setTestArtifactInfoAware(o, this.providerConfiguration.getTestArtifact());
        this.surefireReflector.setIfDirScannerAware(o, this.providerConfiguration.getDirScannerParams());
        Object provider = this.surefireReflector.instantiateProvider(starterConfiguration.getProviderClassName(), o);
        Thread.currentThread().setContextClassLoader(context);
        return this.createClassLoaderProxy(provider);
    }

    private SurefireProvider createClassLoaderProxy(Object target) {
        return (SurefireProvider)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$org$apache$maven$surefire$providerapi$SurefireProvider == null ? (class$org$apache$maven$surefire$providerapi$SurefireProvider = ProviderFactory.class$("org.apache.maven.surefire.providerapi.SurefireProvider")) : class$org$apache$maven$surefire$providerapi$SurefireProvider}, (InvocationHandler)new ClassLoaderProxy(target));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ClassLoaderProxy
    implements InvocationHandler {
        private final Object target;

        public ClassLoaderProxy(Object delegate) {
            this.target = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ProviderFactory.this.testsClassLoader);
            try {
                Method delegateMethod = this.target.getClass().getMethod(method.getName(), method.getParameterTypes());
                Object result = delegateMethod.invoke(this.target, args);
                Object object = ProviderFactory.this.surefireReflector.convertIfRunResult(result);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
    }
}

