/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.it.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.it.util.FileUtils;
import org.apache.maven.it.util.IOUtil;

public class ResourceExtractor {
    public static File simpleExtractResources(Class cl, String resourcePath) throws IOException {
        String tempDirPath = System.getProperty("maven.test.tmpdir", System.getProperty("java.io.tmpdir"));
        File tempDir = new File(tempDirPath);
        File testDir = new File(tempDir, resourcePath);
        FileUtils.deleteDirectory(testDir);
        testDir = ResourceExtractor.extractResourcePath(cl, resourcePath, tempDir, false);
        return testDir;
    }

    public static File extractResourcePath(String resourcePath, File dest) throws IOException {
        return ResourceExtractor.extractResourcePath(ResourceExtractor.class, resourcePath, dest);
    }

    public static File extractResourcePath(Class cl, String resourcePath, File dest) throws IOException {
        return ResourceExtractor.extractResourcePath(cl, resourcePath, dest, false);
    }

    public static File extractResourcePath(Class cl, String resourcePath, File tempDir, boolean alwaysExtract) throws IOException {
        File dest = new File(tempDir, resourcePath);
        URL url = cl.getResource(resourcePath);
        if (url == null) {
            throw new IllegalArgumentException("Resource not found: " + resourcePath);
        }
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            File jarFile = ResourceExtractor.getJarFileFromUrl(url);
            ResourceExtractor.extractResourcePathFromJar(cl, jarFile, resourcePath, dest);
        } else {
            try {
                File resourceFile = new File(new URI(url.toExternalForm()));
                if (!alwaysExtract) {
                    return resourceFile;
                }
                if (resourceFile.isDirectory()) {
                    FileUtils.copyDirectoryStructure(resourceFile, dest);
                } else {
                    FileUtils.copyFile(resourceFile, dest);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Couldn't convert URL to File:" + url, e);
            }
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractResourcePathFromJar(Class cl, File jarFile, String resourcePath, File dest) throws IOException {
        ZipFile z = new ZipFile(jarFile, 1);
        String zipStyleResourcePath = resourcePath.substring(1) + "/";
        ZipEntry ze = z.getEntry(zipStyleResourcePath);
        if (ze != null) {
            Enumeration<? extends ZipEntry> entries = z.entries();
            while (entries.hasMoreElements()) {
                ze = entries.nextElement();
                if (!ze.getName().startsWith(zipStyleResourcePath)) continue;
                String relativePath = ze.getName().substring(zipStyleResourcePath.length());
                File destFile = new File(dest, relativePath);
                if (ze.isDirectory()) {
                    destFile.mkdirs();
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(destFile);
                try {
                    IOUtil.copy(z.getInputStream(ze), (OutputStream)fos);
                }
                finally {
                    IOUtil.close(fos);
                }
            }
        } else {
            FileOutputStream fos = new FileOutputStream(dest);
            try {
                IOUtil.copy(cl.getResourceAsStream(resourcePath), (OutputStream)fos);
            }
            finally {
                IOUtil.close(fos);
            }
        }
    }

    private static File getJarFileFromUrl(URL url) {
        if (!"jar".equalsIgnoreCase(url.getProtocol())) {
            throw new IllegalArgumentException("This is not a Jar URL:" + url.toString());
        }
        String resourceFilePath = url.getFile();
        int index = resourceFilePath.indexOf("!");
        if (index == -1) {
            throw new RuntimeException("Bug! " + url.toExternalForm() + " does not have a '!'");
        }
        String jarFileURI = resourceFilePath.substring(0, index);
        try {
            File jarFile = new File(new URI(jarFileURI));
            return jarFile;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bug! URI failed to parse: " + jarFileURI, e);
        }
    }
}

