/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.cli;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.shared.utils.Os;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.cli.CommandLineCallable;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineTimeOutException;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.ShutdownHookUtils;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.shared.utils.cli.StreamFeeder;
import org.apache.maven.shared.utils.cli.StreamPumper;

public abstract class CommandLineUtils {
    public static int executeCommandLine(@Nonnull Commandline cl, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, null, systemOut, systemErr, 0);
    }

    public static int executeCommandLine(@Nonnull Commandline cl, StreamConsumer systemOut, StreamConsumer systemErr, int timeoutInSeconds) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, null, systemOut, systemErr, timeoutInSeconds);
    }

    public static int executeCommandLine(@Nonnull Commandline cl, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, systemIn, systemOut, systemErr, 0);
    }

    public static int executeCommandLine(@Nonnull Commandline cl, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr, int timeoutInSeconds) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, systemIn, systemOut, systemErr, timeoutInSeconds, null);
    }

    public static int executeCommandLine(@Nonnull Commandline cl, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr, int timeoutInSeconds, @Nullable Runnable runAfterProcessTermination) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, systemIn, systemOut, systemErr, timeoutInSeconds, runAfterProcessTermination, null);
    }

    public static int executeCommandLine(@Nonnull Commandline cl, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr, int timeoutInSeconds, @Nullable Runnable runAfterProcessTermination, @Nullable Charset streamCharset) throws CommandLineException {
        CommandLineCallable future = CommandLineUtils.executeCommandLineAsCallable(cl, systemIn, systemOut, systemErr, timeoutInSeconds, runAfterProcessTermination, streamCharset);
        return future.call();
    }

    public static CommandLineCallable executeCommandLineAsCallable(@Nonnull Commandline cl, @Nullable InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr, int timeoutInSeconds, @Nullable Runnable runAfterProcessTermination) throws CommandLineException {
        return CommandLineUtils.executeCommandLineAsCallable(cl, systemIn, systemOut, systemErr, timeoutInSeconds, runAfterProcessTermination, null);
    }

    public static CommandLineCallable executeCommandLineAsCallable(@Nonnull Commandline cl, final @Nullable InputStream systemIn, final StreamConsumer systemOut, final StreamConsumer systemErr, final int timeoutInSeconds, final @Nullable Runnable runAfterProcessTermination, @Nullable Charset streamCharset) throws CommandLineException {
        if (cl == null) {
            throw new IllegalArgumentException("cl cannot be null.");
        }
        final Process p = cl.execute();
        final Thread processHook = new Thread(){
            {
                this.setName("CommandLineUtils process shutdown hook");
                this.setContextClassLoader(null);
            }

            @Override
            public void run() {
                p.destroy();
            }
        };
        ShutdownHookUtils.addShutDownHook(processHook);
        return new CommandLineCallable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws CommandLineException {
                StreamFeeder inputFeeder = null;
                StreamPumper outputPumper = null;
                StreamPumper errorPumper = null;
                try {
                    if (systemIn != null) {
                        inputFeeder = new StreamFeeder(systemIn, p.getOutputStream());
                        inputFeeder.setName("StreamFeeder-systemIn");
                        inputFeeder.start();
                    }
                    outputPumper = new StreamPumper(p.getInputStream(), systemOut);
                    outputPumper.setName("StreamPumper-systemOut");
                    outputPumper.start();
                    errorPumper = new StreamPumper(p.getErrorStream(), systemErr);
                    errorPumper.setName("StreamPumper-systemErr");
                    errorPumper.start();
                    if (timeoutInSeconds > 0 && !p.waitFor(timeoutInSeconds, TimeUnit.SECONDS)) {
                        throw new CommandLineTimeOutException(String.format("Process timed out after %d seconds.", timeoutInSeconds));
                    }
                    int returnValue = p.waitFor();
                    if (inputFeeder != null) {
                        inputFeeder.waitUntilDone();
                    }
                    outputPumper.waitUntilDone();
                    errorPumper.waitUntilDone();
                    if (inputFeeder != null && inputFeeder.getException() != null) {
                        throw new CommandLineException("Failure processing stdin.", inputFeeder.getException());
                    }
                    if (outputPumper.getException() != null) {
                        throw new CommandLineException("Failure processing stdout.", outputPumper.getException());
                    }
                    if (errorPumper.getException() != null) {
                        throw new CommandLineException("Failure processing stderr.", errorPumper.getException());
                    }
                    Integer n = returnValue;
                    return n;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new CommandLineTimeOutException("Error while executing external command, process killed.", ex);
                }
                finally {
                    if (outputPumper != null) {
                        outputPumper.disable();
                    }
                    if (errorPumper != null) {
                        errorPumper.disable();
                    }
                    try {
                        if (runAfterProcessTermination != null) {
                            runAfterProcessTermination.run();
                        }
                    }
                    finally {
                        ShutdownHookUtils.removeShutdownHook(processHook);
                        processHook.run();
                    }
                }
            }
        };
    }

    @Deprecated
    public static Properties getSystemEnvVars() {
        return CommandLineUtils.getSystemEnvVars(!Os.isFamily("windows"));
    }

    @Deprecated
    public static Properties getSystemEnvVars(boolean caseSensitive) {
        Map<String, String> envs = System.getenv();
        return CommandLineUtils.ensureCaseSensitivity(envs, caseSensitive);
    }

    public static String[] translateCommandline(String toProcess) throws CommandLineException {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        boolean inEscape = false;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' \\", true);
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        if (inEscape) {
                            current.append(nextTok);
                            inEscape = false;
                            continue block4;
                        }
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    inEscape = "\\".equals(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        if (inEscape) {
                            current.append(nextTok);
                            inEscape = false;
                            continue block4;
                        }
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    inEscape = "\\".equals(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                if (inEscape) {
                    inEscape = false;
                    current.append(nextTok);
                    continue;
                }
                state = 1;
                continue;
            }
            if ("\"".equals(nextTok)) {
                if (inEscape) {
                    inEscape = false;
                    current.append(nextTok);
                    continue;
                }
                state = 2;
                continue;
            }
            if (" ".equals(nextTok)) {
                if (current.length() == 0) continue;
                tokens.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(nextTok);
            inEscape = "\\".equals(nextTok);
        }
        if (current.length() != 0) {
            tokens.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new CommandLineException("unbalanced quotes in " + toProcess);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String toString(String ... line) {
        if (line == null || line.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < line.length; ++i) {
            if (i > 0) {
                result.append(' ');
            }
            result.append(StringUtils.quoteAndEscape(line[i], '\"'));
        }
        return result.toString();
    }

    static Properties ensureCaseSensitivity(Map<String, String> envs, boolean preserveKeyCase) {
        Properties envVars = new Properties();
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            envVars.put(!preserveKeyCase ? entry.getKey().toUpperCase(Locale.ENGLISH) : entry.getKey(), entry.getValue());
        }
        return envVars;
    }

    public static class StringStreamConsumer
    implements StreamConsumer {
        private final StringBuilder string = new StringBuilder();
        private static final String LS = System.getProperty("line.separator", "\n");

        @Override
        public void consumeLine(String line) {
            this.string.append(line).append(LS);
        }

        public String getOutput() {
            return this.string.toString();
        }
    }
}

