/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.maven.shared.runtime.ClassUtils;
import org.apache.maven.shared.runtime.MavenRuntimeException;
import org.apache.maven.shared.runtime.MavenRuntimeVisitor;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MavenRuntimeVisitorUtils {
    private static final String MAVEN_PATH = "META-INF/maven";
    private static final String[] PROPERTIES_PATH_TOKENS = new String[]{"META-INF", "maven", null, null, "pom.properties"};
    private static final String[] XML_PATH_TOKENS = new String[]{"META-INF", "maven", null, null, "pom.xml"};
    private static final int GROUP_ID_TOKEN_INDEX = 2;
    private static final int ARTIFACT_ID_TOKEN_INDEX = 3;

    private MavenRuntimeVisitorUtils() {
        throw new AssertionError();
    }

    public static void accept(ClassLoader classLoader, MavenRuntimeVisitor visitor) throws MavenRuntimeException {
        Enumeration<URL> urls;
        try {
            urls = classLoader.getResources(MAVEN_PATH);
        }
        catch (IOException exception) {
            throw new MavenRuntimeException("Cannot obtain Maven metadata from class loader: " + classLoader, exception);
        }
        HashSet<String> visitedProjectProperties = new HashSet<String>();
        HashSet<String> visitedProjectXML = new HashSet<String>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            MavenRuntimeVisitorUtils.acceptURL(url, visitor, visitedProjectProperties, visitedProjectXML);
        }
    }

    public static void accept(Class<?> klass, MavenRuntimeVisitor visitor) throws MavenRuntimeException {
        try {
            URL baseURL = ClassUtils.getBaseURL(klass);
            URL url = new URL(baseURL, MAVEN_PATH);
            MavenRuntimeVisitorUtils.acceptURL(url, visitor, new HashSet<String>(), new HashSet<String>());
        }
        catch (MalformedURLException exception) {
            throw new MavenRuntimeException("Cannot obtain URL for class: " + klass.getName(), exception);
        }
    }

    public static void accept(URL url, MavenRuntimeVisitor visitor) throws MavenRuntimeException {
        try {
            if ("jar".equals(url.getProtocol())) {
                url = MavenRuntimeVisitorUtils.getJarFileURL(url);
            }
            URL baseURL = MavenRuntimeVisitorUtils.getJarEntryURL(url, "");
            URL mavenURL = new URL(baseURL, MAVEN_PATH);
            MavenRuntimeVisitorUtils.acceptURL(mavenURL, visitor, new HashSet<String>(), new HashSet<String>());
        }
        catch (MalformedURLException exception) {
            throw new MavenRuntimeException("Cannot obtain URL for Jar: " + url, exception);
        }
    }

    private static void acceptURL(URL url, MavenRuntimeVisitor visitor, Set<String> visitedProjectProperties, Set<String> visitedProjectXML) throws MavenRuntimeException {
        if ("jar".equals(url.getProtocol())) {
            URL jarURL;
            try {
                jarURL = MavenRuntimeVisitorUtils.getJarFileURL(url);
            }
            catch (MalformedURLException exception) {
                throw new MavenRuntimeException("Cannot obtain Jar file URL for URL: " + url, exception);
            }
            MavenRuntimeVisitorUtils.acceptJar(jarURL, visitor, visitedProjectProperties, visitedProjectXML);
        }
    }

    private static void acceptJar(URL url, MavenRuntimeVisitor visitor, Set<String> visitedProjectProperties, Set<String> visitedProjectXML) throws MavenRuntimeException {
        JarInputStream in = null;
        try {
            JarEntry entry;
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            in = new JarInputStream(connection.getInputStream());
            while ((entry = in.getNextJarEntry()) != null) {
                MavenRuntimeVisitorUtils.acceptJarEntry(url, entry, visitor, visitedProjectProperties, visitedProjectXML);
            }
        }
        catch (IOException exception) {
            try {
                throw new MavenRuntimeException("Cannot read jar", exception);
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)in);
    }

    private static void acceptJarEntry(URL jarURL, JarEntry entry, MavenRuntimeVisitor visitor, Set<String> visitedProjectProperties, Set<String> visitedProjectXML) throws MavenRuntimeException {
        String name = entry.getName();
        try {
            String projectId;
            URL url = MavenRuntimeVisitorUtils.getJarEntryURL(jarURL, entry.getName());
            if (MavenRuntimeVisitorUtils.isProjectPropertiesPath(name)) {
                String projectId2 = MavenRuntimeVisitorUtils.getProjectId(name);
                if (!visitedProjectProperties.contains(projectId2)) {
                    visitor.visitProjectProperties(url);
                    visitedProjectProperties.add(projectId2);
                }
            } else if (MavenRuntimeVisitorUtils.isProjectXMLPath(name) && !visitedProjectXML.contains(projectId = MavenRuntimeVisitorUtils.getProjectId(name))) {
                visitor.visitProjectXML(url);
                visitedProjectXML.add(projectId);
            }
        }
        catch (MalformedURLException exception) {
            throw new MavenRuntimeException("Cannot read jar entry", exception);
        }
    }

    private static URL getJarFileURL(URL url) throws MalformedURLException {
        if (!"jar".equals(url.getProtocol())) {
            return url;
        }
        String path = url.getPath();
        int index = path.indexOf("!/");
        if (index != -1) {
            path = path.substring(0, index);
        }
        return new URL(path);
    }

    private static URL getJarEntryURL(URL jarURL, String entryName) throws MalformedURLException {
        return new URL("jar:" + jarURL + "!/" + entryName);
    }

    private static String getProjectId(String path) {
        String[] tokens = path.split("/");
        String groupId = tokens[2];
        String artifactId = tokens[3];
        return groupId + ":" + artifactId;
    }

    private static boolean isProjectPropertiesPath(String path) {
        return MavenRuntimeVisitorUtils.matches(PROPERTIES_PATH_TOKENS, path.split("/"));
    }

    private static boolean isProjectXMLPath(String path) {
        return MavenRuntimeVisitorUtils.matches(XML_PATH_TOKENS, path.split("/"));
    }

    private static boolean matches(String[] matchTokens, String[] tokens) {
        if (tokens.length != matchTokens.length) {
            return false;
        }
        for (int i = 0; i < tokens.length; ++i) {
            if (matchTokens[i] == null || tokens[i].equals(matchTokens[i])) continue;
            return false;
        }
        return true;
    }
}

