/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.bazaar.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;

public class BazaarConsumer
extends AbstractConsumer {
    private static final Map IDENTIFIERS = new HashMap();
    private static final Map MESSAGES = new HashMap();
    private static final int MAX_STDERR_SIZE = 10;
    private final List stderr = new ArrayList();

    public BazaarConsumer(ScmLogger logger) {
        super(logger);
    }

    public void doConsume(ScmFileStatus status, String trimmedLine) {
    }

    public void consumeLine(String line) {
        String trimmedLine;
        String statusStr;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(line);
        }
        if ((statusStr = BazaarConsumer.processInputForKnownIdentifiers(trimmedLine = line.trim())) == null) {
            boolean isMessage = this.processInputForKnownMessages(trimmedLine);
            if (isMessage) {
                return;
            }
        } else {
            trimmedLine = trimmedLine.substring(statusStr.length());
            trimmedLine = trimmedLine.trim();
        }
        ScmFileStatus status = statusStr != null ? (ScmFileStatus)IDENTIFIERS.get(statusStr.intern()) : null;
        this.doConsume(status, trimmedLine);
    }

    public String getStdErr() {
        String str = "";
        Iterator it = this.stderr.iterator();
        while (it.hasNext()) {
            str = str + it.next();
        }
        return str;
    }

    private static String processInputForKnownIdentifiers(String line) {
        Iterator it = IDENTIFIERS.keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            if (!line.startsWith(id)) continue;
            return id;
        }
        return null;
    }

    private boolean processInputForKnownMessages(String line) {
        Iterator it = MESSAGES.keySet().iterator();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            if (!line.startsWith(prefix)) continue;
            this.stderr.add(line);
            if (this.stderr.size() > 10) {
                this.stderr.remove(0);
            }
            String message = line.substring(prefix.length());
            if (MESSAGES.get(prefix).equals("WARNING")) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn(message);
                }
            } else if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error(message);
            }
            return true;
        }
        return false;
    }

    static {
        IDENTIFIERS.put("added", ScmFileStatus.ADDED);
        IDENTIFIERS.put("unknown", ScmFileStatus.UNKNOWN);
        IDENTIFIERS.put("modified", ScmFileStatus.MODIFIED);
        IDENTIFIERS.put("removed", ScmFileStatus.DELETED);
        IDENTIFIERS.put("renamed", ScmFileStatus.MODIFIED);
        MESSAGES.put("bzr: WARNING:", "WARNING");
        MESSAGES.put("bzr: ERROR:", "ERROR");
        MESSAGES.put("'bzr' ", "ERROR");
    }
}

