/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev.cli;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.accurev.Transaction;
import org.apache.maven.scm.provider.accurev.cli.XppStreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryConsumer
extends XppStreamConsumer {
    private List<Transaction> transactions;
    private Transaction currentTran;
    private Long elementId;
    private String elementName;

    public HistoryConsumer(ScmLogger logger, List<Transaction> transactions) {
        super(logger);
        this.transactions = transactions;
    }

    @Override
    protected void startTag(List<String> tagPath, Map<String, String> attributes) {
        String tagName = HistoryConsumer.getTagName(tagPath);
        if ("transaction".equals(tagName)) {
            Long id = Long.parseLong(attributes.get("id"));
            Date when = new Date(Long.parseLong(attributes.get("time")) * 1000L);
            String tranType = attributes.get("type");
            String user = attributes.get("user");
            this.currentTran = new Transaction(id, when, tranType, user);
            this.transactions.add(this.currentTran);
        } else if ("version".equals(tagName)) {
            if (this.currentTran != null) {
                if (attributes.containsKey("eid")) {
                    this.elementId = Long.parseLong(attributes.get("eid"));
                    this.elementName = attributes.get("path");
                }
                String virtualSpec = attributes.get("virtual");
                String realSpec = attributes.get("real");
                String ancestor = attributes.get("ancestor");
                this.currentTran.addVersion(this.elementId, this.elementName, virtualSpec, realSpec, ancestor);
            }
        } else if ("element".equals(tagName)) {
            this.elementId = Long.parseLong(attributes.get("eid"));
            this.elementName = attributes.get("name");
        }
    }

    @Override
    protected void endTag(List<String> tagPath) {
        String tagName = HistoryConsumer.getTagName(tagPath);
        if ("element".equals(tagName)) {
            this.elementId = null;
            this.elementName = null;
        } else if ("transaction".equals(tagName)) {
            this.currentTran = null;
        }
    }

    @Override
    protected void text(List<String> tagPath, String text) {
        String tagName = HistoryConsumer.getTagName(tagPath);
        if (this.currentTran != null && "comment".equals(tagName)) {
            this.currentTran.setComment(text);
        }
    }
}

