/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.TestSuiteXmlParser;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.xml.sax.SAXException;

public class SurefireReportParser {
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private File[] reportsDirectories;
    private List testSuites = new ArrayList();
    private static final int PCENT = 100;

    public SurefireReportParser() {
    }

    public SurefireReportParser(File[] reportsDirectories, Locale locale) {
        this.reportsDirectories = reportsDirectories;
        this.setLocale(locale);
    }

    public List parseXMLReportFiles() throws MavenReportException {
        ArrayList<File> xmlReportFileList = new ArrayList<File>();
        for (int i = 0; i < this.reportsDirectories.length; ++i) {
            File reportsDirectory = this.reportsDirectories[i];
            if (!reportsDirectory.exists()) continue;
            String[] xmlReportFiles = this.getIncludedFiles(reportsDirectory, "*.xml", "*.txt, testng-failed.xml, testng-failures.xml, testng-results.xml");
            for (int j = 0; j < xmlReportFiles.length; ++j) {
                File xmlReport = new File(reportsDirectory, xmlReportFiles[j]);
                xmlReportFileList.add(xmlReport);
            }
        }
        TestSuiteXmlParser parser = new TestSuiteXmlParser();
        for (int index = 0; index < xmlReportFileList.size(); ++index) {
            Collection suites;
            File currentReport = (File)xmlReportFileList.get(index);
            try {
                suites = parser.parse(currentReport.getAbsolutePath());
            }
            catch (ParserConfigurationException e) {
                throw new MavenReportException("Error setting up parser for JUnit XML report", (Exception)e);
            }
            catch (SAXException e) {
                throw new MavenReportException("Error parsing JUnit XML report " + currentReport, (Exception)e);
            }
            catch (IOException e) {
                throw new MavenReportException("Error reading JUnit XML report " + currentReport, (Exception)e);
            }
            this.testSuites.addAll(suites);
        }
        return this.testSuites;
    }

    protected String parseTestSuiteName(String lineString) {
        return lineString.substring(lineString.lastIndexOf(".") + 1, lineString.length());
    }

    protected String parseTestSuitePackageName(String lineString) {
        return lineString.substring(lineString.indexOf(":") + 2, lineString.lastIndexOf("."));
    }

    protected String parseTestCaseName(String lineString) {
        return lineString.substring(0, lineString.indexOf("("));
    }

    public Map getSummary(List suites) {
        HashMap<String, String> totalSummary = new HashMap<String, String>();
        ListIterator iter = suites.listIterator();
        int totalNumberOfTests = 0;
        int totalNumberOfErrors = 0;
        int totalNumberOfFailures = 0;
        int totalNumberOfSkipped = 0;
        float totalElapsedTime = 0.0f;
        while (iter.hasNext()) {
            ReportTestSuite suite = (ReportTestSuite)iter.next();
            totalNumberOfTests += suite.getNumberOfTests();
            totalNumberOfErrors += suite.getNumberOfErrors();
            totalNumberOfFailures += suite.getNumberOfFailures();
            totalNumberOfSkipped += suite.getNumberOfSkipped();
            totalElapsedTime += suite.getTimeElapsed();
        }
        String totalPercentage = this.computePercentage(totalNumberOfTests, totalNumberOfErrors, totalNumberOfFailures, totalNumberOfSkipped);
        totalSummary.put("totalTests", Integer.toString(totalNumberOfTests));
        totalSummary.put("totalErrors", Integer.toString(totalNumberOfErrors));
        totalSummary.put("totalFailures", Integer.toString(totalNumberOfFailures));
        totalSummary.put("totalSkipped", Integer.toString(totalNumberOfSkipped));
        totalSummary.put("totalElapsedTime", this.numberFormat.format(totalElapsedTime));
        totalSummary.put("totalPercentage", totalPercentage);
        return totalSummary;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectories = new File[]{reportsDirectory};
    }

    public void setReportsDirectories(File[] reportsDirectories) {
        this.reportsDirectories = reportsDirectories;
    }

    public File[] getReportsDirectories() {
        return this.reportsDirectories;
    }

    public final void setLocale(Locale locale) {
        this.numberFormat = NumberFormat.getInstance(locale);
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public Map getSuitesGroupByPackage(List testSuitesList) {
        ListIterator iter = testSuitesList.listIterator();
        HashMap suitePackage = new HashMap();
        while (iter.hasNext()) {
            ReportTestSuite suite = (ReportTestSuite)iter.next();
            List<ReportTestSuite> suiteList = new ArrayList<ReportTestSuite>();
            if (suitePackage.get(suite.getPackageName()) != null) {
                suiteList = (List)suitePackage.get(suite.getPackageName());
            }
            suiteList.add(suite);
            suitePackage.put(suite.getPackageName(), suiteList);
        }
        return suitePackage;
    }

    public String computePercentage(int tests, int errors, int failures, int skipped) {
        float percentage = tests == 0 ? 0.0f : (float)(tests - errors - failures - skipped) / (float)tests * 100.0f;
        return this.numberFormat.format(percentage);
    }

    public List getFailureDetails(List testSuitesList) {
        ListIterator iter = testSuitesList.listIterator();
        ArrayList<ReportTestCase> failureDetailList = new ArrayList<ReportTestCase>();
        while (iter.hasNext()) {
            ReportTestSuite suite = (ReportTestSuite)iter.next();
            List testCaseList = suite.getTestCases();
            if (testCaseList == null) continue;
            ListIterator caseIter = testCaseList.listIterator();
            while (caseIter.hasNext()) {
                ReportTestCase tCase = (ReportTestCase)caseIter.next();
                if (tCase.getFailure() == null) continue;
                failureDetailList.add(tCase);
            }
        }
        return failureDetailList;
    }

    private String[] getIncludedFiles(File directory, String includes, String excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(StringUtils.split((String)includes, (String)","));
        scanner.setExcludes(StringUtils.split((String)excludes, (String)","));
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

