/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Writer;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.site.render.AbstractSiteRenderingMojo;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.XmlWriterUtil;

@Mojo(name="effective-site", requiresReports=true)
public class EffectiveSiteMojo
extends AbstractSiteRenderingMojo {
    @Parameter(property="output")
    protected File output;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String effectiveSite;
        try {
            List localesList = this.siteTool.getAvailableLocales(this.locales);
            SiteRenderingContext context = this.createSiteRenderingContext((Locale)localesList.get(0));
            DecorationModel decorationModel = context.getDecoration();
            StringWriter w = new StringWriter();
            PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, StringUtils.repeat((String)" ", (int)2), decorationModel.getModelEncoding(), null);
            EffectiveSiteMojo.writeHeader((XMLWriter)writer);
            this.writeEffectiveSite(decorationModel, (XMLWriter)writer);
            effectiveSite = w.toString();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during site descriptor calculation", (Exception)e);
        }
        if (this.output != null) {
            try {
                EffectiveSiteMojo.writeXmlFile(this.output, effectiveSite);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write effective site descriptor to output: " + this.output, (Exception)e);
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Effective site descriptor written to: " + this.output));
            }
        } else {
            StringBuilder message = new StringBuilder();
            message.append("\nEffective site descriptor, after inheritance and interpolation:\n\n");
            message.append(effectiveSite);
            message.append("\n");
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)message.toString());
            }
        }
    }

    protected static void writeHeader(XMLWriter writer) {
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)("Generated by Maven Site Plugin on " + dateFormat.format(new Date(System.currentTimeMillis()))));
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)"See: http://maven.apache.org/plugins/maven-site-plugin/");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    protected static void writeComment(XMLWriter writer, String comment) {
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)comment);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    private void writeEffectiveSite(DecorationModel decorationModel, XMLWriter writer) throws MojoExecutionException {
        StringWriter sWriter = new StringWriter();
        DecorationXpp3Writer siteWriter = new DecorationXpp3Writer();
        try {
            siteWriter.write((Writer)sWriter, decorationModel);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot serialize site descriptor to XML.", (Exception)e);
        }
        String effectiveSite = sWriter.toString();
        effectiveSite = effectiveSite.substring(effectiveSite.indexOf("<project "));
        EffectiveSiteMojo.writeComment(writer, "Effective site descriptor for project '" + this.project.getId() + "'");
        writer.writeMarkup(effectiveSite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeXmlFile(File output, String content) throws IOException {
        XmlStreamWriter out = null;
        try {
            output.getParentFile().mkdirs();
            out = WriterFactory.newXmlWriter((File)output);
            out.write(content);
            out.flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((Writer)out);
    }
}

