/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.descriptor;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.AbstractArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;
import org.apache.maven.doxia.site.SiteModel;
import org.apache.maven.doxia.site.io.xpp3.SiteXpp3Writer;
import org.apache.maven.repository.legacy.metadata.ArtifactMetadata;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class SiteDescriptorArtifactMetadata
extends AbstractArtifactMetadata {
    private final SiteModel siteModel;
    private final File file;

    public SiteDescriptorArtifactMetadata(Artifact artifact, SiteModel siteModel, File file) {
        super(artifact);
        this.file = file;
        this.siteModel = siteModel;
    }

    public String getRemoteFilename() {
        return this.getFilename();
    }

    public String getLocalFilename(ArtifactRepository repository) {
        return this.getFilename();
    }

    private String getFilename() {
        return this.getArtifactId() + "-" + this.artifact.getVersion() + "-" + this.file.getName();
    }

    public void storeInLocalRepository(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataStoreException {
        File destination = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata((org.apache.maven.artifact.metadata.ArtifactMetadata)this, remoteRepository));
        if (!destination.getParentFile().mkdirs()) {
            throw new RepositoryMetadataStoreException("Could not create artifact directory " + destination + " in local repository");
        }
        try (XmlStreamWriter writer = new XmlStreamWriter(destination);){
            new SiteXpp3Writer().write((Writer)writer, this.siteModel);
        }
        catch (IOException e) {
            throw new RepositoryMetadataStoreException("Error saving in local repository", (Exception)e);
        }
    }

    public String toString() {
        return "site descriptor for " + this.artifact.getArtifactId() + " " + this.artifact.getVersion() + " " + this.file.getName();
    }

    public boolean storedInArtifactVersionDirectory() {
        return true;
    }

    public String getBaseVersion() {
        return this.artifact.getBaseVersion();
    }

    public Object getKey() {
        return "site descriptor " + this.artifact.getGroupId() + ":" + this.artifact.getArtifactId() + " " + this.file.getName();
    }

    public void merge(org.apache.maven.artifact.metadata.ArtifactMetadata metadata) {
        SiteDescriptorArtifactMetadata m = (SiteDescriptorArtifactMetadata)metadata;
        if (!m.file.equals(this.file)) {
            throw new IllegalStateException("Cannot add two different pieces of metadata for: " + this.getKey());
        }
    }

    public void merge(ArtifactMetadata metadata) {
    }
}

