/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;

public class ServicesResourceTransformer
implements ResourceTransformer {
    private static final String SERVICES_PATH = "META-INF/services";
    private Map serviceEntries = new HashMap();

    public boolean canTransformResource(String resource) {
        return resource.startsWith(SERVICES_PATH);
    }

    public void processResource(String resource, InputStream is, List relocators) throws IOException {
        ServiceStream out = (ServiceStream)this.serviceEntries.get(resource);
        if (out == null) {
            out = new ServiceStream();
            this.serviceEntries.put(resource, out);
        }
        out.append(is);
        is.close();
    }

    public boolean hasTransformedResource() {
        return this.serviceEntries.size() > 0;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        for (String key : this.serviceEntries.keySet()) {
            ServiceStream data = (ServiceStream)this.serviceEntries.get(key);
            jos.putNextEntry(new JarEntry(key));
            IOUtil.copy((InputStream)data.toInputStream(), (OutputStream)jos);
            data.reset();
        }
    }

    static class ServiceStream
    extends ByteArrayOutputStream {
        public ServiceStream() {
            super(1024);
        }

        public void append(InputStream is) throws IOException {
            if (this.count > 0 && this.buf[this.count - 1] != 10 && this.buf[this.count - 1] != 13) {
                this.write(10);
            }
            IOUtil.copy((InputStream)is, (OutputStream)this);
        }

        public InputStream toInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

