/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.scmpublish;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.svn.AbstractSvnScmProvider;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScmPublishMojo
extends AbstractMojo {
    @Parameter(property="scmpublish.pubScmUrl", defaultValue="${project.distributionManagement.site.url}", required=true)
    protected String pubScmUrl;
    @Parameter(property="scmpublish.checkoutDirectory", defaultValue="${project.build.directory}/scmpublish-checkout")
    protected File checkoutDirectory;
    @Parameter(property="scmpublish.dryRun")
    private boolean dryRun;
    @Parameter(property="scmpublish.skipCheckin")
    private boolean skipCheckin;
    @Parameter(property="scmpublish.checkinComment", defaultValue="Site checkin for project ${project.name}")
    private String checkinComment;
    @Parameter
    protected String excludes;
    @Parameter
    protected String includes;
    @Parameter
    private Map<String, String> providerImplementations;
    @Component
    private ScmManager scmManager;
    @Component
    protected ScmRepositoryConfigurator scmRepositoryConfigurator;
    @Parameter(property="username")
    protected String username;
    @Parameter(property="password")
    protected String password;
    @Parameter(property="localCheckout", defaultValue="false")
    protected boolean localCheckout;
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    protected String siteOutputEncoding;
    @Parameter(property="scmpublish.tryUpdate", defaultValue="false")
    protected boolean tryUpdate;
    @Parameter(property="scmpublish.skipDeletedFiles", defaultValue="false")
    protected boolean skipDeletedFiles;
    @Parameter(defaultValue="${basedir}", readonly=true)
    protected File basedir;
    @Component
    protected Settings settings;
    @Parameter
    protected String[] ignorePathsToDelete;
    @Parameter(property="scmpublish.scm.branch")
    protected String scmBranch;
    @Parameter(property="scmpublish.automaticRemotePathCreation", defaultValue="true")
    protected boolean automaticRemotePathCreation;
    private static final String[] NORMALIZE_EXTENSIONS = new String[]{"html", "css", "js"};
    @Parameter
    protected String[] extraNormalizeExtensions;
    protected ScmProvider scmProvider;
    protected ScmRepository scmRepository;

    protected void logInfo(String format, Object ... params) {
        this.getLog().info((CharSequence)String.format(format, params));
    }

    protected void logWarn(String format, Object ... params) {
        this.getLog().warn((CharSequence)String.format(format, params));
    }

    protected void logError(String format, Object ... params) {
        this.getLog().error((CharSequence)String.format(format, params));
    }

    private File relativize(File base, File file) {
        return new File(base.toURI().relativize(file.toURI()).getPath());
    }

    protected boolean requireNormalizeNewlines(File f) throws IOException {
        List<String> extensions = Arrays.asList(NORMALIZE_EXTENSIONS);
        if (this.extraNormalizeExtensions != null) {
            extensions.addAll(Arrays.asList(this.extraNormalizeExtensions));
        }
        return FilenameUtils.isExtension((String)f.getName(), extensions);
    }

    private ReleaseDescriptor setupScm() throws ScmRepositoryException, NoSuchScmProviderException {
        if (this.localCheckout) {
            String providerPart = this.pubScmUrl.substring(0, this.pubScmUrl.indexOf(58, 4));
            String scmUrl = providerPart + ":file://" + "target/localCheckout";
            this.logInfo("Performing a LOCAL checkout from " + scmUrl, new Object[0]);
        }
        ReleaseDescriptor releaseDescriptor = new ReleaseDescriptor();
        releaseDescriptor.setInteractive(this.settings.isInteractiveMode());
        releaseDescriptor.setScmPassword(this.password);
        releaseDescriptor.setScmUsername(this.username);
        releaseDescriptor.setWorkingDirectory(this.basedir.getAbsolutePath());
        releaseDescriptor.setLocalCheckout(this.localCheckout);
        releaseDescriptor.setScmSourceUrl(this.pubScmUrl);
        if (this.providerImplementations != null) {
            for (Map.Entry<String, String> providerEntry : this.providerImplementations.entrySet()) {
                this.logInfo("Changing the default '%s' provider implementation to '%s'.", providerEntry.getKey(), providerEntry.getValue());
                this.scmManager.setScmProviderImplementation(providerEntry.getKey(), providerEntry.getValue());
            }
        }
        this.scmRepository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, this.settings);
        this.scmProvider = this.scmRepositoryConfigurator.getRepositoryProvider(this.scmRepository);
        return releaseDescriptor;
    }

    protected void checkoutExisting() throws MojoExecutionException {
        if (this.scmProvider instanceof AbstractSvnScmProvider) {
            this.checkCreateRemoteSvnPath();
        }
        this.logInfo("%s the pub tree from  %s ...", this.tryUpdate ? "Updating" : "Checking out", this.pubScmUrl);
        if (this.checkoutDirectory.exists() && !this.tryUpdate) {
            try {
                FileUtils.deleteDirectory((File)this.checkoutDirectory);
            }
            catch (IOException e) {
                this.logError(e.getMessage(), new Object[0]);
                throw new MojoExecutionException("Unable to remove old checkout directory: " + e.getMessage(), (Exception)e);
            }
        }
        boolean forceCheckout = false;
        if (!this.checkoutDirectory.exists()) {
            if (this.tryUpdate) {
                this.logInfo("TryUpdate is configured but no local copy currently available: forcing checkout.", new Object[0]);
            }
            this.checkoutDirectory.mkdirs();
            forceCheckout = true;
        }
        try {
            UpdateScmResult scmResult;
            ScmFileSet fileSet = new ScmFileSet(this.checkoutDirectory, this.includes, this.excludes);
            if (this.tryUpdate && !forceCheckout) {
                scmResult = this.scmProvider.update(this.scmRepository, fileSet);
            } else if (this.scmBranch == null) {
                scmResult = this.scmProvider.checkOut(this.scmRepository, fileSet);
            } else {
                ScmBranch scmBranch = new ScmBranch(this.scmBranch);
                scmResult = this.scmProvider.checkOut(this.scmRepository, fileSet, (ScmVersion)scmBranch);
            }
            this.checkScmResult(scmResult, "check out from SCM");
        }
        catch (ScmException e) {
            this.logError(e.getMessage(), new Object[0]);
            throw new MojoExecutionException("An error occurred during the checkout process: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            this.logError(e.getMessage(), new Object[0]);
            throw new MojoExecutionException("An error occurred during the checkout process: " + e.getMessage(), (Exception)e);
        }
    }

    private void checkCreateRemoteSvnPath() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"AbstractSvnScmProvider used, so we can check if remote url exists and eventually create it.");
        AbstractSvnScmProvider svnScmProvider = (AbstractSvnScmProvider)this.scmProvider;
        try {
            boolean remoteExists = svnScmProvider.remoteUrlExist(this.scmRepository.getProviderRepository(), null);
            if (remoteExists) {
                return;
            }
        }
        catch (ScmException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        String remoteUrl = ((SvnScmProviderRepository)this.scmRepository.getProviderRepository()).getUrl();
        if (!this.automaticRemotePathCreation) {
            this.logWarn("Remote svn url %s does not exist and automatic remote path creation disabled.", remoteUrl);
            return;
        }
        this.logInfo("Remote svn url %s does not exist: creating.", remoteUrl);
        File baseDir = null;
        try {
            baseDir = File.createTempFile("scm", "tmp");
            baseDir.delete();
            baseDir.mkdirs();
            ScmFileSet scmFileSet = new ScmFileSet(baseDir, new File(""));
            CommandParameters commandParameters = new CommandParameters();
            commandParameters.setString(CommandParameter.SCM_MKDIR_CREATE_IN_LOCAL, Boolean.FALSE.toString());
            commandParameters.setString(CommandParameter.MESSAGE, "Automatic svn path creation: " + remoteUrl);
            svnScmProvider.mkdir(this.scmRepository.getProviderRepository(), scmFileSet, commandParameters);
            if (this.checkoutDirectory.exists()) {
                FileUtils.deleteDirectory((File)this.checkoutDirectory);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (ScmException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (baseDir != null) {
                try {
                    FileUtils.forceDeleteOnExit((File)baseDir);
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.setupScm();
        }
        catch (ScmRepositoryException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (NoSuchScmProviderException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        boolean tmpCheckout = false;
        if (this.checkoutDirectory.getPath().contains("${project.")) {
            try {
                tmpCheckout = true;
                this.checkoutDirectory = File.createTempFile("maven-scm-publish", ".checkout");
                this.checkoutDirectory.delete();
                this.checkoutDirectory.mkdir();
            }
            catch (IOException ioe) {
                throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
            }
        }
        try {
            this.scmPublishExecute();
        }
        finally {
            if (tmpCheckout) {
                FileUtils.deleteQuietly((File)this.checkoutDirectory);
            }
        }
    }

    protected void checkinFiles() throws MojoExecutionException {
        if (this.skipCheckin) {
            return;
        }
        ScmFileSet updatedFileSet = new ScmFileSet(this.checkoutDirectory);
        try {
            this.logInfo("Checking in to the scm", new Object[0]);
            CheckInScmResult checkinResult = this.checkScmResult(this.scmProvider.checkIn(this.scmRepository, updatedFileSet, (ScmVersion)new ScmBranch(this.scmBranch), this.checkinComment), "check-in files to SCM");
            this.logInfo("Checked in %d file(s) to revision: %s", checkinResult.getCheckedInFiles().size(), checkinResult.getScmRevision());
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Failed to perform SCM checkin", (Exception)((Object)e));
        }
    }

    protected void deleteFiles(Collection<File> deleted) throws MojoExecutionException {
        if (this.skipDeletedFiles) {
            this.logInfo("Deleting files is skipped.", new Object[0]);
            return;
        }
        ArrayList<File> deletedList = new ArrayList<File>();
        for (File f : deleted) {
            deletedList.add(this.relativize(this.checkoutDirectory, f));
        }
        ScmFileSet deletedFileSet = new ScmFileSet(this.checkoutDirectory, deletedList);
        try {
            this.getLog().debug((CharSequence)("Deleting files: " + deletedList));
            this.checkScmResult(this.scmProvider.remove(this.scmRepository, deletedFileSet, "Deleting obsolete site files."), "delete files from SCM");
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Failed to delete removed files to SCM", (Exception)((Object)e));
        }
    }

    protected void addFiles(Collection<File> added) throws MojoFailureException, MojoExecutionException {
        ArrayList<File> addedList = new ArrayList<File>();
        HashSet<File> createdDirs = new HashSet<File>();
        TreeSet<File> dirsToAdd = new TreeSet<File>();
        createdDirs.add(this.relativize(this.checkoutDirectory, this.checkoutDirectory));
        for (File f : added) {
            File relativized;
            File dir = f.getParentFile();
            while (!dir.equals(this.checkoutDirectory) && createdDirs.add(relativized = this.relativize(this.checkoutDirectory, dir))) {
                dirsToAdd.add(relativized);
                dir = dir.getParentFile();
            }
            addedList.add(this.relativize(this.checkoutDirectory, f));
        }
        for (File relativized : dirsToAdd) {
            try {
                ScmFileSet fileSet = new ScmFileSet(this.checkoutDirectory, relativized);
                this.getLog().debug((CharSequence)("scm add directory: " + relativized));
                AddScmResult addDirResult = this.scmProvider.add(this.scmRepository, fileSet, "Adding directory");
                if (addDirResult.isSuccess()) continue;
                this.getLog().debug((CharSequence)(" Error adding directory " + relativized + ": " + addDirResult.getCommandOutput()));
            }
            catch (ScmException e) {}
        }
        addedList.removeAll(dirsToAdd);
        ScmFileSet addedFileSet = new ScmFileSet(this.checkoutDirectory, addedList);
        this.getLog().debug((CharSequence)("scm add files: " + addedList));
        try {
            CommandParameters commandParameters = new CommandParameters();
            commandParameters.setString(CommandParameter.MESSAGE, "Adding new site files.");
            commandParameters.setString(CommandParameter.FORCE_ADD, Boolean.TRUE.toString());
            this.checkScmResult(this.scmProvider.add(this.scmRepository, addedFileSet, commandParameters), "add new files to SCM");
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Failed to add new files to SCM", (Exception)((Object)e));
        }
    }

    private <T extends ScmResult> T checkScmResult(T result, String failure) throws MojoExecutionException {
        if (!result.isSuccess()) {
            String msg = "Failed to " + failure + ": " + result.getProviderMessage() + " " + result.getCommandOutput();
            this.logError(msg, new Object[0]);
            throw new MojoExecutionException(msg);
        }
        return result;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public abstract void scmPublishExecute() throws MojoExecutionException, MojoFailureException;
}

