/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.i18n.I18N;

public abstract class AbstractProjectInfoReport
extends AbstractMavenReport {
    protected SiteTool siteTool;
    protected Renderer siteRenderer;
    protected ArtifactResolver resolver;
    protected ArtifactFactory factory;
    protected I18N i18n;
    protected File outputDirectory;
    protected MavenProject project;
    protected ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            return;
        }
        try {
            DecorationModel model = new DecorationModel();
            model.setBody(new Body());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("outputEncoding", "UTF-8");
            attributes.put("project", (String)this.project);
            Locale locale = Locale.getDefault();
            Artifact defaultSkin = this.siteTool.getDefaultSkinArtifact(this.localRepository, this.project.getRemoteArtifactRepositories());
            SiteRenderingContext siteContext = this.siteRenderer.createContextForSkin(defaultSkin.getFile(), attributes, model, this.getName(locale), locale);
            RenderingContext context = new RenderingContext(this.outputDirectory, this.getOutputName() + ".html");
            SiteRendererSink sink = new SiteRendererSink(context);
            this.generate((Sink)sink, locale);
            this.outputDirectory.mkdirs();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.outputDirectory, this.getOutputName() + ".html")), "UTF-8");
            this.siteRenderer.generateDocument((Writer)writer, sink, siteContext);
            this.siteRenderer.copyResources(siteContext, new File(this.project.getBasedir(), "src/site/resources"), this.outputDirectory);
        }
        catch (RendererException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)e);
        }
        catch (SiteToolException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
        }
    }

    public String getCategoryName() {
        return "Project Info";
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }
}

