/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import net.sourceforge.pmd.RuleViolation;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.pmd.AbstractPmdReport;
import org.apache.maven.plugin.pmd.PmdFileInfo;
import org.codehaus.plexus.util.StringUtils;

public class PmdReportGenerator {
    private Log log;
    private Sink sink;
    private String currentFilename;
    private ResourceBundle bundle;
    private HashSet<RuleViolation> violations = new HashSet();
    private boolean aggregate;
    private int fileCount = 0;
    private Map<File, PmdFileInfo> files;

    public PmdReportGenerator(Log log, Sink sink, ResourceBundle bundle, boolean aggregate) {
        this.log = log;
        this.sink = sink;
        this.bundle = bundle;
        this.aggregate = aggregate;
    }

    private String getTitle() {
        return this.bundle.getString("report.pmd.title");
    }

    public void setViolations(Collection<RuleViolation> violations) {
        this.violations = new HashSet<RuleViolation>(violations);
    }

    public List<RuleViolation> getViolations() {
        return new ArrayList<RuleViolation>(this.violations);
    }

    private void startFileSection(String currentFilename, PmdFileInfo fileInfo) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.currentFilename = currentFilename;
        if (fileInfo != null && fileInfo.getSourceDirectory() != null) {
            this.currentFilename = StringUtils.substring((String)currentFilename, (int)(fileInfo.getSourceDirectory().getAbsolutePath().length() + 1));
        }
        String title = this.currentFilename = StringUtils.replace((String)this.currentFilename, (String)"\\", (String)"/");
        if (this.aggregate && fileInfo != null && fileInfo.getProject() != null) {
            title = fileInfo.getProject().getName() + " - " + this.currentFilename;
        }
        this.sink.text(title);
        this.sink.sectionTitle2_();
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.pmd.column.violation"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.pmd.column.line"));
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
    }

    private void endFileSection() {
        this.sink.table_();
        this.sink.section2_();
    }

    private void processSingleRuleViolation(RuleViolation ruleViolation, PmdFileInfo fileInfo) {
        this.sink.tableRow();
        this.sink.tableCell();
        this.sink.text(ruleViolation.getDescription());
        this.sink.tableCell_();
        this.sink.tableCell();
        int beginLine = ruleViolation.getBeginLine();
        this.outputLineLink(beginLine, fileInfo);
        int endLine = ruleViolation.getEndLine();
        if (endLine != beginLine) {
            this.sink.text("&#x2013;");
            this.outputLineLink(endLine, fileInfo);
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    private void processViolations() throws IOException {
        this.fileCount = this.files.size();
        ArrayList<RuleViolation> violations2 = new ArrayList<RuleViolation>(this.violations);
        Collections.sort(violations2, new Comparator<RuleViolation>(){

            @Override
            public int compare(RuleViolation o1, RuleViolation o2) {
                int filenames = o1.getFilename().compareTo(o2.getFilename());
                if (filenames == 0) {
                    return o1.getBeginLine() - o2.getBeginLine();
                }
                return filenames;
            }
        });
        boolean fileSectionStarted = false;
        String previousFilename = null;
        for (RuleViolation ruleViolation : violations2) {
            String currentFn = ruleViolation.getFilename();
            File canonicalFilename = new File(currentFn).getCanonicalFile();
            PmdFileInfo fileInfo = this.files.get(canonicalFilename);
            if (fileInfo == null) {
                this.log.warn((CharSequence)("Couldn't determine PmdFileInfo for file " + currentFn + " (canonical: " + canonicalFilename + "). XRef links won't be available."));
            }
            if (!currentFn.equalsIgnoreCase(previousFilename) && fileSectionStarted) {
                this.endFileSection();
                fileSectionStarted = false;
            }
            if (!fileSectionStarted) {
                this.startFileSection(currentFn, fileInfo);
                fileSectionStarted = true;
            }
            this.processSingleRuleViolation(ruleViolation, fileInfo);
            previousFilename = currentFn;
        }
        if (fileSectionStarted) {
            this.endFileSection();
        }
    }

    private void outputLineLink(int line, PmdFileInfo fileInfo) {
        String xrefLocation = null;
        if (fileInfo != null) {
            xrefLocation = fileInfo.getXrefLocation();
        }
        if (xrefLocation != null) {
            this.sink.link(xrefLocation + "/" + this.currentFilename.replaceAll("\\.java$", ".html") + "#L" + line);
        }
        this.sink.text(String.valueOf(line));
        if (xrefLocation != null) {
            this.sink.link_();
        }
    }

    public void beginDocument() {
        this.sink.head();
        this.sink.title();
        this.sink.text(this.getTitle());
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getTitle());
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.bundle.getString("report.pmd.pmdlink") + " ");
        this.sink.link("http://pmd.sourceforge.net/");
        this.sink.text("PMD");
        this.sink.link_();
        this.sink.text(" " + AbstractPmdReport.getPmdVersion() + ".");
        this.sink.paragraph_();
        this.sink.section1_();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.pmd.files"));
        this.sink.sectionTitle1_();
    }

    public void render() throws IOException {
        this.processViolations();
    }

    public void endDocument() throws IOException {
        if (this.fileCount == 0) {
            this.sink.paragraph();
            this.sink.text(this.bundle.getString("report.pmd.noProblems"));
            this.sink.paragraph_();
        }
        this.sink.section1_();
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }

    public void setFiles(Map<File, PmdFileInfo> files) {
        this.files = files;
    }
}

