/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.EcmascriptLanguage;
import net.sourceforge.pmd.cpd.JSPLanguage;
import net.sourceforge.pmd.cpd.JavaLanguage;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import org.apache.maven.plugin.pmd.AbstractPmdReport;
import org.apache.maven.plugin.pmd.CpdReportGenerator;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;

@Mojo(name="cpd", threadSafe=true)
public class CpdReport
extends AbstractPmdReport {
    @Parameter(defaultValue="java")
    private String language;
    @Parameter(property="minimumTokens", defaultValue="100")
    private int minimumTokens;
    @Parameter(property="cpd.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="cpd.ignoreLiterals", defaultValue="false")
    private boolean ignoreLiterals;
    @Parameter(property="cpd.ignoreIdentifiers", defaultValue="false")
    private boolean ignoreIdentifiers;
    private CPD cpd;

    public String getName(Locale locale) {
        return CpdReport.getBundle(locale).getString("report.cpd.name");
    }

    public String getDescription(Locale locale) {
        return CpdReport.getBundle(locale).getString("report.cpd.description");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeReport(Locale locale) throws MavenReportException {
        try {
            this.execute(locale);
        }
        finally {
            if (this.getSink() != null) {
                this.getSink().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Locale locale) throws MavenReportException {
        if (!this.skip && this.canGenerateReport()) {
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                this.generateReport(locale);
                if (!this.isHtml() && !this.isXml()) {
                    this.writeNonHtml(this.cpd);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
    }

    @Override
    public boolean canGenerateReport() {
        if (this.skip) {
            return false;
        }
        boolean result = super.canGenerateReport();
        if (result) {
            try {
                this.executeCpdWithClassloader();
                if (this.skipEmptyReport && (result = this.cpd.getMatches().hasNext())) {
                    this.getLog().debug((CharSequence)"Skipping report since skipEmptyReport is true and there are no CPD issues.");
                }
            }
            catch (MavenReportException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCpdWithClassloader() throws MavenReportException {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.executeCpd();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    private void executeCpd() throws MavenReportException {
        if (this.cpd != null) {
            this.getLog().debug((CharSequence)"CPD has already been run - skipping redundant execution.");
            return;
        }
        Properties p = new Properties();
        if (this.ignoreLiterals) {
            p.setProperty("ignore_literals", "true");
        }
        if (this.ignoreIdentifiers) {
            p.setProperty("ignore_identifiers", "true");
        }
        try {
            if (this.filesToProcess == null) {
                this.filesToProcess = this.getFilesToProcess();
            }
            String encoding = this.determineEncoding(!this.filesToProcess.isEmpty());
            Object cpdLanguage = "java".equals(this.language) || null == this.language ? new JavaLanguage(p) : ("javascript".equals(this.language) ? new EcmascriptLanguage() : ("jsp".equals(this.language) ? new JSPLanguage() : LanguageFactory.createLanguage((String)this.language, (Properties)p)));
            CPDConfiguration cpdConfiguration = new CPDConfiguration();
            cpdConfiguration.setMinimumTileSize(this.minimumTokens);
            cpdConfiguration.setLanguage((Language)cpdLanguage);
            cpdConfiguration.setSourceEncoding(encoding);
            this.cpd = new CPD(cpdConfiguration);
            for (File file : this.filesToProcess.keySet()) {
                this.cpd.add(file);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new MavenReportException("Encoding '" + this.getSourceEncoding() + "' is not supported.", (Exception)e);
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        this.getLog().debug((CharSequence)"Executing CPD...");
        this.cpd.go();
        this.getLog().debug((CharSequence)"CPD finished.");
        if (this.isXml()) {
            this.writeNonHtml(this.cpd);
        }
    }

    private void generateReport(Locale locale) {
        CpdReportGenerator gen = new CpdReportGenerator(this.getSink(), this.filesToProcess, CpdReport.getBundle(locale), this.aggregate);
        gen.generate(this.cpd.getMatches());
    }

    private String determineEncoding(boolean showWarn) throws UnsupportedEncodingException {
        String encoding = WriterFactory.FILE_ENCODING;
        if (StringUtils.isNotEmpty((String)this.getSourceEncoding())) {
            encoding = this.getSourceEncoding();
            WriterFactory.newWriter((OutputStream)new ByteArrayOutputStream(), (String)encoding);
        } else if (showWarn) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + WriterFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            encoding = WriterFactory.FILE_ENCODING;
        }
        return encoding;
    }

    void writeNonHtml(CPD cpd) throws MavenReportException {
        Renderer r = this.createRenderer();
        if (r == null) {
            return;
        }
        String buffer = r.render(cpd.getMatches());
        FileOutputStream tStream = null;
        OutputStreamWriter writer = null;
        try {
            this.targetDirectory.mkdirs();
            File targetFile = new File(this.targetDirectory, "cpd." + this.format);
            tStream = new FileOutputStream(targetFile);
            writer = new OutputStreamWriter((OutputStream)tStream, this.getOutputEncoding());
            writer.write(buffer);
            ((Writer)writer).close();
            if (this.includeXmlInSite) {
                File siteDir = this.getReportOutputDirectory();
                siteDir.mkdirs();
                FileUtils.copyFile((File)targetFile, (File)new File(siteDir, "cpd." + this.format));
            }
        }
        catch (IOException ioe) {
            try {
                throw new MavenReportException(ioe.getMessage(), (Exception)ioe);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                IOUtil.close(tStream);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        IOUtil.close((OutputStream)tStream);
    }

    public String getOutputName() {
        return "cpd";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("cpd-report", locale, CpdReport.class.getClassLoader());
    }

    public Renderer createRenderer() throws MavenReportException {
        XMLRenderer renderer = null;
        if ("xml".equals(this.format)) {
            renderer = new XMLRenderer(this.getOutputEncoding());
        } else if ("csv".equals(this.format)) {
            renderer = new CSVRenderer();
        } else if (!"".equals(this.format) && !"none".equals(this.format)) {
            try {
                renderer = (Renderer)Class.forName(this.format).newInstance();
            }
            catch (Exception e) {
                throw new MavenReportException("Can't find CPD custom format " + this.format + ": " + e.getClass().getName(), e);
            }
        }
        return renderer;
    }
}

