/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.pmd.ViolationDetails;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractPmdViolationCheckMojo<D>
extends AbstractMojo {
    @Parameter(property="project.build.directory", required=true)
    private File targetDirectory;
    @Parameter(property="pmd.failOnViolation", defaultValue="true", required=true)
    protected boolean failOnViolation;
    @Parameter(property="project.artifact.artifactHandler.language", required=true, readonly=true)
    private String language;
    @Parameter(property="aggregate", defaultValue="false")
    protected boolean aggregate;
    @Parameter(property="pmd.verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="pmd.printFailingErrors", defaultValue="false")
    private boolean printFailingErrors;
    @Parameter(property="pmd.excludeFromFailureFile", defaultValue="")
    private String excludeFromFailureFile;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;

    protected void executeCheck(String filename, String tagName, String key, int failurePriority) throws MojoFailureException, MojoExecutionException {
        if (this.aggregate && !this.project.isExecutionRoot()) {
            return;
        }
        if ("java".equals(this.language) || "jsp".equals(this.language) || this.aggregate) {
            File outputFile;
            if (!StringUtils.isEmpty((String)this.excludeFromFailureFile)) {
                this.loadExcludeFromFailuresData(this.excludeFromFailureFile);
            }
            if ((outputFile = new File(this.targetDirectory, filename)).exists()) {
                try {
                    ViolationDetails<D> violations = this.getViolations(outputFile, failurePriority);
                    List<D> failures = violations.getFailureDetails();
                    List<D> warnings = violations.getWarningDetails();
                    if (this.verbose) {
                        this.printErrors(failures, warnings);
                    }
                    int failureCount = failures.size();
                    int warningCount = warnings.size();
                    String message = this.getMessage(failureCount, warningCount, key, outputFile);
                    this.getLog().debug((CharSequence)("PMD failureCount: " + failureCount + ", warningCount: " + warningCount));
                    if (failureCount > 0 && this.isFailOnViolation()) {
                        throw new MojoFailureException(message);
                    }
                    this.getLog().info((CharSequence)message);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to read PMD results xml: " + outputFile.getAbsolutePath(), (Exception)e);
                }
                catch (XmlPullParserException e) {
                    throw new MojoExecutionException("Unable to read PMD results xml: " + outputFile.getAbsolutePath(), (Exception)((Object)e));
                }
            } else {
                throw new MojoFailureException("Unable to perform check, unable to find " + outputFile);
            }
        }
    }

    protected abstract void loadExcludeFromFailuresData(String var1) throws MojoExecutionException;

    private ViolationDetails<D> getViolations(File analysisFile, int failurePriority) throws XmlPullParserException, IOException {
        ArrayList<D> failures = new ArrayList<D>();
        ArrayList<D> warnings = new ArrayList<D>();
        List<D> violations = this.getErrorDetails(analysisFile);
        for (D violation : violations) {
            int priority = this.getPriority(violation);
            if (priority <= failurePriority && !this.isExcludedFromFailure(violation)) {
                failures.add(violation);
                if (!this.printFailingErrors) continue;
                this.printError(violation, "Failure");
                continue;
            }
            warnings.add(violation);
        }
        ViolationDetails details = this.newViolationDetailsInstance();
        details.setFailureDetails(failures);
        details.setWarningDetails(warnings);
        return details;
    }

    protected abstract int getPriority(D var1);

    protected abstract boolean isExcludedFromFailure(D var1);

    protected abstract ViolationDetails<D> newViolationDetailsInstance();

    protected void printErrors(List<D> failures, List<D> warnings) {
        for (D warning : warnings) {
            this.printError(warning, "Warning");
        }
        for (D failure : failures) {
            this.printError(failure, "Failure");
        }
    }

    private String getMessage(int failureCount, int warningCount, String key, File outputFile) {
        StringBuilder message = new StringBuilder(256);
        if (failureCount > 0 || warningCount > 0) {
            if (failureCount > 0) {
                message.append("You have ").append(failureCount).append(" ").append(key).append(failureCount > 1 ? "s" : "");
            }
            if (warningCount > 0) {
                if (failureCount > 0) {
                    message.append(" and ");
                } else {
                    message.append("You have ");
                }
                message.append(warningCount).append(" warning").append(warningCount > 1 ? "s" : "");
            }
            message.append(". For more details see: ").append(outputFile.getAbsolutePath());
        }
        return message.toString();
    }

    protected abstract void printError(D var1, String var2);

    protected abstract List<D> getErrorDetails(File var1) throws XmlPullParserException, IOException;

    public boolean isFailOnViolation() {
        return this.failOnViolation;
    }
}

