/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd.exec;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugins.pmd.model.PmdErrorDetail;
import org.apache.maven.plugins.pmd.model.PmdFile;
import org.apache.maven.plugins.pmd.model.ProcessingError;
import org.apache.maven.plugins.pmd.model.SuppressedViolation;
import org.apache.maven.plugins.pmd.model.Violation;
import org.apache.maven.plugins.pmd.model.io.xpp3.PmdXpp3Reader;
import org.apache.maven.reporting.MavenReportException;

public class PmdResult {
    private final List<ProcessingError> processingErrors = new ArrayList<ProcessingError>();
    private final List<Violation> violations = new ArrayList<Violation>();
    private final List<SuppressedViolation> suppressedViolations = new ArrayList<SuppressedViolation>();
    public static final PmdResult EMPTY = new PmdResult();

    private PmdResult() {
    }

    public PmdResult(File pmdFile, String encoding) throws MavenReportException {
        this.loadResult(pmdFile, encoding);
    }

    public boolean hasViolations() {
        return !this.violations.isEmpty();
    }

    private void loadResult(File pmdFile, String encoding) throws MavenReportException {
        try (BomFilter reader1 = new BomFilter(encoding, new InputStreamReader((InputStream)new FileInputStream(pmdFile), encoding));){
            PmdXpp3Reader reader = new PmdXpp3Reader();
            PmdErrorDetail details = reader.read(reader1, false);
            this.processingErrors.addAll(details.getErrors());
            this.suppressedViolations.addAll(details.getSuppressedViolations());
            for (PmdFile file : details.getFiles()) {
                String filename = file.getName();
                for (Violation violation : file.getViolations()) {
                    violation.setFileName(filename);
                    this.violations.add(violation);
                }
            }
        }
        catch (Exception e) {
            throw new MavenReportException(e.getMessage(), e);
        }
    }

    public Collection<Violation> getViolations() {
        return this.violations;
    }

    public Collection<SuppressedViolation> getSuppressedViolations() {
        return this.suppressedViolations;
    }

    public Collection<ProcessingError> getErrors() {
        return this.processingErrors;
    }

    private static class BomFilter
    extends FilterReader {
        private static final char BOM = '\ufeff';
        private final boolean filter;

        BomFilter(String encoding, Reader in) {
            super(in);
            this.filter = !"UTF-8".equalsIgnoreCase(encoding);
        }

        @Override
        public int read() throws IOException {
            int c = super.read();
            if (!this.filter) {
                return c;
            }
            while (c == 65279) {
                c = super.read();
            }
            return c;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int count = super.read(cbuf, off, len);
            if (!this.filter) {
                return count;
            }
            if (count != -1) {
                for (int i = off; i < off + count; ++i) {
                    if (cbuf[i] != '\ufeff') continue;
                    System.arraycopy(cbuf, i + 1, cbuf, i, off + count - 1 - i);
                    --count;
                }
            }
            return count;
        }
    }
}

