/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.stat.Metric;
import org.apache.maven.plugin.pmd.PmdFileInfo;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;

public class PmdReportListener
implements ReportListener {
    private Sink sink;
    private String currentFilename;
    private boolean fileInitialized;
    private ResourceBundle bundle;
    private PmdFileInfo fileInfo;
    private List violations = new ArrayList();
    private boolean aggregate;
    private int fileCount = 0;

    public PmdReportListener(Sink sink, ResourceBundle bundle, boolean aggregate) {
        this.sink = sink;
        this.bundle = bundle;
        this.aggregate = aggregate;
    }

    private String getTitle() {
        return this.bundle.getString("report.pmd.title");
    }

    public void ruleViolationAdded(IRuleViolation ruleViolation) {
        if (!this.fileInitialized) {
            this.sink.section2();
            this.sink.sectionTitle2();
            String title = this.currentFilename;
            if (this.aggregate) {
                title = this.fileInfo.getProject().getName() + " - " + this.currentFilename;
            }
            this.sink.text(title);
            this.sink.sectionTitle2_();
            this.sink.table();
            this.sink.tableRow();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.pmd.column.violation"));
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.pmd.column.line"));
            this.sink.tableHeaderCell_();
            this.sink.tableRow_();
            this.fileInitialized = true;
        }
        this.violations.add(ruleViolation);
    }

    private void processViolations() {
        ++this.fileCount;
        Collections.sort(this.violations, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((IRuleViolation)o1).getBeginLine() - ((IRuleViolation)o2).getBeginLine();
            }
        });
        Iterator it = this.violations.iterator();
        while (it.hasNext()) {
            IRuleViolation ruleViolation = (IRuleViolation)it.next();
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.text(ruleViolation.getDescription());
            this.sink.tableCell_();
            this.sink.tableCell();
            int beginLine = ruleViolation.getBeginLine();
            this.outputLineLink(beginLine);
            int endLine = ruleViolation.getEndLine();
            if (endLine != beginLine) {
                this.sink.text(" - ");
                this.outputLineLink(endLine);
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.violations.clear();
    }

    private void outputLineLink(int line) {
        String xrefLocation = this.fileInfo.getXrefLocation();
        if (xrefLocation != null) {
            this.sink.link(xrefLocation + "/" + this.currentFilename.replaceAll("\\.java$", ".html") + "#" + line);
        }
        this.sink.text(String.valueOf(line));
        if (xrefLocation != null) {
            this.sink.link_();
        }
    }

    public void metricAdded(Metric metric) {
    }

    public void beginDocument() {
        this.sink.head();
        this.sink.title();
        this.sink.text(this.getTitle());
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getTitle());
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.bundle.getString("report.pmd.pmdlink") + " ");
        this.sink.link("http://pmd.sourceforge.net/");
        this.sink.text("PMD");
        this.sink.link_();
        this.sink.text(" 4.2.2.");
        this.sink.paragraph_();
        this.sink.section1_();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.pmd.files"));
        this.sink.sectionTitle1_();
    }

    public void beginFile(File file, PmdFileInfo finfo) {
        this.fileInfo = finfo;
        this.currentFilename = StringUtils.substring((String)file.getAbsolutePath(), (int)(finfo.getSourceDirectory().getAbsolutePath().length() + 1));
        this.currentFilename = StringUtils.replace((String)this.currentFilename, (String)"\\", (String)"/");
        this.fileInitialized = false;
    }

    public void endFile(File file) {
        if (this.fileInitialized) {
            this.processViolations();
            this.sink.table_();
            this.sink.section2_();
        }
    }

    public void endDocument() {
        if (this.fileCount == 0) {
            this.sink.text(this.bundle.getString("report.pmd.noProblems"));
        }
        this.sink.section1_();
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }
}

