/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.codehaus.plexus.util.ReaderFactory;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    protected MavenProject project;
    protected MojoScanner mojoScanner;
    protected String encoding;
    protected String goalPrefix;
    protected boolean skipErrorNoDescriptorsFound;
    protected Set<String> extractors;
    protected boolean skip;
    protected Set<Artifact> dependencies;
    protected List<ArtifactRepository> remoteRepos;
    protected ArtifactRepository local;

    protected abstract File getOutputDirectory();

    protected abstract Generator createGenerator();

    public void execute() throws MojoExecutionException {
        if (!"maven-plugin".equals(this.project.getPackaging())) {
            return;
        }
        if (this.skip) {
            this.getLog().warn((CharSequence)"Execution skipped");
            return;
        }
        if (this.project.getArtifactId().toLowerCase().startsWith("maven-") && this.project.getArtifactId().toLowerCase().endsWith("-plugin") && !"org.apache.maven.plugins".equals(this.project.getGroupId())) {
            this.getLog().error((CharSequence)"\n\nArtifact Ids of the format maven-___-plugin are reserved for \nplugins in the Group Id org.apache.maven.plugins\nPlease change your artifactId to the format ___-maven-plugin\nIn the future this error will break the build.\n\n");
        }
        String defaultGoalPrefix = PluginDescriptor.getGoalPrefixFromArtifactId((String)this.project.getArtifactId());
        if (this.goalPrefix == null) {
            this.goalPrefix = defaultGoalPrefix;
        } else if (!this.goalPrefix.equals(defaultGoalPrefix)) {
            this.getLog().warn((CharSequence)("\n\nGoal prefix is specified as: '" + this.goalPrefix + "'. " + "Maven currently expects it to be '" + defaultGoalPrefix + "'.\n"));
        }
        this.mojoScanner.setActiveExtractors(this.extractors);
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setGroupId(this.project.getGroupId());
        pluginDescriptor.setArtifactId(this.project.getArtifactId());
        pluginDescriptor.setVersion(this.project.getVersion());
        pluginDescriptor.setGoalPrefix(this.goalPrefix);
        pluginDescriptor.setName(this.project.getName());
        pluginDescriptor.setDescription(this.project.getDescription());
        if (this.encoding == null || this.encoding.length() < 1) {
            this.getLog().warn((CharSequence)("Using platform encoding (" + ReaderFactory.FILE_ENCODING + " actually) to read mojo metadata, i.e. build is platform dependent!"));
        } else {
            this.getLog().info((CharSequence)("Using '" + this.encoding + "' encoding to read mojo metadata."));
        }
        try {
            pluginDescriptor.setDependencies(GeneratorUtils.toComponentDependencies((List)this.project.getRuntimeDependencies()));
            DefaultPluginToolsRequest request = new DefaultPluginToolsRequest(this.project, pluginDescriptor);
            request.setEncoding(this.encoding);
            request.setSkipErrorNoDescriptorsFound(this.skipErrorNoDescriptorsFound);
            request.setDependencies(this.dependencies);
            request.setLocal(this.local);
            request.setRemoteRepos(this.remoteRepos);
            this.mojoScanner.populatePluginDescriptor((PluginToolsRequest)request);
            this.getOutputDirectory().mkdirs();
            this.createGenerator().execute(this.getOutputDirectory(), (PluginToolsRequest)request);
        }
        catch (GeneratorException e) {
            throw new MojoExecutionException("Error writing plugin descriptor", (Exception)((Object)e));
        }
        catch (InvalidPluginDescriptorException e) {
            throw new MojoExecutionException("Error extracting plugin descriptor: '" + e.getLocalizedMessage() + "'", (Exception)((Object)e));
        }
        catch (ExtractionException e) {
            throw new MojoExecutionException("Error extracting plugin descriptor: '" + e.getLocalizedMessage() + "'", (Exception)((Object)e));
        }
        catch (LinkageError e) {
            throw new MojoExecutionException("The API of the mojo scanner is not compatible with this plugin version. Please check the plugin dependencies configured in the POM and ensure the versions match.", (Throwable)e);
        }
    }
}

