/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pdf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-pdf-plugin:1.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven PDF Plugin", 0);
        this.append(sb, "Generates a PDF document from the project site.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "pdf:help", 0);
            this.append(sb, "Display help information on maven-pdf-plugin.\nCall\n\u00a0\u00a0mvn\u00a0pdf:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "pdf".equals(this.goal)) {
            this.append(sb, "pdf:pdf", 0);
            this.append(sb, "Generates a PDF document for a project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "aggregate (Default: true)", 2);
                this.append(sb, "If true, aggregate all source documents in one pdf, otherwise generate one pdf for each source document.", 3);
                this.append(sb, "", 0);
                this.append(sb, "docDescriptor (Default: src/site/pdf.xml)", 2);
                this.append(sb, "File that contains the DocumentModel of the PDF to generate.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedSiteDirectory (Default: ${project.build.directory}/generated-site)", 2);
                this.append(sb, "Directory containing generated sources for apt, fml and xdoc docs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateTOC (Default: start)", 2);
                this.append(sb, "Generate a TOC (Table Of Content) for all items defined in the <toc/> element from the document descriptor.\nPossible values are: 'none', 'start' and 'end'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "implementation (Default: fo)", 2);
                this.append(sb, "Identifies the framework to use for pdf generation: either 'fo' (default) or 'itext'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeReports (Default: true)", 2);
                this.append(sb, "If true, generate all Maven reports defined in ${project.reporting} and append them as a new entry in the TOC (Table Of Contents). Note: Including the report generation could fail the PDF generation or increase the build time.", 3);
                this.append(sb, "", 0);
                this.append(sb, "locales", 2);
                this.append(sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/pdf)", 2);
                this.append(sb, "Output directory where PDF files should be created.", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteRepositories", 2);
                this.append(sb, "The remote repositories where artifacts are located.", 3);
                this.append(sb, "", 0);
                this.append(sb, "siteDirectory (Default: ${basedir}/src/site)", 2);
                this.append(sb, "Directory containing source for apt, fml and xdoc docs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory (Default: ${project.build.directory}/pdf)", 2);
                this.append(sb, "Working directory for working files like temp files/resources.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

