/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycleExecutor;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.help.AbstractHelpMojo;
import org.apache.maven.plugins.help.HelpMojo;
import org.apache.maven.plugins.help.HelpUtil;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="describe", requiresProject=false, aggregator=true)
public class DescribeMojo
extends AbstractHelpMojo {
    private static final int INDENT_SIZE = 2;
    private static final String UNKNOWN = "Unknown";
    private static final String NOT_DEFINED = "Not defined";
    private static final String NO_REASON = "No reason given";
    private static final Pattern EXPRESSION = Pattern.compile("^\\$\\{([^}]+)\\}$");
    @Component
    private ArtifactFactory artifactFactory;
    @Component(role=PluginManager.class)
    private PluginManager pluginManager;
    @Component(role=MavenProjectBuilder.class)
    private MavenProjectBuilder projectBuilder;
    @Component
    private MavenProject project;
    @Component
    private MavenSession session;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @org.apache.maven.plugins.annotations.Parameter(property="plugin", alias="prefix")
    private String plugin;
    @org.apache.maven.plugins.annotations.Parameter(property="groupId")
    private String groupId;
    @org.apache.maven.plugins.annotations.Parameter(property="artifactId")
    private String artifactId;
    @org.apache.maven.plugins.annotations.Parameter(property="version")
    private String version;
    @org.apache.maven.plugins.annotations.Parameter(property="goal", alias="mojo")
    private String goal;
    @org.apache.maven.plugins.annotations.Parameter(property="detail", defaultValue="false", alias="full")
    private boolean detail;
    @org.apache.maven.plugins.annotations.Parameter(property="medium", defaultValue="true")
    private boolean medium;
    @org.apache.maven.plugins.annotations.Parameter(property="minimal", defaultValue="false")
    private boolean minimal;
    @org.apache.maven.plugins.annotations.Parameter(property="cmd")
    private String cmd;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateParameters();
        if (this.project == null) {
            try {
                this.project = this.projectBuilder.buildStandaloneSuperProject(this.session.getProjectBuilderConfiguration());
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException("Error while retrieving the super-project.", (Exception)((Object)e));
            }
        }
        StringBuilder descriptionBuffer = new StringBuilder();
        boolean describePlugin = true;
        if (StringUtils.isNotEmpty((String)this.cmd)) {
            describePlugin = this.describeCommand(descriptionBuffer);
        }
        if (describePlugin) {
            PluginInfo pi = new PluginInfo();
            this.parsePluginLookupInfo(pi);
            PluginDescriptor descriptor = this.lookupPluginDescriptor(pi);
            if (StringUtils.isNotEmpty((String)this.goal)) {
                MojoDescriptor mojo = descriptor.getMojo(this.goal);
                if (mojo == null) {
                    throw new MojoFailureException("The mojo '" + this.goal + "' does not exist in the plugin '" + pi.getPrefix() + "'");
                }
                this.describeMojo(mojo, descriptionBuffer);
            } else {
                this.describePlugin(descriptor, descriptionBuffer);
            }
        }
        this.writeDescription(descriptionBuffer);
    }

    private void validateParameters() {
        if (this.goal == null && this.session.getExecutionProperties().get("mojo") != null) {
            this.goal = this.session.getExecutionProperties().getProperty("mojo");
        }
        if (!this.detail && this.session.getExecutionProperties().get("full") != null) {
            String full = this.session.getExecutionProperties().getProperty("full");
            this.detail = Boolean.valueOf(full);
        }
        if (this.detail || this.minimal) {
            this.medium = false;
        }
    }

    private void writeDescription(StringBuilder descriptionBuffer) throws MojoExecutionException {
        if (this.output != null) {
            try {
                DescribeMojo.writeFile(this.output, descriptionBuffer);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write plugin/mojo description to output: " + this.output, (Exception)e);
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Wrote descriptions to: " + this.output));
            }
        } else if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)descriptionBuffer.toString());
        }
    }

    private PluginDescriptor lookupPluginDescriptor(PluginInfo pi) throws MojoExecutionException, MojoFailureException {
        PluginDescriptor descriptor = null;
        Plugin forLookup = null;
        if (StringUtils.isNotEmpty((String)pi.getPrefix())) {
            descriptor = this.pluginManager.getPluginDescriptorForPrefix(pi.getPrefix());
            if (descriptor == null) {
                forLookup = this.pluginManager.getPluginDefinitionForPrefix(pi.getPrefix(), this.session, this.project);
            }
        } else if (StringUtils.isNotEmpty((String)pi.getGroupId()) && StringUtils.isNotEmpty((String)pi.getArtifactId())) {
            forLookup = new Plugin();
            forLookup.setGroupId(pi.getGroupId());
            forLookup.setArtifactId(pi.getArtifactId());
            if (StringUtils.isNotEmpty((String)pi.getVersion())) {
                forLookup.setVersion(pi.getVersion());
            }
        } else {
            StringBuilder msg = new StringBuilder();
            msg.append("You must specify either: both 'groupId' and 'artifactId' parameters OR a 'plugin' parameter OR a 'cmd' parameter. For instance:\n");
            msg.append("  # mvn help:describe -Dcmd=install\n");
            msg.append("or\n");
            msg.append("  # mvn help:describe -Dcmd=help:describe\n");
            msg.append("or\n");
            msg.append("  # mvn help:describe -Dplugin=org.apache.maven.plugins:maven-help-plugin\n");
            msg.append("or\n");
            msg.append("  # mvn help:describe -DgroupId=org.apache.maven.plugins -DartifactId=maven-help-plugin\n\n");
            msg.append("Try 'mvn help:help -Ddetail=true' for more information.");
            throw new MojoFailureException(msg.toString());
        }
        if (descriptor == null && forLookup != null) {
            try {
                descriptor = this.pluginManager.loadPluginDescriptor(forLookup, this.project, this.session);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Error retrieving plugin descriptor for:\n\ngroupId: '" + this.groupId + "'\nartifactId: '" + this.artifactId + "'\nversion: '" + this.version + "'\n\n", (Exception)((Object)e));
            }
            catch (PluginManagerException e) {
                throw new MojoExecutionException("Error retrieving plugin descriptor for:\n\ngroupId: '" + this.groupId + "'\nartifactId: '" + this.artifactId + "'\nversion: '" + this.version + "'\n\n", (Exception)((Object)e));
            }
            catch (PluginVersionResolutionException e) {
                throw new MojoExecutionException("Error retrieving plugin descriptor for:\n\ngroupId: '" + this.groupId + "'\nartifactId: '" + this.artifactId + "'\nversion: '" + this.version + "'\n\n", (Exception)((Object)e));
            }
            catch (ArtifactNotFoundException e) {
                throw new MojoExecutionException("Plugin dependency does not exist: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("Error retrieving plugin descriptor for:\n\ngroupId: '" + this.groupId + "'\nartifactId: '" + this.artifactId + "'\nversion: '" + this.version + "'\n\n", (Exception)((Object)e));
            }
            catch (InvalidPluginException e) {
                throw new MojoExecutionException("Error retrieving plugin descriptor for:\n\ngroupId: '" + this.groupId + "'\nartifactId: '" + this.artifactId + "'\nversion: '" + this.version + "'\n\n", (Exception)((Object)e));
            }
            catch (PluginNotFoundException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"Unable to find plugin", (Throwable)e);
                }
                throw new MojoFailureException("Plugin does not exist: " + e.getMessage());
            }
            catch (PluginVersionNotFoundException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"Unable to find plugin version", (Throwable)e);
                }
                throw new MojoFailureException(e.getMessage());
            }
        }
        if (descriptor == null) {
            throw new MojoFailureException("Plugin could not be found. If you believe it is correct, check your pluginGroups setting, and run with -U to update the remote configuration");
        }
        return descriptor;
    }

    private void parsePluginLookupInfo(PluginInfo pi) throws MojoFailureException {
        if (StringUtils.isNotEmpty((String)this.plugin)) {
            if (this.plugin.indexOf(58) > -1) {
                String[] pluginParts = this.plugin.split(":");
                switch (pluginParts.length) {
                    case 1: {
                        pi.setPrefix(pluginParts[0]);
                        break;
                    }
                    case 2: {
                        pi.setGroupId(pluginParts[0]);
                        pi.setArtifactId(pluginParts[1]);
                        break;
                    }
                    case 3: {
                        pi.setGroupId(pluginParts[0]);
                        pi.setArtifactId(pluginParts[1]);
                        pi.setVersion(pluginParts[2]);
                        break;
                    }
                    default: {
                        throw new MojoFailureException("plugin parameter must be a plugin prefix, or conform to: 'groupId:artifactId[:version]'.");
                    }
                }
            } else {
                pi.setPrefix(this.plugin);
            }
        } else {
            pi.setGroupId(this.groupId);
            pi.setArtifactId(this.artifactId);
            pi.setVersion(this.version);
        }
    }

    private void describePlugin(PluginDescriptor pd, StringBuilder buffer) throws MojoFailureException, MojoExecutionException {
        DescribeMojo.append(buffer, pd.getId(), 0);
        buffer.append("\n");
        String name = pd.getName();
        if (name == null) {
            try {
                Artifact artifact = this.artifactFactory.createPluginArtifact(pd.getGroupId(), pd.getArtifactId(), VersionRange.createFromVersion((String)pd.getVersion()));
                MavenProject pluginProject = this.projectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository);
                name = pluginProject.getName();
            }
            catch (ProjectBuildingException e) {
                name = pd.getId();
            }
        }
        DescribeMojo.append(buffer, "Name", name, 0);
        DescribeMojo.appendAsParagraph(buffer, "Description", DescribeMojo.toDescription(pd.getDescription()), 0);
        DescribeMojo.append(buffer, "Group Id", pd.getGroupId(), 0);
        DescribeMojo.append(buffer, "Artifact Id", pd.getArtifactId(), 0);
        DescribeMojo.append(buffer, "Version", pd.getVersion(), 0);
        DescribeMojo.append(buffer, "Goal Prefix", pd.getGoalPrefix(), 0);
        buffer.append("\n");
        ArrayList mojos = pd.getMojos();
        if (mojos == null) {
            DescribeMojo.append(buffer, "This plugin has no goals.", 0);
            return;
        }
        if ((this.detail || this.medium) && !this.minimal) {
            DescribeMojo.append(buffer, "This plugin has " + mojos.size() + " goal" + (mojos.size() > 1 ? "s" : "") + ":", 0);
            buffer.append("\n");
            mojos = new ArrayList(mojos);
            PluginUtils.sortMojos(mojos);
            for (MojoDescriptor md : mojos) {
                if (this.detail) {
                    this.describeMojoGuts(md, buffer, true);
                } else {
                    this.describeMojoGuts(md, buffer, false);
                }
                buffer.append("\n");
            }
        }
        if (!this.detail) {
            buffer.append("For more information, run 'mvn help:describe [...] -Ddetail'");
            buffer.append("\n");
        }
    }

    private void describeMojo(MojoDescriptor md, StringBuilder buffer) throws MojoFailureException, MojoExecutionException {
        buffer.append("Mojo: '").append(md.getFullGoalName()).append("'");
        buffer.append('\n');
        this.describeMojoGuts(md, buffer, this.detail);
        buffer.append("\n");
        if (!this.detail) {
            buffer.append("For more information, run 'mvn help:describe [...] -Ddetail'");
            buffer.append("\n");
        }
    }

    private void describeMojoGuts(MojoDescriptor md, StringBuilder buffer, boolean fullDescription) throws MojoFailureException, MojoExecutionException {
        DescribeMojo.append(buffer, md.getFullGoalName(), 0);
        DescribeMojo.appendAsParagraph(buffer, "Description", DescribeMojo.toDescription(md.getDescription()), 1);
        String deprecation = md.getDeprecated();
        if (deprecation != null && deprecation.length() <= 0) {
            deprecation = NO_REASON;
        }
        if (StringUtils.isNotEmpty((String)deprecation)) {
            DescribeMojo.append(buffer, "Deprecated. " + deprecation, 1);
        }
        if (!fullDescription) {
            return;
        }
        DescribeMojo.append(buffer, "Implementation", md.getImplementation(), 1);
        DescribeMojo.append(buffer, "Language", md.getLanguage(), 1);
        String phase = md.getPhase();
        if (StringUtils.isNotEmpty((String)phase)) {
            DescribeMojo.append(buffer, "Bound to phase", phase, 1);
        }
        String eGoal = md.getExecuteGoal();
        String eLife = md.getExecuteLifecycle();
        String ePhase = md.getExecutePhase();
        if (StringUtils.isNotEmpty((String)eGoal) || StringUtils.isNotEmpty((String)ePhase)) {
            DescribeMojo.append(buffer, "Before this mojo executes, it will call:", 1);
            if (StringUtils.isNotEmpty((String)eGoal)) {
                DescribeMojo.append(buffer, "Single mojo", "'" + eGoal + "'", 2);
            }
            if (StringUtils.isNotEmpty((String)ePhase)) {
                String s = "Phase: '" + ePhase + "'";
                if (StringUtils.isNotEmpty((String)eLife)) {
                    s = s + " in Lifecycle Overlay: '" + eLife + "'";
                }
                DescribeMojo.append(buffer, s, 2);
            }
        }
        buffer.append("\n");
        this.describeMojoParameters(md, buffer);
    }

    private void describeMojoParameters(MojoDescriptor md, StringBuilder buffer) throws MojoFailureException, MojoExecutionException {
        ArrayList params = md.getParameters();
        if (params == null || params.isEmpty()) {
            DescribeMojo.append(buffer, "This mojo doesn't use any parameters.", 1);
            return;
        }
        params = new ArrayList(params);
        Collections.sort(params, new Comparator<Parameter>(){

            @Override
            public int compare(Parameter parameter1, Parameter parameter2) {
                return parameter1.getName().compareToIgnoreCase(parameter2.getName());
            }
        });
        DescribeMojo.append(buffer, "Available parameters:", 1);
        for (Parameter parameter : params) {
            String expression;
            if (!parameter.isEditable()) continue;
            buffer.append("\n");
            String defaultVal = parameter.getDefaultValue();
            if (defaultVal == null) {
                defaultVal = md.getMojoConfiguration().getChild(parameter.getName()).getAttribute("default-value", null);
            }
            defaultVal = StringUtils.isNotEmpty((String)defaultVal) ? " (Default: " + defaultVal + ")" : "";
            DescribeMojo.append(buffer, parameter.getName() + defaultVal, 2);
            if (parameter.isRequired()) {
                DescribeMojo.append(buffer, "Required", "true", 3);
            }
            if (StringUtils.isEmpty((String)(expression = parameter.getExpression()))) {
                expression = md.getMojoConfiguration().getChild(parameter.getName()).getValue(null);
            }
            if (StringUtils.isNotEmpty((String)expression)) {
                Matcher matcher = EXPRESSION.matcher(expression);
                if (matcher.matches()) {
                    DescribeMojo.append(buffer, "User property", matcher.group(1), 3);
                } else {
                    DescribeMojo.append(buffer, "Expression", expression, 3);
                }
            }
            DescribeMojo.append(buffer, DescribeMojo.toDescription(parameter.getDescription()), 3);
            String deprecation = parameter.getDeprecated();
            if (deprecation != null && deprecation.length() <= 0) {
                deprecation = NO_REASON;
            }
            if (!StringUtils.isNotEmpty((String)deprecation)) continue;
            DescribeMojo.append(buffer, "Deprecated. " + deprecation, 3);
        }
    }

    private boolean describeCommand(StringBuilder descriptionBuffer) throws MojoFailureException, MojoExecutionException {
        if (this.cmd.indexOf(58) == -1) {
            block13: {
                try {
                    DefaultLifecycleExecutor lifecycleExecutor = (DefaultLifecycleExecutor)this.session.lookup(LifecycleExecutor.ROLE);
                    Lifecycle lifecycle = (Lifecycle)lifecycleExecutor.getPhaseToLifecycleMap().get(this.cmd);
                    if (lifecycle == null) {
                        throw new MojoExecutionException("The given phase '" + this.cmd + "' is an unknown phase.");
                    }
                    LifecycleMapping lifecycleMapping = (LifecycleMapping)this.session.lookup(LifecycleMapping.ROLE, this.project.getPackaging());
                    List phases = lifecycle.getPhases();
                    if (lifecycle.getDefaultPhases() == null) {
                        descriptionBuffer.append("'" + this.cmd + "' is a phase corresponding to this plugin:\n");
                        for (String key : phases) {
                            if (!key.equals(this.cmd) || lifecycleMapping.getPhases("default").get(key) == null) continue;
                            descriptionBuffer.append(lifecycleMapping.getPhases("default").get(key));
                            descriptionBuffer.append("\n");
                        }
                        descriptionBuffer.append("\n");
                        descriptionBuffer.append("It is a part of the lifecycle for the POM packaging '" + this.project.getPackaging() + "'. This lifecycle includes the following phases:");
                        descriptionBuffer.append("\n");
                        for (String key : phases) {
                            descriptionBuffer.append("* " + key + ": ");
                            String value = (String)lifecycleMapping.getPhases("default").get(key);
                            if (StringUtils.isNotEmpty((String)value)) {
                                StringTokenizer tok = new StringTokenizer(value, ",");
                                while (tok.hasMoreTokens()) {
                                    descriptionBuffer.append(tok.nextToken().trim());
                                    if (!tok.hasMoreTokens()) {
                                        descriptionBuffer.append("\n");
                                        continue;
                                    }
                                    descriptionBuffer.append(", ");
                                }
                                continue;
                            }
                            descriptionBuffer.append(NOT_DEFINED).append("\n");
                        }
                        break block13;
                    }
                    descriptionBuffer.append("'" + this.cmd + "' is a lifecycle with the following phases: ");
                    descriptionBuffer.append("\n");
                    for (String key : phases) {
                        descriptionBuffer.append("* " + key + ": ");
                        if (lifecycle.getDefaultPhases().get(key) != null) {
                            descriptionBuffer.append(lifecycle.getDefaultPhases().get(key)).append("\n");
                            continue;
                        }
                        descriptionBuffer.append(NOT_DEFINED).append("\n");
                    }
                }
                catch (ComponentLookupException e) {
                    throw new MojoFailureException("ComponentLookupException: " + e.getMessage());
                }
                catch (LifecycleExecutionException e) {
                    throw new MojoFailureException("LifecycleExecutionException: " + e.getMessage());
                }
            }
            return false;
        }
        MojoDescriptor mojoDescriptor = HelpUtil.getMojoDescriptor(this.cmd, this.session, this.project, this.cmd, true, false);
        descriptionBuffer.append("'" + this.cmd + "' is a plugin goal (aka mojo)").append(".\n");
        this.plugin = mojoDescriptor.getPluginDescriptor().getId();
        this.goal = mojoDescriptor.getGoal();
        return true;
    }

    private static List<String> toLines(String text, int indent, int indentSize, int lineLength) throws MojoFailureException, MojoExecutionException {
        try {
            Method m = HelpMojo.class.getDeclaredMethod("toLines", String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            m.setAccessible(true);
            List output = (List)m.invoke(HelpMojo.class, text, indent, indentSize, lineLength);
            if (output == null) {
                throw new MojoExecutionException("No output was specified.");
            }
            return output;
        }
        catch (SecurityException e) {
            throw new MojoFailureException("SecurityException: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("IllegalArgumentException: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new MojoFailureException("NoSuchMethodException: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new MojoFailureException("IllegalAccessException: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NegativeArraySizeException) {
                throw new MojoFailureException("NegativeArraySizeException: " + cause.getMessage());
            }
            throw new MojoFailureException("InvocationTargetException: " + e.getMessage());
        }
    }

    private static void append(StringBuilder sb, String description, int indent) throws MojoFailureException, MojoExecutionException {
        if (StringUtils.isEmpty((String)description)) {
            sb.append(UNKNOWN).append('\n');
            return;
        }
        for (String line : DescribeMojo.toLines(description, indent, 2, 79)) {
            sb.append(line).append('\n');
        }
    }

    private static void append(StringBuilder sb, String key, String value, int indent) throws MojoFailureException, MojoExecutionException {
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException("Key is required!");
        }
        if (StringUtils.isEmpty((String)value)) {
            value = UNKNOWN;
        }
        String description = key + ": " + value;
        for (String line : DescribeMojo.toLines(description, indent, 2, 79)) {
            sb.append(line).append('\n');
        }
    }

    private static void appendAsParagraph(StringBuilder sb, String key, String value, int indent) throws MojoFailureException, MojoExecutionException {
        if (StringUtils.isEmpty((String)value)) {
            value = UNKNOWN;
        }
        String description = key == null ? value : key + ": " + value;
        List<String> l1 = DescribeMojo.toLines(description, indent, 2, 77);
        List<String> l2 = DescribeMojo.toLines(description, indent + 1, 2, 79);
        l2.set(0, l1.get(0));
        for (String line : l2) {
            sb.append(line).append('\n');
        }
    }

    private static String toDescription(String description) {
        if (StringUtils.isNotEmpty((String)description)) {
            return PluginUtils.toText((String)description);
        }
        return "(no description available)";
    }

    static class PluginInfo {
        private String prefix;
        private String groupId;
        private String artifactId;
        private String version;
        private String mojo;
        private Plugin plugin;
        private PluginDescriptor pluginDescriptor;

        PluginInfo() {
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getMojo() {
            return this.mojo;
        }

        public void setMojo(String mojo) {
            this.mojo = mojo;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public void setPlugin(Plugin plugin) {
            this.plugin = plugin;
        }

        public PluginDescriptor getPluginDescriptor() {
            return this.pluginDescriptor;
        }

        public void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
            this.pluginDescriptor = pluginDescriptor;
        }
    }
}

