/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.ear;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.ear.EarExecutionContext;
import org.apache.maven.plugins.ear.EarModule;
import org.apache.maven.plugins.ear.EarModuleFactory;
import org.apache.maven.plugins.ear.EarPluginException;
import org.apache.maven.plugins.ear.JbossConfiguration;
import org.apache.maven.plugins.ear.util.ArtifactTypeMappingService;
import org.apache.maven.plugins.ear.util.JavaEEVersion;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;

public abstract class AbstractEarMojo
extends AbstractMojo {
    public static final String APPLICATION_XML_URI = "META-INF/application.xml";
    public static final String META_INF = "META-INF";
    public static final String UTF_8 = "UTF-8";
    @Parameter(defaultValue="7")
    protected String version;
    @Parameter(defaultValue="UTF-8")
    protected String encoding;
    @Parameter(defaultValue="${project.build.directory}")
    protected String generatedDescriptorLocation;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter
    private EarModule[] modules;
    @Parameter
    protected PlexusConfiguration artifactTypeMappings;
    @Parameter
    protected String defaultLibBundleDir;
    @Parameter(defaultValue="false")
    private Boolean includeLibInApplicationXml = Boolean.FALSE;
    @Parameter
    private String fileNameMapping;
    @Parameter(defaultValue="@{groupId}@-@{artifactId}@-@{version}@@{dashClassifier?}@.@{extension}@", required=true)
    private String outputFileNameMapping;
    @Parameter
    private Boolean useBaseVersion;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}", required=true)
    private File workDirectory;
    @Parameter
    private PlexusConfiguration jboss;
    @Parameter
    private String mainArtifactId = "none";
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File tempFolder;
    private List<EarModule> earModules;
    private List<EarModule> allEarModules;
    private List<EarModule> providedEarModules;
    private JbossConfiguration jbossConfiguration;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactTypeMappingService typeMappingService;
        if (this.fileNameMapping != null) {
            this.getLog().error((CharSequence)"fileNameMapping has been removed with version 3.0.0. You are still using it.");
            this.getLog().error((CharSequence)"Use outputFileNameMapping instead.");
            throw new MojoExecutionException("fileNameMapping has been removed with version 3.0.0 but you are still using it.");
        }
        JavaEEVersion javaEEVersion = JavaEEVersion.getJavaEEVersion(this.version);
        this.getLog().debug((CharSequence)"Resolving artifact type mappings ...");
        try {
            typeMappingService = new ArtifactTypeMappingService();
            typeMappingService.configure(this.artifactTypeMappings);
        }
        catch (EarPluginException e) {
            throw new MojoExecutionException("Failed to initialize artifact type mappings", (Exception)e);
        }
        catch (PlexusConfigurationException e) {
            throw new MojoExecutionException("Invalid artifact type mappings configuration", (Exception)((Object)e));
        }
        this.getLog().debug((CharSequence)"Initializing JBoss configuration if necessary ...");
        try {
            this.initializeJbossConfiguration();
        }
        catch (EarPluginException e) {
            throw new MojoExecutionException("Failed to initialize JBoss configuration", (Exception)e);
        }
        this.getLog().debug((CharSequence)"Initializing ear execution context");
        EarExecutionContext earExecutionContext = new EarExecutionContext(this.project, this.mainArtifactId, this.defaultLibBundleDir, this.jbossConfiguration, this.outputFileNameMapping, typeMappingService);
        if (this.useBaseVersion != null) {
            this.getLog().warn((CharSequence)"Using useBaseVersion not yet fixed.");
        }
        this.getLog().debug((CharSequence)"Resolving ear modules ...");
        ArrayList<EarModule> allModules = new ArrayList<EarModule>();
        try {
            if (this.modules != null && this.modules.length > 0) {
                EarModule[] earModuleArray = this.modules;
                int n = earModuleArray.length;
                for (int i = 0; i < n; ++i) {
                    Object module1;
                    Object module = module1 = earModuleArray[i];
                    this.getLog().debug((CharSequence)("Resolving ear module[" + module + "]"));
                    module.setEarExecutionContext(earExecutionContext);
                    module.resolveArtifact(this.project.getArtifacts());
                    allModules.add((EarModule)module);
                }
            }
            Set artifacts = this.project.getArtifacts();
            for (Artifact artifact : artifacts) {
                if ("pom".equals(artifact.getType())) continue;
                ScopeArtifactFilter filter = new ScopeArtifactFilter("compile+runtime");
                if (AbstractEarMojo.isArtifactRegistered(artifact, allModules) || artifact.isOptional() || !filter.include(artifact)) continue;
                EarModule module = EarModuleFactory.newEarModule(artifact, javaEEVersion, this.defaultLibBundleDir, this.includeLibInApplicationXml, typeMappingService);
                module.setEarExecutionContext(earExecutionContext);
                allModules.add(module);
            }
        }
        catch (EarPluginException e) {
            throw new MojoExecutionException("Failed to initialize ear modules", (Exception)e);
        }
        ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
        this.allEarModules = new ArrayList<EarModule>();
        this.providedEarModules = new ArrayList<EarModule>();
        this.earModules = new ArrayList<EarModule>();
        for (EarModule earModule : allModules) {
            if (earModule.isExcluded()) {
                this.getLog().debug((CharSequence)("Skipping ear module[" + earModule + "]"));
                continue;
            }
            this.allEarModules.add(earModule);
            if (filter.include(earModule.getArtifact())) {
                this.earModules.add(earModule);
                continue;
            }
            this.providedEarModules.add(earModule);
        }
    }

    protected List<EarModule> getModules() {
        if (this.earModules == null) {
            throw new IllegalStateException("Ear modules have not been initialized");
        }
        return this.earModules;
    }

    protected List<EarModule> getAllEarModules() {
        if (this.allEarModules == null) {
            throw new IllegalStateException("EAR modules have not been initialized");
        }
        return this.allEarModules;
    }

    protected List<EarModule> getProvidedEarModules() {
        if (this.providedEarModules == null) {
            throw new IllegalStateException("Jar modules have not been initialized");
        }
        return this.providedEarModules;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected File getWorkDirectory() {
        return this.workDirectory;
    }

    protected JbossConfiguration getJbossConfiguration() {
        return this.jbossConfiguration;
    }

    public File getTempFolder() {
        return this.tempFolder;
    }

    public String getOutputFileNameMapping() {
        return this.outputFileNameMapping;
    }

    private static boolean isArtifactRegistered(Artifact a, List<EarModule> currentList) {
        for (EarModule em : currentList) {
            if (!em.getArtifact().equals(a)) continue;
            return true;
        }
        return false;
    }

    private void initializeJbossConfiguration() throws EarPluginException {
        if (this.jboss == null) {
            this.jbossConfiguration = null;
        } else {
            String childVersion = this.jboss.getChild("version").getValue();
            if (childVersion == null) {
                this.getLog().info((CharSequence)"JBoss version not set, using JBoss 4 by default");
                childVersion = "4";
            }
            String securityDomain = this.jboss.getChild("security-domain").getValue();
            String unauthenticatedPrincipal = this.jboss.getChild("unauthenticated-principal").getValue();
            PlexusConfiguration loaderRepositoryEl = this.jboss.getChild("loader-repository");
            String loaderRepository = loaderRepositoryEl.getValue();
            String loaderRepositoryClass = loaderRepositoryEl.getAttribute("loaderRepositoryClass");
            PlexusConfiguration loaderRepositoryConfigEl = this.jboss.getChild("loader-repository-config");
            String loaderRepositoryConfig = loaderRepositoryConfigEl.getValue();
            String configParserClass = loaderRepositoryConfigEl.getAttribute("configParserClass");
            String jmxName = this.jboss.getChild("jmx-name").getValue();
            String moduleOrder = this.jboss.getChild("module-order").getValue();
            ArrayList<String> dataSources = new ArrayList<String>();
            PlexusConfiguration dataSourcesEl = this.jboss.getChild("data-sources");
            if (dataSourcesEl != null) {
                PlexusConfiguration[] dataSourcesConfig;
                for (PlexusConfiguration dataSourceConfig : dataSourcesConfig = dataSourcesEl.getChildren("data-source")) {
                    dataSources.add(dataSourceConfig.getValue());
                }
            }
            String libraryDirectory = this.jboss.getChild("library-directory").getValue();
            this.jbossConfiguration = new JbossConfiguration(childVersion, securityDomain, unauthenticatedPrincipal, jmxName, loaderRepository, moduleOrder, dataSources, libraryDirectory, loaderRepositoryConfig, loaderRepositoryClass, configParserClass);
        }
    }
}

