/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.ear.util.InvalidJavaEEVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEEVersion
implements Comparable<JavaEEVersion> {
    private static final String VERSION_1_3 = "1.3";
    private static final String VERSION_1_4 = "1.4";
    private static final String VERSION_5 = "5";
    private static final String VERSION_6 = "6";
    private static final String VERSION_7 = "7";
    private static final Map<String, JavaEEVersion> versionsMap = new HashMap<String, JavaEEVersion>();
    public static final JavaEEVersion OneDotThree = new JavaEEVersion(0, "1.3");
    public static final JavaEEVersion OneDotFour = new JavaEEVersion(1, "1.4");
    public static final JavaEEVersion Five = new JavaEEVersion(2, "5");
    public static final JavaEEVersion Six = new JavaEEVersion(3, "6");
    public static final JavaEEVersion Seven = new JavaEEVersion(4, "7");
    private final Integer index;
    private final String version;

    private JavaEEVersion(Integer index, String version) {
        this.index = index;
        this.version = version;
        versionsMap.put(version, this);
    }

    public static JavaEEVersion getJavaEEVersion(String version) throws InvalidJavaEEVersion {
        if (!JavaEEVersion.isValid(version)) {
            throw new InvalidJavaEEVersion("Invalid version [" + version + "]", version);
        }
        return versionsMap.get(version);
    }

    public String getVersion() {
        return this.version;
    }

    public boolean ge(JavaEEVersion version) {
        return this.compareTo(version) >= 0;
    }

    public boolean gt(JavaEEVersion version) {
        return this.compareTo(version) > 0;
    }

    public boolean eq(JavaEEVersion version) {
        return this.compareTo(version) == 0;
    }

    public boolean le(JavaEEVersion version) {
        return this.compareTo(version) <= 0;
    }

    public boolean lt(JavaEEVersion version) {
        return this.compareTo(version) < 0;
    }

    private static boolean isValid(String version) {
        if (version == null) {
            throw new IllegalArgumentException("version could not be null.");
        }
        return VERSION_1_3.equals(version) || VERSION_1_4.equals(version) || VERSION_5.equals(version) || VERSION_6.equals(version) || VERSION_7.equals(version);
    }

    @Override
    public int compareTo(JavaEEVersion otherVersion) {
        if (otherVersion == null) {
            throw new IllegalArgumentException("other object to compare to could not be null.");
        }
        return this.index.compareTo(otherVersion.index);
    }
}

