/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.File;
import java.io.Writer;
import java.util.List;
import org.apache.maven.plugin.ear.AbstractXmlWriter;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.plugin.ear.EarPluginException;
import org.apache.maven.plugin.ear.JbossConfiguration;
import org.apache.maven.plugin.ear.JbossEarModule;
import org.codehaus.plexus.util.xml.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JbossAppXmlWriter
extends AbstractXmlWriter {
    public static final String DOCTYPE_3_2 = "jboss-app PUBLIC\n\t\"-//JBoss//DTD J2EE Application 1.3//EN\"\n\t\"http://www.jboss.org/j2ee/dtd/jboss-app_3_2.dtd\"";
    public static final String DOCTYPE_4 = "jboss-app PUBLIC\n\t\"-//JBoss//DTD J2EE Application 1.4//EN\"\n\t\"http://www.jboss.org/j2ee/dtd/jboss-app_4_0.dtd\"";
    public static final String DOCTYPE_4_2 = "jboss-app PUBLIC\n\t\"-//JBoss//DTD J2EE Application 4.2//EN\"\n\t\"http://www.jboss.org/j2ee/dtd/jboss-app_4_2.dtd\"";
    public static final String DOCTYPE_5 = "jboss-app PUBLIC\n\t\"-//JBoss//DTD Java EE Application 5.0//EN\"\n\t\"http://www.jboss.org/j2ee/dtd/jboss-app_5_0.dtd\"";
    private static final String JBOSS_APP_ELEMENT = "jboss-app";

    JbossAppXmlWriter(String encoding) {
        super(encoding);
    }

    public void write(File destinationFile, JbossConfiguration jbossConfiguration, List<EarModule> earModules) throws EarPluginException {
        List<String> dataSources;
        Writer w = this.initializeWriter(destinationFile);
        XMLWriter writer = jbossConfiguration.isJbossThreeDotTwo() ? this.initializeXmlWriter(w, DOCTYPE_3_2) : (jbossConfiguration.isJbossFour() ? this.initializeXmlWriter(w, DOCTYPE_4) : (jbossConfiguration.isJbossFourDotTwo() ? this.initializeXmlWriter(w, DOCTYPE_4_2) : this.initializeXmlWriter(w, DOCTYPE_5)));
        writer.startElement(JBOSS_APP_ELEMENT);
        if (jbossConfiguration.isJbossFourDotTwoOrHigher() && jbossConfiguration.getModuleOrder() != null) {
            writer.startElement("module-order");
            writer.writeText(jbossConfiguration.getModuleOrder());
            writer.endElement();
        }
        if (jbossConfiguration.isJbossFourOrHigher()) {
            if (jbossConfiguration.getSecurityDomain() != null) {
                writer.startElement("security-domain");
                writer.writeText(jbossConfiguration.getSecurityDomain());
                writer.endElement();
            }
            if (jbossConfiguration.getUnauthenticatedPrincipal() != null) {
                writer.startElement("unauthenticated-principal");
                writer.writeText(jbossConfiguration.getUnauthenticatedPrincipal());
                writer.endElement();
            }
        }
        if (jbossConfiguration.getLoaderRepository() != null || jbossConfiguration.getLoaderRepositoryConfig() != null) {
            writer.startElement("loader-repository");
            if (jbossConfiguration.getLoaderRepositoryClass() != null) {
                writer.addAttribute("loaderRepositoryClass", jbossConfiguration.getLoaderRepositoryClass());
            }
            if (jbossConfiguration.getLoaderRepository() != null) {
                writer.writeText(jbossConfiguration.getLoaderRepository());
            }
            if (jbossConfiguration.getLoaderRepositoryConfig() != null) {
                writer.startElement("loader-repository-config");
                if (jbossConfiguration.getConfigParserClass() != null) {
                    writer.addAttribute("configParserClass", jbossConfiguration.getConfigParserClass());
                }
                writer.writeText(jbossConfiguration.getLoaderRepositoryConfig());
                writer.endElement();
            }
            writer.endElement();
        }
        if (jbossConfiguration.getJmxName() != null) {
            writer.startElement("jmx-name");
            writer.writeText(jbossConfiguration.getJmxName());
            writer.endElement();
        }
        if (jbossConfiguration.isJbossFourDotTwoOrHigher() && jbossConfiguration.getLibraryDirectory() != null) {
            writer.startElement("library-directory");
            writer.writeText(jbossConfiguration.getLibraryDirectory());
            writer.endElement();
        }
        if ((dataSources = jbossConfiguration.getDataSources()) != null) {
            for (String dsPath : dataSources) {
                writer.startElement("module");
                writer.startElement("service");
                writer.writeText(dsPath);
                writer.endElement();
                writer.endElement();
            }
        }
        for (EarModule earModule : earModules) {
            if (!JbossEarModule.class.isInstance(earModule)) continue;
            JbossEarModule jbossEarModule = (JbossEarModule)((Object)earModule);
            jbossEarModule.appendJbossModule(writer, jbossConfiguration.getVersion());
        }
        writer.endElement();
        this.close(w);
    }
}

