/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.AbstractEarMojo;
import org.apache.maven.plugin.ear.ApplicationXmlWriter;
import org.apache.maven.plugin.ear.ApplicationXmlWriterContext;
import org.apache.maven.plugin.ear.EarPluginException;
import org.apache.maven.plugin.ear.EjbRef;
import org.apache.maven.plugin.ear.EnvEntry;
import org.apache.maven.plugin.ear.JbossAppXmlWriter;
import org.apache.maven.plugin.ear.SecurityRole;
import org.apache.maven.plugin.ear.util.JavaEEVersion;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="generate-application-xml", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class GenerateApplicationXmlMojo
extends AbstractEarMojo {
    public static final String DEFAULT = "DEFAULT";
    public static final String EMPTY = "EMPTY";
    public static final String NONE = "NONE";
    @Parameter(defaultValue="true")
    private Boolean generateApplicationXml = Boolean.TRUE;
    @Parameter(defaultValue="false")
    private Boolean generateModuleId = Boolean.FALSE;
    @Parameter
    private String applicationName;
    @Parameter(defaultValue="${project.artifactId}")
    private String displayName;
    @Parameter(defaultValue="${project.description}")
    private String description;
    @Parameter(defaultValue="DEFAULT")
    private String libraryDirectoryMode;
    @Parameter
    private Boolean initializeInOrder;
    @Parameter
    private String applicationId;
    @Parameter
    private PlexusConfiguration security;
    @Parameter(alias="env-entries")
    private PlexusConfiguration envEntries;
    @Parameter(alias="ejb-refs")
    private PlexusConfiguration ejbRefs;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (!this.generateApplicationXml.booleanValue()) {
            this.getLog().debug((CharSequence)"Generation of application.xml is disabled");
        } else {
            JavaEEVersion javaEEVersion = JavaEEVersion.getJavaEEVersion(this.version);
            this.getLog().info((CharSequence)"Generating application.xml");
            try {
                this.generateStandardDeploymentDescriptor(javaEEVersion);
            }
            catch (EarPluginException e) {
                throw new MojoExecutionException("Failed to generate application.xml", (Exception)e);
            }
            try {
                FileUtils.copyFileToDirectory((File)new File(this.generatedDescriptorLocation, "application.xml"), (File)new File(this.getWorkDirectory(), "META-INF"));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to copy application.xml to final destination", (Exception)e);
            }
        }
        if (this.getJbossConfiguration() == null) {
            this.getLog().debug((CharSequence)"Generation of jboss-app.xml is disabled");
        } else {
            this.getLog().info((CharSequence)"Generating jboss-app.xml");
            try {
                this.generateJbossDeploymentDescriptor();
            }
            catch (EarPluginException e) {
                throw new MojoExecutionException("Failed to generate jboss-app.xml", (Exception)e);
            }
            try {
                FileUtils.copyFileToDirectory((File)new File(this.generatedDescriptorLocation, "jboss-app.xml"), (File)new File(this.getWorkDirectory(), "META-INF"));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to copy jboss-app.xml to final destination", (Exception)e);
            }
        }
    }

    protected void generateStandardDeploymentDescriptor(JavaEEVersion javaEEVersion) throws EarPluginException {
        File outputDir = new File(this.generatedDescriptorLocation);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        File descriptor = new File(outputDir, "application.xml");
        ApplicationXmlWriter writer = new ApplicationXmlWriter(javaEEVersion, this.encoding, this.generateModuleId);
        ApplicationXmlWriterContext context = new ApplicationXmlWriterContext(descriptor, this.getModules(), this.buildSecurityRoles(), this.buildEnvEntries(), this.buildEjbEntries(), this.displayName, this.description, this.getActualLibraryDirectory(), this.applicationName, this.initializeInOrder).setApplicationId(this.applicationId);
        writer.write(context);
    }

    protected void generateJbossDeploymentDescriptor() throws EarPluginException {
        File outputDir = new File(this.generatedDescriptorLocation);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        File descriptor = new File(outputDir, "jboss-app.xml");
        JbossAppXmlWriter writer = new JbossAppXmlWriter(this.encoding);
        writer.write(descriptor, this.getJbossConfiguration(), this.getModules());
    }

    private List<SecurityRole> buildSecurityRoles() throws EarPluginException {
        ArrayList<SecurityRole> result = new ArrayList<SecurityRole>();
        if (this.security == null) {
            return result;
        }
        try {
            PlexusConfiguration[] securityRoles;
            for (PlexusConfiguration securityRole : securityRoles = this.security.getChildren("security-role")) {
                String id = securityRole.getAttribute("id");
                String childRoleName = securityRole.getChild("role-name").getValue();
                String childRoleNameId = securityRole.getChild("role-name").getAttribute("id");
                String childDescription = securityRole.getChild("description").getValue();
                String childDescriptionId = securityRole.getChild("description").getAttribute("id");
                if (childRoleName == null) {
                    throw new EarPluginException("Invalid security-role configuration, role-name could not be null.");
                }
                result.add(new SecurityRole(childRoleName, childRoleNameId, id, childDescription, childDescriptionId));
            }
            return result;
        }
        catch (PlexusConfigurationException e) {
            throw new EarPluginException("Invalid security-role configuration", e);
        }
    }

    private String interpolate(Interpolator interpolator, String element) throws InterpolationException {
        if (element == null) {
            return element;
        }
        return interpolator.interpolate(element);
    }

    private List<EnvEntry> buildEnvEntries() throws EarPluginException {
        ArrayList<EnvEntry> result = new ArrayList<EnvEntry>();
        if (this.envEntries == null) {
            return result;
        }
        try {
            PlexusConfiguration[] allEnvEntries;
            StringSearchInterpolator ssi = new StringSearchInterpolator();
            MapBasedValueSource vs = new MapBasedValueSource((Map)this.project.getProperties());
            ssi.addValueSource((ValueSource)vs);
            for (PlexusConfiguration envEntry : allEnvEntries = this.envEntries.getChildren("env-entry")) {
                String childDescription = this.interpolate((Interpolator)ssi, envEntry.getChild("description").getValue());
                String childEnvEntryName = this.interpolate((Interpolator)ssi, envEntry.getChild("env-entry-name").getValue());
                String childEnvEntryType = this.interpolate((Interpolator)ssi, envEntry.getChild("env-entry-type").getValue());
                String childEnvEntryValue = this.interpolate((Interpolator)ssi, envEntry.getChild("env-entry-value").getValue());
                try {
                    result.add(new EnvEntry(childDescription, childEnvEntryName, childEnvEntryType, childEnvEntryValue));
                }
                catch (IllegalArgumentException e) {
                    throw new EarPluginException("Invalid env-entry [" + envEntry + "]", e);
                }
            }
            return result;
        }
        catch (PlexusConfigurationException e) {
            throw new EarPluginException("Invalid env-entry configuration", e);
        }
        catch (InterpolationException e) {
            throw new EarPluginException("Interpolation exception:", e);
        }
    }

    private List<EjbRef> buildEjbEntries() throws EarPluginException {
        ArrayList<EjbRef> result = new ArrayList<EjbRef>();
        if (this.ejbRefs == null) {
            return result;
        }
        try {
            PlexusConfiguration[] allEjbEntries;
            StringSearchInterpolator ssi = new StringSearchInterpolator();
            MapBasedValueSource vs = new MapBasedValueSource((Map)this.project.getProperties());
            ssi.addValueSource((ValueSource)vs);
            for (PlexusConfiguration ejbEntry : allEjbEntries = this.ejbRefs.getChildren("ejb-ref")) {
                String childDescription = this.interpolate((Interpolator)ssi, ejbEntry.getChild("description").getValue());
                String childEjbEntryName = this.interpolate((Interpolator)ssi, ejbEntry.getChild("ejb-ref-name").getValue());
                String childEjbEntryType = this.interpolate((Interpolator)ssi, ejbEntry.getChild("ejb-ref-type").getValue());
                String childEjbLookupNameValue = this.interpolate((Interpolator)ssi, ejbEntry.getChild("lookup-name").getValue());
                try {
                    result.add(new EjbRef(childDescription, childEjbEntryName, childEjbEntryType, childEjbLookupNameValue));
                }
                catch (IllegalArgumentException e) {
                    throw new EarPluginException("Invalid ejb-ref [" + ejbEntry + "]", e);
                }
            }
            return result;
        }
        catch (PlexusConfigurationException e) {
            throw new EarPluginException("Invalid ejb-ref configuration", e);
        }
        catch (InterpolationException e) {
            throw new EarPluginException("Interpolation exception:", e);
        }
    }

    private String getActualLibraryDirectory() throws EarPluginException {
        String mode;
        String string = mode = this.libraryDirectoryMode == null ? DEFAULT : this.libraryDirectoryMode.toUpperCase();
        if (DEFAULT.equals(mode)) {
            return this.defaultLibBundleDir;
        }
        if (EMPTY.equals(mode)) {
            return "";
        }
        if (NONE.equals(mode)) {
            return null;
        }
        throw new EarPluginException("Unsupported library directory mode [" + this.libraryDirectoryMode + "] Supported modes " + Arrays.asList(DEFAULT, EMPTY, NONE));
    }
}

