/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.fromDependencies;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.fromDependencies.AbstractFromDependenciesMojo;
import org.apache.maven.plugins.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.plugins.dependency.utils.filters.MarkerFileFilter;
import org.apache.maven.plugins.dependency.utils.markers.DefaultFileMarkerHandler;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;

@Mojo(name="unpack-dependencies", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class UnpackDependenciesMojo
extends AbstractFromDependenciesMojo {
    @Parameter(property="mdep.unpack.includes")
    private String includes;
    @Parameter(property="mdep.unpack.excludes")
    private String excludes;
    @Parameter(property="mdep.unpack.encoding")
    private String encoding;

    @Override
    protected void doExecute() throws MojoExecutionException {
        DependencyStatusSets dss = this.getDependencySets(this.failOnMissingClassifierArtifact);
        for (Artifact artifact : dss.getResolvedDependencies()) {
            File destDir = DependencyUtil.getFormattedOutputDirectory(this.useSubDirectoryPerScope, this.useSubDirectoryPerType, this.useSubDirectoryPerArtifact, this.useRepositoryLayout, this.stripVersion, this.outputDirectory, artifact);
            this.unpack(artifact, destDir, this.getIncludes(), this.getExcludes(), this.getEncoding());
            DefaultFileMarkerHandler handler = new DefaultFileMarkerHandler(artifact, this.markersDirectory);
            handler.setMarker();
        }
        for (Artifact artifact : dss.getSkippedDependencies()) {
            this.getLog().info((CharSequence)(artifact.getId() + " already exists in destination."));
        }
    }

    @Override
    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new MarkerFileFilter(this.overWriteReleases, this.overWriteSnapshots, this.overWriteIfNewer, new DefaultFileMarkerHandler(this.markersDirectory));
    }

    public String getExcludes() {
        return DependencyUtil.cleanToBeTokenizedString(this.excludes);
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getIncludes() {
        return DependencyUtil.cleanToBeTokenizedString(this.includes);
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

