/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.dependency.utils.DependencySilentLog;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDependencyMojo
extends AbstractMojo {
    @Component
    protected ArtifactFactory factory;
    @Component
    protected ArtifactResolver resolver;
    @Component(role=ArtifactCollector.class)
    protected ArtifactCollector artifactCollector;
    @Component(role=ArtifactMetadataSource.class, hint="maven")
    protected ArtifactMetadataSource artifactMetadataSource;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository local;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    protected List<ArtifactRepository> remoteRepos;
    @Component
    protected ArchiverManager archiverManager;
    @Parameter(property="dependency.useJvmChmod", defaultValue="true")
    protected boolean useJvmChmod = true;
    @Parameter(property="dependency.ignorePermissions", defaultValue="false")
    protected boolean ignorePermissions;
    @Component
    protected MavenProject project;
    @Parameter(defaultValue="${reactorProjects}")
    protected List<MavenProject> reactorProjects;
    @Parameter(property="silent", defaultValue="false")
    public boolean silent;
    @Parameter(property="outputAbsoluteArtifactFilename", defaultValue="false")
    protected boolean outputAbsoluteArtifactFilename;
    @Parameter(property="mdep.skip", defaultValue="false")
    private boolean skip;
    private Log log;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        this.doExecute();
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    public Log getLog() {
        if (this.log == null) {
            this.log = this.silent ? new DependencySilentLog() : super.getLog();
        }
        return this.log;
    }

    public ArchiverManager getArchiverManager() {
        return this.archiverManager;
    }

    protected void copyFile(File artifact, File destFile) throws MojoExecutionException {
        Log theLog = this.getLog();
        try {
            theLog.info((CharSequence)("Copying " + (this.outputAbsoluteArtifactFilename ? artifact.getAbsolutePath() : artifact.getName()) + " to " + destFile));
            if (artifact.isDirectory()) {
                throw new MojoExecutionException("Artifact has not been packaged yet. When used on reactor artifact, copy should be executed after packaging: see MDEP-187.");
            }
            FileUtils.copyFile((File)artifact, (File)destFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying artifact from " + artifact + " to " + destFile, (Exception)e);
        }
    }

    protected void unpack(Artifact artifact, File location) throws MojoExecutionException {
        this.unpack(artifact, location, null, null);
    }

    protected void unpack(Artifact artifact, File location, String includes, String excludes) throws MojoExecutionException {
        File file = artifact.getFile();
        try {
            UnArchiver unArchiver;
            this.logUnpack(file, location, includes, excludes);
            location.mkdirs();
            if (file.isDirectory()) {
                throw new MojoExecutionException("Artifact has not been packaged yet. When used on reactor artifact, unpack should be executed after packaging: see MDEP-98.");
            }
            try {
                unArchiver = this.archiverManager.getUnArchiver(artifact.getType());
                this.getLog().debug((CharSequence)("Found unArchiver by type: " + unArchiver));
            }
            catch (NoSuchArchiverException e) {
                unArchiver = this.archiverManager.getUnArchiver(file);
                this.getLog().debug((CharSequence)("Found unArchiver by extension: " + unArchiver));
            }
            unArchiver.setUseJvmChmod(this.useJvmChmod);
            unArchiver.setIgnorePermissions(this.ignorePermissions);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            if (StringUtils.isNotEmpty((String)excludes) || StringUtils.isNotEmpty((String)includes)) {
                IncludeExcludeFileSelector[] selectors = new IncludeExcludeFileSelector[]{new IncludeExcludeFileSelector()};
                if (StringUtils.isNotEmpty((String)excludes)) {
                    selectors[0].setExcludes(excludes.split(","));
                }
                if (StringUtils.isNotEmpty((String)includes)) {
                    selectors[0].setIncludes(includes.split(","));
                }
                unArchiver.setFileSelectors((FileSelector[])selectors);
            }
            if (this.silent) {
                this.silenceUnarchiver(unArchiver);
            }
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unknown archiver type", (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + " to: " + location + "\r\n" + e.toString(), (Exception)((Object)e));
        }
    }

    private void silenceUnarchiver(UnArchiver unArchiver) {
        try {
            Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)"logger", unArchiver.getClass());
            field.setAccessible(true);
            field.set(unArchiver, this.getLog());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ArtifactFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ArtifactFactory factory) {
        this.factory = factory;
    }

    public MavenProject getProject() {
        return this.project;
    }

    protected ArtifactRepository getLocal() {
        return this.local;
    }

    public void setLocal(ArtifactRepository local) {
        this.local = local;
    }

    public List<ArtifactRepository> getRemoteRepos() {
        return this.remoteRepos;
    }

    public void setRemoteRepos(List<ArtifactRepository> remoteRepos) {
        this.remoteRepos = remoteRepos;
    }

    public ArtifactResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ArtifactResolver resolver) {
        this.resolver = resolver;
    }

    public void setArchiverManager(ArchiverManager archiverManager) {
        this.archiverManager = archiverManager;
    }

    public ArtifactCollector getArtifactCollector() {
        return this.artifactCollector;
    }

    public void setArtifactCollector(ArtifactCollector theArtifactCollector) {
        this.artifactCollector = theArtifactCollector;
    }

    public ArtifactMetadataSource getArtifactMetadataSource() {
        return this.artifactMetadataSource;
    }

    public void setArtifactMetadataSource(ArtifactMetadataSource theArtifactMetadataSource) {
        this.artifactMetadataSource = theArtifactMetadataSource;
    }

    public boolean isUseJvmChmod() {
        return this.useJvmChmod;
    }

    public void setUseJvmChmod(boolean useJvmChmod) {
        this.useJvmChmod = useJvmChmod;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private void logUnpack(File file, File location, String includes, String excludes) {
        if (!this.getLog().isInfoEnabled()) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("Unpacking ");
        msg.append(file);
        msg.append(" to ");
        msg.append(location);
        if (includes != null && excludes != null) {
            msg.append(" with includes \"");
            msg.append(includes);
            msg.append("\" and excludes \"");
            msg.append(excludes);
            msg.append("\"");
        } else if (includes != null) {
            msg.append(" with includes \"");
            msg.append(includes);
            msg.append("\"");
        } else if (excludes != null) {
            msg.append(" with excludes \"");
            msg.append(excludes);
            msg.append("\"");
        }
        this.getLog().info((CharSequence)msg.toString());
    }
}

