/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.checkstyle;

import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.checkstyle.CompositeAuditListener;
import org.apache.maven.plugins.checkstyle.RuleUtil;
import org.apache.maven.plugins.checkstyle.exec.CheckstyleExecutor;
import org.apache.maven.plugins.checkstyle.exec.CheckstyleExecutorException;
import org.apache.maven.plugins.checkstyle.exec.CheckstyleExecutorRequest;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.NONE, threadSafe=true)
public class CheckstyleViolationCheckMojo
extends AbstractMojo {
    private static final String JAVA_FILES = "**\\/*.java";
    private static final String DEFAULT_CONFIG_LOCATION = "sun_checks.xml";
    @Parameter(property="checkstyle.output.file", defaultValue="${project.build.directory}/checkstyle-result.xml")
    private File outputFile;
    @Parameter(property="checkstyle.output.format", defaultValue="xml")
    private String outputFileFormat;
    @Parameter(property="checkstyle.failOnViolation", defaultValue="true")
    private boolean failOnViolation;
    @Parameter(property="checkstyle.maxAllowedViolations", defaultValue="0")
    private int maxAllowedViolations;
    @Parameter(property="checkstyle.violationSeverity", defaultValue="error")
    private String violationSeverity = "error";
    @Parameter(property="checkstyle.violation.ignore")
    private String violationIgnore;
    @Parameter(property="checkstyle.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="checkstyle.skipExec", defaultValue="false")
    private boolean skipExec;
    @Parameter(property="checkstyle.console", defaultValue="true")
    private boolean logViolationsToConsole;
    @Parameter(defaultValue="${project.resources}", readonly=true)
    protected List<Resource> resources;
    @Parameter(defaultValue="${project.testResources}", readonly=true)
    protected List<Resource> testResources;
    @Parameter(property="checkstyle.config.location", defaultValue="sun_checks.xml")
    private String configLocation;
    @Parameter(property="checkstyle.properties.location")
    private String propertiesLocation;
    @Parameter
    private String propertyExpansion;
    @Parameter(property="checkstyle.header.file", defaultValue="LICENSE.txt")
    private String headerLocation;
    @Parameter(defaultValue="${project.build.directory}/checkstyle-cachefile")
    private String cacheFile;
    @Parameter(property="checkstyle.suppression.expression", defaultValue="checkstyle.suppressions.file")
    private String suppressionsFileExpression;
    @Parameter(property="checkstyle.suppressions.location")
    private String suppressionsLocation;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Component(role=CheckstyleExecutor.class, hint="default")
    protected CheckstyleExecutor checkstyleExecutor;
    @Parameter(property="checkstyle.consoleOutput", defaultValue="false")
    private boolean consoleOutput;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    private PluginDescriptor plugin;
    @Parameter
    private File useFile;
    @Parameter(property="checkstyle.excludes")
    private String excludes;
    @Parameter(property="checkstyle.includes", defaultValue="**\\/*.java", required=true)
    private String includes;
    @Parameter(property="checkstyle.resourceExcludes")
    private String resourceExcludes;
    @Parameter(property="checkstyle.resourceIncludes", defaultValue="**/*.properties", required=true)
    private String resourceIncludes;
    @Parameter(defaultValue="false")
    private boolean failsOnError;
    @Deprecated
    @Parameter
    private File testSourceDirectory;
    @Parameter
    private List<String> testSourceDirectories;
    @Parameter(defaultValue="false")
    private boolean includeTestSourceDirectory;
    @Deprecated
    @Parameter
    private File sourceDirectory;
    @Parameter
    private List<String> sourceDirectories;
    @Parameter(property="checkstyle.includeResources", defaultValue="true", required=true)
    private boolean includeResources = true;
    @Parameter(property="checkstyle.includeTestResources", defaultValue="true", required=true)
    private boolean includeTestResources = true;
    @Parameter
    private PlexusConfiguration checkstyleRules;
    @Parameter(property="checkstyle.output.rules.file", defaultValue="${project.build.directory}/checkstyle-rules.xml")
    private File rulesFiles;
    @Parameter(defaultValue="<?xml version=\"1.0\"?>\n<!DOCTYPE module PUBLIC \"-//Checkstyle//DTD Checkstyle Configuration 1.3//EN\"\n        \"https://checkstyle.org/dtds/configuration_1_3.dtd\">\n")
    private String checkstyleRulesHeader;
    @Parameter(defaultValue="false")
    private boolean omitIgnoredModules;
    private ByteArrayOutputStream stringOutputStream;
    private File outputXmlFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkDeprecatedParameterUsage(this.sourceDirectory, "sourceDirectory", "sourceDirectories");
        this.checkDeprecatedParameterUsage(this.testSourceDirectory, "testSourceDirectory", "testSourceDirectories");
        if (this.skip) {
            return;
        }
        this.outputXmlFile = this.outputFile;
        if (!this.skipExec) {
            if (this.checkstyleRules != null) {
                if (!DEFAULT_CONFIG_LOCATION.equals(this.configLocation)) {
                    throw new MojoExecutionException("If you use inline configuration for rules, don't specify a configLocation");
                }
                if (this.checkstyleRules.getChildCount() > 1) {
                    throw new MojoExecutionException("Currently only one root module is supported");
                }
                PlexusConfiguration checkerModule = this.checkstyleRules.getChild(0);
                try {
                    FileUtils.forceMkdir((File)this.rulesFiles.getParentFile());
                    FileUtils.fileWrite((File)this.rulesFiles, (String)(this.checkstyleRulesHeader + checkerModule.toString()));
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                this.configLocation = this.rulesFiles.getAbsolutePath();
            }
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                CheckstyleExecutorRequest request = new CheckstyleExecutorRequest();
                request.setConsoleListener(this.getConsoleListener()).setConsoleOutput(this.consoleOutput).setExcludes(this.excludes).setFailsOnError(this.failsOnError).setIncludes(this.includes).setResourceIncludes(this.resourceIncludes).setResourceExcludes(this.resourceExcludes).setIncludeResources(this.includeResources).setIncludeTestResources(this.includeTestResources).setIncludeTestSourceDirectory(this.includeTestSourceDirectory).setListener(this.getListener()).setProject(this.project).setSourceDirectories(this.getSourceDirectories()).setResources(this.resources).setTestResources(this.testResources).setStringOutputStream(this.stringOutputStream).setSuppressionsLocation(this.suppressionsLocation).setTestSourceDirectories(this.getTestSourceDirectories()).setConfigLocation(this.configLocation).setConfigurationArtifacts(this.collectArtifacts("config")).setPropertyExpansion(this.propertyExpansion).setHeaderLocation(this.headerLocation).setLicenseArtifacts(this.collectArtifacts("license")).setCacheFile(this.cacheFile).setSuppressionsFileExpression(this.suppressionsFileExpression).setEncoding(this.encoding).setPropertiesLocation(this.propertiesLocation).setOmitIgnoredModules(this.omitIgnoredModules);
                this.checkstyleExecutor.executeCheckstyle(request);
            }
            catch (CheckstyleException e) {
                throw new MojoExecutionException("Failed during checkstyle configuration", (Exception)((Object)e));
            }
            catch (CheckstyleExecutorException e) {
                throw new MojoExecutionException("Failed during checkstyle execution", (Exception)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        if (!"xml".equals(this.outputFileFormat) && this.skipExec) {
            throw new MojoExecutionException("Output format is '" + this.outputFileFormat + "', checkstyle:check requires format to be 'xml' when using skipExec.");
        }
        if (!this.outputXmlFile.exists()) {
            this.getLog().info((CharSequence)"Unable to perform checkstyle:check, unable to find checkstyle:checkstyle outputFile.");
            return;
        }
        try (BufferedReader reader = new BufferedReader((Reader)ReaderFactory.newXmlReader((File)this.outputXmlFile));){
            MXParser xpp = new MXParser();
            xpp.setInput((Reader)reader);
            int violations = this.countViolations((XmlPullParser)xpp);
            if (violations > this.maxAllowedViolations) {
                if (this.failOnViolation) {
                    String msg = "You have " + violations + " Checkstyle violation" + (violations > 1 ? "s" : "") + ".";
                    if (this.maxAllowedViolations > 0) {
                        msg = msg + " The maximum number of allowed violations is " + this.maxAllowedViolations + ".";
                    }
                    throw new MojoFailureException(msg);
                }
                this.getLog().warn((CharSequence)"checkstyle:check violations detected but failOnViolation set to false");
            }
        }
        catch (IOException | XmlPullParserException e) {
            throw new MojoExecutionException("Unable to read Checkstyle results xml: " + this.outputXmlFile.getAbsolutePath(), (Exception)e);
        }
    }

    private void checkDeprecatedParameterUsage(Object parameter, String name, String replacement) throws MojoFailureException {
        if (parameter != null) {
            throw new MojoFailureException("You are using '" + name + "' which has been removed from the maven-checkstyle-plugin. Please use '" + replacement + "' and refer to the >>Major Version Upgrade to version 3.0.0<< on the plugin site.");
        }
    }

    private int countViolations(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int count = 0;
        int ignoreCount = 0;
        List<RuleUtil.Matcher> ignores = this.violationIgnore == null ? Collections.emptyList() : RuleUtil.parseMatchers(this.violationIgnore.split(","));
        String basedir = this.project.getBasedir().getAbsolutePath();
        String file = "";
        int eventType = xpp.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                String severity;
                if ("file".equals(xpp.getName())) {
                    file = PathTool.getRelativeFilePath((String)basedir, (String)xpp.getAttributeValue("", "name"));
                } else if ("error".equals(xpp.getName()) && this.isViolation(severity = xpp.getAttributeValue("", "severity"))) {
                    String source = xpp.getAttributeValue("", "source");
                    if (this.ignore(ignores, source)) {
                        ++ignoreCount;
                    } else {
                        ++count;
                        if (this.logViolationsToConsole) {
                            String line = xpp.getAttributeValue("", "line");
                            String column = xpp.getAttributeValue("", "column");
                            String message = xpp.getAttributeValue("", "message");
                            String rule = RuleUtil.getName(source);
                            String category = RuleUtil.getCategory(source);
                            this.log(severity, file + ":[" + line + (column == null ? "" : ',' + column) + "] (" + category + ") " + rule + ": " + message);
                        }
                    }
                }
            }
            eventType = xpp.next();
        }
        if (ignoreCount > 0) {
            this.getLog().info((CharSequence)("Ignored " + ignoreCount + " error" + (ignoreCount > 1 ? "s" : "") + ", " + count + " violation" + (count > 1 ? "s" : "") + " remaining."));
        }
        return count;
    }

    private void log(String severity, String message) {
        if ("info".equals(severity)) {
            this.getLog().info((CharSequence)message);
        } else if ("warning".equals(severity)) {
            this.getLog().warn((CharSequence)message);
        } else {
            this.getLog().error((CharSequence)message);
        }
    }

    private boolean isViolation(String severity) {
        if ("error".equals(severity)) {
            return "error".equals(this.violationSeverity) || "warning".equals(this.violationSeverity) || "info".equals(this.violationSeverity);
        }
        if ("warning".equals(severity)) {
            return "warning".equals(this.violationSeverity) || "info".equals(this.violationSeverity);
        }
        if ("info".equals(severity)) {
            return "info".equals(this.violationSeverity);
        }
        return false;
    }

    private boolean ignore(List<RuleUtil.Matcher> ignores, String source) {
        for (RuleUtil.Matcher ignore : ignores) {
            if (!ignore.match(source)) continue;
            return true;
        }
        return false;
    }

    private DefaultLogger getConsoleListener() throws MojoExecutionException {
        DefaultLogger consoleListener;
        if (this.useFile == null) {
            this.stringOutputStream = new ByteArrayOutputStream();
            consoleListener = new DefaultLogger((OutputStream)this.stringOutputStream, AutomaticBean.OutputStreamOptions.NONE);
        } else {
            OutputStream out = this.getOutputStream(this.useFile);
            consoleListener = new DefaultLogger(out, AutomaticBean.OutputStreamOptions.CLOSE);
        }
        return consoleListener;
    }

    private OutputStream getOutputStream(File file) throws MojoExecutionException {
        FileOutputStream fileOutputStream;
        File parentFile = file.getAbsoluteFile().getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Unable to create output stream: " + file, (Exception)e);
        }
        return fileOutputStream;
    }

    private AuditListener getListener() throws MojoFailureException, MojoExecutionException {
        Object listener = null;
        if (StringUtils.isNotEmpty((String)this.outputFileFormat)) {
            File resultFile = this.outputFile;
            OutputStream out = this.getOutputStream(resultFile);
            if ("xml".equals(this.outputFileFormat)) {
                listener = new XMLLogger(out, AutomaticBean.OutputStreamOptions.CLOSE);
            } else if ("plain".equals(this.outputFileFormat)) {
                try {
                    this.outputXmlFile = File.createTempFile("checkstyle-result", ".xml");
                    this.outputXmlFile.deleteOnExit();
                    OutputStream xmlOut = this.getOutputStream(this.outputXmlFile);
                    CompositeAuditListener compoundListener = new CompositeAuditListener();
                    compoundListener.addListener((AuditListener)new XMLLogger(xmlOut, AutomaticBean.OutputStreamOptions.CLOSE));
                    compoundListener.addListener((AuditListener)new DefaultLogger(out, AutomaticBean.OutputStreamOptions.CLOSE));
                    listener = compoundListener;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to create temporary file", (Exception)e);
                }
            } else {
                throw new MojoFailureException("Invalid output file format: (" + this.outputFileFormat + "). Must be 'plain' or 'xml'.");
            }
        }
        return listener;
    }

    private List<Artifact> collectArtifacts(String hint) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        PluginManagement pluginManagement = this.project.getBuild().getPluginManagement();
        if (pluginManagement != null) {
            artifacts.addAll(this.getCheckstylePluginDependenciesAsArtifacts(pluginManagement.getPluginsAsMap(), hint));
        }
        artifacts.addAll(this.getCheckstylePluginDependenciesAsArtifacts(this.project.getBuild().getPluginsAsMap(), hint));
        return artifacts;
    }

    private List<Artifact> getCheckstylePluginDependenciesAsArtifacts(Map<String, Plugin> plugins, String hint) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        Plugin checkstylePlugin = plugins.get(this.plugin.getGroupId() + ":" + this.plugin.getArtifactId());
        if (checkstylePlugin != null) {
            for (Dependency dep : checkstylePlugin.getDependencies()) {
                String depKey = dep.getGroupId() + ":" + dep.getArtifactId();
                artifacts.add((Artifact)this.plugin.getArtifactMap().get(depKey));
            }
        }
        return artifacts;
    }

    private List<File> getSourceDirectories() {
        if (this.sourceDirectories == null) {
            this.sourceDirectories = this.project.getCompileSourceRoots();
        }
        ArrayList<File> sourceDirs = new ArrayList<File>(this.sourceDirectories.size());
        for (String sourceDir : this.sourceDirectories) {
            sourceDirs.add(FileUtils.resolveFile((File)this.project.getBasedir(), (String)sourceDir));
        }
        return sourceDirs;
    }

    private List<File> getTestSourceDirectories() {
        if (this.testSourceDirectories == null) {
            this.testSourceDirectories = this.project.getTestCompileSourceRoots();
        }
        ArrayList<File> testSourceDirs = new ArrayList<File>(this.testSourceDirectories.size());
        for (String testSourceDir : this.testSourceDirectories) {
            testSourceDirs.add(FileUtils.resolveFile((File)this.project.getBasedir(), (String)testSourceDir));
        }
        return testSourceDirs;
    }
}

