/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.checkstyle.RuleUtil;
import org.apache.maven.plugin.checkstyle.exec.CheckstyleExecutor;
import org.apache.maven.plugin.checkstyle.exec.CheckstyleExecutorException;
import org.apache.maven.plugin.checkstyle.exec.CheckstyleExecutorRequest;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class CheckstyleViolationCheckMojo
extends AbstractMojo {
    private static final String JAVA_FILES = "**\\/*.java";
    private static final String CHECKSTYLE_FILE_HEADER = "<?xml version=\"1.0\"?>\n<!DOCTYPE module PUBLIC \"-//Puppy Crawl//DTD Check Configuration 1.2//EN\"\n        \"http://www.puppycrawl.com/dtds/configuration_1_2.dtd\">\n";
    @Parameter(property="checkstyle.output.file", defaultValue="${project.build.directory}/checkstyle-result.xml")
    private File outputFile;
    @Parameter(property="checkstyle.output.format", defaultValue="xml")
    private String outputFileFormat;
    @Parameter(property="checkstyle.failOnViolation", defaultValue="true")
    private boolean failOnViolation;
    @Parameter(property="checkstyle.maxAllowedViolations", defaultValue="0")
    private int maxAllowedViolations;
    @Parameter(property="checkstyle.violationSeverity", defaultValue="error")
    private String violationSeverity = "error";
    @Parameter(property="checkstyle.violation.ignore")
    private String violationIgnore;
    @Parameter(property="checkstyle.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="checkstyle.skipExec", defaultValue="false")
    private boolean skipExec;
    @Parameter(property="checkstyle.console", defaultValue="true")
    private boolean logViolationsToConsole;
    @Parameter(defaultValue="${project.resources}", readonly=true)
    protected List<Resource> resources;
    @Parameter(property="checkstyle.config.location", defaultValue="config/sun_checks.xml")
    private String configLocation;
    @Parameter(property="checkstyle.properties.location")
    private String propertiesLocation;
    @Parameter
    private String propertyExpansion;
    @Parameter(property="checkstyle.header.file", defaultValue="LICENSE.txt")
    private String headerLocation;
    @Parameter(defaultValue="${project.build.directory}/checkstyle-cachefile")
    private String cacheFile;
    @Parameter(property="checkstyle.suppression.expression", defaultValue="checkstyle.suppressions.file")
    private String suppressionsFileExpression;
    @Parameter(property="checkstyle.suppressions.location")
    private String suppressionsLocation;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Component(role=CheckstyleExecutor.class, hint="default")
    protected CheckstyleExecutor checkstyleExecutor;
    @Parameter(property="checkstyle.consoleOutput", defaultValue="false")
    private boolean consoleOutput;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    private PluginDescriptor plugin;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Parameter
    private File useFile;
    @Parameter(property="checkstyle.excludes")
    private String excludes;
    @Parameter(property="checkstyle.includes", defaultValue="**\\/*.java", required=true)
    private String includes;
    @Parameter(property="checkstyle.resourceExcludes")
    private String resourceExcludes;
    @Parameter(property="checkstyle.resourceIncludes", defaultValue="**/*.properties", required=true)
    private String resourceIncludes;
    @Parameter(defaultValue="false")
    private boolean failsOnError;
    @Deprecated
    @Parameter
    private File testSourceDirectory;
    @Parameter(defaultValue="${project.testCompileSourceRoots}")
    private List<String> testSourceDirectories;
    @Parameter(defaultValue="false")
    private boolean includeTestSourceDirectory;
    @Deprecated
    @Parameter
    private File sourceDirectory;
    @Parameter(defaultValue="${project.compileSourceRoots}")
    private List<String> sourceDirectories;
    @Parameter(property="checkstyle.includeResources", defaultValue="true", required=true)
    private boolean includeResources = true;
    @Parameter(property="checkstyle.includeTestResources", defaultValue="true", required=true)
    private boolean includeTestResources = true;
    @Parameter
    private PlexusConfiguration checkstyleRules;
    @Parameter(property="checkstyle.output.rules.file", defaultValue="${project.build.directory}/checkstyle-rules.xml")
    private File rulesFiles;
    private ByteArrayOutputStream stringOutputStream;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        if (!this.skipExec) {
            if (this.checkstyleRules != null) {
                if (!"config/sun_checks.xml".equals(this.configLocation)) {
                    throw new MojoExecutionException("If you use inline configuration for rules, don't specify a configLocation");
                }
                if (this.checkstyleRules.getChildCount() > 1) {
                    throw new MojoExecutionException("Currently only one root module is supported");
                }
                PlexusConfiguration checkerModule = this.checkstyleRules.getChild(0);
                try {
                    FileUtils.forceMkdir((File)this.rulesFiles.getParentFile());
                    FileUtils.fileWrite((File)this.rulesFiles, (String)(CHECKSTYLE_FILE_HEADER + checkerModule.toString()));
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                this.configLocation = this.rulesFiles.getAbsolutePath();
            }
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                CheckstyleExecutorRequest request = new CheckstyleExecutorRequest();
                request.setConsoleListener(this.getConsoleListener()).setConsoleOutput(this.consoleOutput).setExcludes(this.excludes).setFailsOnError(this.failsOnError).setIncludes(this.includes).setResourceIncludes(this.resourceIncludes).setResourceExcludes(this.resourceExcludes).setIncludeResources(this.includeResources).setIncludeTestResources(this.includeTestResources).setIncludeTestSourceDirectory(this.includeTestSourceDirectory).setListener(this.getListener()).setProject(this.project).setSourceDirectories(this.getSourceDirectories()).setResources(this.resources).setStringOutputStream(this.stringOutputStream).setSuppressionsLocation(this.suppressionsLocation).setTestSourceDirectories(this.getTestSourceDirectories()).setConfigLocation(this.configLocation).setConfigurationArtifacts(this.collectArtifacts("config")).setPropertyExpansion(this.propertyExpansion).setHeaderLocation(this.headerLocation).setLicenseArtifacts(this.collectArtifacts("license")).setCacheFile(this.cacheFile).setSuppressionsFileExpression(this.suppressionsFileExpression).setEncoding(this.encoding).setPropertiesLocation(this.propertiesLocation);
                this.checkstyleExecutor.executeCheckstyle(request);
            }
            catch (CheckstyleException e) {
                throw new MojoExecutionException("Failed during checkstyle configuration", (Exception)((Object)e));
            }
            catch (CheckstyleExecutorException e) {
                throw new MojoExecutionException("Failed during checkstyle execution", (Exception)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        if (!"xml".equals(this.outputFileFormat)) {
            throw new MojoExecutionException("Output format is '" + this.outputFileFormat + "', checkstyle:check requires format to be 'xml'.");
        }
        if (!this.outputFile.exists()) {
            this.getLog().info((CharSequence)"Unable to perform checkstyle:check, unable to find checkstyle:checkstyle outputFile.");
            return;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader((Reader)ReaderFactory.newXmlReader((File)this.outputFile));
            MXParser xpp = new MXParser();
            xpp.setInput((Reader)reader);
            int violations = this.countViolations((XmlPullParser)xpp);
            if (violations > this.maxAllowedViolations) {
                if (this.failOnViolation) {
                    String msg = "You have " + violations + " Checkstyle violation" + (violations > 1 ? "s" : "") + ".";
                    if (this.maxAllowedViolations <= 0) throw new MojoFailureException(msg);
                    msg = msg + " The maximum number of allowed violations is " + this.maxAllowedViolations + ".";
                    throw new MojoFailureException(msg);
                }
                this.getLog().warn((CharSequence)"checkstyle:check violations detected but failOnViolation set to false");
            }
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Unable to read Checkstyle results xml: " + this.outputFile.getAbsolutePath(), (Exception)e);
                catch (XmlPullParserException e2) {
                    throw new MojoExecutionException("Unable to read Checkstyle results xml: " + this.outputFile.getAbsolutePath(), (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
    }

    private int countViolations(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int count = 0;
        int ignoreCount = 0;
        RuleUtil.Matcher[] ignores = this.violationIgnore == null ? null : RuleUtil.parseMatchers(this.violationIgnore.split(","));
        String basedir = this.project.getBasedir().getAbsolutePath();
        String file = "";
        int eventType = xpp.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                String severity;
                if ("file".equals(xpp.getName())) {
                    file = PathTool.getRelativeFilePath((String)basedir, (String)xpp.getAttributeValue("", "name"));
                } else if ("error".equals(xpp.getName()) && this.isViolation(severity = xpp.getAttributeValue("", "severity"))) {
                    String source = xpp.getAttributeValue("", "source");
                    if (this.ignore(ignores, source)) {
                        ++ignoreCount;
                    } else {
                        ++count;
                        if (this.logViolationsToConsole) {
                            String line = xpp.getAttributeValue("", "line");
                            String column = xpp.getAttributeValue("", "column");
                            String message = xpp.getAttributeValue("", "message");
                            String rule = RuleUtil.getName(source);
                            String category = RuleUtil.getCategory(source);
                            this.log(severity, file + '[' + line + (column == null ? "" : ':' + column) + "] (" + category + ") " + rule + ": " + message);
                        }
                    }
                }
            }
            eventType = xpp.next();
        }
        if (ignoreCount > 0) {
            this.getLog().info((CharSequence)("Ignored " + ignoreCount + " error" + (ignoreCount > 1 ? "s" : "") + ", " + count + " violation" + (count > 1 ? "s" : "") + " remaining."));
        }
        return count;
    }

    private void log(String severity, String message) {
        if ("info".equals(severity)) {
            this.getLog().info((CharSequence)message);
        } else if ("warning".equals(severity)) {
            this.getLog().warn((CharSequence)message);
        } else {
            this.getLog().error((CharSequence)message);
        }
    }

    private boolean isViolation(String severity) {
        if ("error".equals(severity)) {
            return "error".equals(this.violationSeverity) || "warning".equals(this.violationSeverity) || "info".equals(this.violationSeverity);
        }
        if ("warning".equals(severity)) {
            return "warning".equals(this.violationSeverity) || "info".equals(this.violationSeverity);
        }
        if ("info".equals(severity)) {
            return "info".equals(this.violationSeverity);
        }
        return false;
    }

    private boolean ignore(RuleUtil.Matcher[] ignores, String source) {
        if (ignores != null) {
            for (RuleUtil.Matcher ignore : ignores) {
                if (!ignore.match(source)) continue;
                return true;
            }
        }
        return false;
    }

    private DefaultLogger getConsoleListener() throws MojoExecutionException {
        DefaultLogger consoleListener;
        if (this.useFile == null) {
            this.stringOutputStream = new ByteArrayOutputStream();
            consoleListener = new DefaultLogger((OutputStream)this.stringOutputStream, false);
        } else {
            OutputStream out = this.getOutputStream(this.useFile);
            consoleListener = new DefaultLogger(out, true);
        }
        return consoleListener;
    }

    private OutputStream getOutputStream(File file) throws MojoExecutionException {
        FileOutputStream fileOutputStream;
        File parentFile = file.getAbsoluteFile().getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Unable to create output stream: " + file, (Exception)e);
        }
        return fileOutputStream;
    }

    private AuditListener getListener() throws MojoFailureException, MojoExecutionException {
        XMLLogger listener = null;
        if (StringUtils.isNotEmpty((String)this.outputFileFormat)) {
            File resultFile = this.outputFile;
            OutputStream out = this.getOutputStream(resultFile);
            if ("xml".equals(this.outputFileFormat)) {
                listener = new XMLLogger(out, true);
            } else if ("plain".equals(this.outputFileFormat)) {
                listener = new DefaultLogger(out, true);
            } else {
                throw new MojoFailureException("Invalid output file format: (" + this.outputFileFormat + "). Must be 'plain' or 'xml'.");
            }
        }
        return listener;
    }

    private List<Artifact> collectArtifacts(String hint) {
        if (this.plugin == null || this.plugin.getGroupId() == null) {
            this.plugin = this.mojoExecution.getMojoDescriptor().getPluginDescriptor();
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        PluginManagement pluginManagement = this.project.getBuild().getPluginManagement();
        if (pluginManagement != null) {
            artifacts.addAll(this.getCheckstylePluginDependenciesAsArtifacts(pluginManagement.getPluginsAsMap(), hint));
        }
        artifacts.addAll(this.getCheckstylePluginDependenciesAsArtifacts(this.project.getBuild().getPluginsAsMap(), hint));
        return artifacts;
    }

    private List<Artifact> getCheckstylePluginDependenciesAsArtifacts(Map<String, Plugin> plugins, String hint) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        Plugin checkstylePlugin = plugins.get(this.plugin.getGroupId() + ":" + this.plugin.getArtifactId());
        if (checkstylePlugin != null) {
            for (Dependency dep : checkstylePlugin.getDependencies()) {
                String depKey = dep.getGroupId() + ":" + dep.getArtifactId();
                artifacts.add((Artifact)this.plugin.getArtifactMap().get(depKey));
            }
        }
        return artifacts;
    }

    private List<File> getSourceDirectories() {
        List<File> sourceDirs = null;
        if (this.sourceDirectory != null) {
            sourceDirs = Collections.singletonList(this.sourceDirectory);
        } else {
            sourceDirs = new ArrayList<File>(this.sourceDirectories.size());
            for (String sourceDir : this.sourceDirectories) {
                sourceDirs.add(FileUtils.resolveFile((File)this.project.getBasedir(), (String)sourceDir));
            }
        }
        return sourceDirs;
    }

    private List<File> getTestSourceDirectories() {
        List<File> testSourceDirs = null;
        if (this.testSourceDirectory != null) {
            testSourceDirs = Collections.singletonList(this.testSourceDirectory);
        } else if (this.testSourceDirectories != null) {
            testSourceDirs = new ArrayList<File>(this.testSourceDirectories.size());
            for (String testSourceDir : this.testSourceDirectories) {
                testSourceDirs.add(FileUtils.resolveFile((File)this.project.getBasedir(), (String)testSourceDir));
            }
        }
        return testSourceDirs;
    }
}

