/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.artifact;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.assembly.artifact.DependencyResolver;
import org.apache.maven.plugin.assembly.utils.FilterUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.StringUtils;

public class DefaultDependencyResolver
extends AbstractLogEnabled
implements DependencyResolver,
Contextualizable {
    private static final String[] PREFERRED_RESOLVER_HINTS = new String[]{"project-cache-aware", "default"};
    private ArtifactResolver resolver;
    private ArtifactMetadataSource metadataSource;
    private ArtifactFactory factory;

    public DefaultDependencyResolver() {
    }

    public DefaultDependencyResolver(ArtifactResolver resolver, ArtifactMetadataSource metadataSource, ArtifactFactory factory, Logger logger) {
        this.resolver = resolver;
        this.metadataSource = metadataSource;
        this.factory = factory;
        this.enableLogging(logger);
    }

    public Set resolveDependencies(MavenProject project, String scope, ArtifactRepository localRepository, List remoteRepositories, boolean resolveTransitively) throws InvalidDependencyVersionException, ArtifactResolutionException, ArtifactNotFoundException {
        List repos = this.aggregateRemoteArtifactRepositories(remoteRepositories, project);
        ScopeArtifactFilter filter = new ScopeArtifactFilter(scope);
        Artifact artifact = this.factory.createBuildArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getPackaging());
        Set dependencyArtifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.factory, (List)project.getDependencies(), null, (ArtifactFilter)filter, (MavenProject)project);
        this.getLogger().debug("Project dependencies are:\n" + StringUtils.join(dependencyArtifacts.iterator(), (String)"\n"));
        if (resolveTransitively) {
            this.getLogger().debug("Resolving project dependencies transitively.");
            return this.resolveTransitively(dependencyArtifacts, artifact, localRepository, repos, (ArtifactFilter)filter, project);
        }
        this.getLogger().debug("Resolving project dependencies ONLY. Transitive dependencies WILL NOT be included in the results.");
        return this.resolveNonTransitively(dependencyArtifacts, artifact, localRepository, repos, (ArtifactFilter)filter);
    }

    private Set resolveNonTransitively(Set dependencyArtifacts, Artifact artifact, ArtifactRepository localRepository, List repos, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        Iterator it = dependencyArtifacts.iterator();
        while (it.hasNext()) {
            Artifact depArtifact = (Artifact)it.next();
            this.resolver.resolve(depArtifact, repos, localRepository);
        }
        return dependencyArtifacts;
    }

    private Set resolveTransitively(Set dependencyArtifacts, Artifact artifact, ArtifactRepository localRepository, List repos, ArtifactFilter filter, MavenProject project) throws InvalidDependencyVersionException, ArtifactResolutionException, ArtifactNotFoundException {
        ArtifactResolutionResult result;
        try {
            result = this.resolver.resolveTransitively(dependencyArtifacts, artifact, this.getManagedVersionMap(project), localRepository, repos, this.metadataSource, filter);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new InvalidDependencyVersionException(e.getMessage(), (Exception)((Object)e));
        }
        this.getLogger().debug("While resolving dependencies of " + project.getId() + ":");
        FilterUtils.reportFilteringStatistics(Collections.singleton(filter), this.getLogger());
        return result.getArtifacts();
    }

    private List aggregateRemoteArtifactRepositories(List remoteRepositories, MavenProject project) {
        ArrayList<List> repoLists = new ArrayList<List>();
        repoLists.add(remoteRepositories);
        repoLists.add(project.getRemoteArtifactRepositories());
        ArrayList<ArtifactRepository> remoteRepos = new ArrayList<ArtifactRepository>();
        HashSet<String> encounteredUrls = new HashSet<String>();
        Iterator listIterator = repoLists.iterator();
        while (listIterator.hasNext()) {
            List repositoryList = (List)listIterator.next();
            if (repositoryList == null || repositoryList.isEmpty()) continue;
            Iterator it = repositoryList.iterator();
            while (it.hasNext()) {
                ArtifactRepository repo = (ArtifactRepository)it.next();
                if (encounteredUrls.contains(repo.getUrl())) continue;
                remoteRepos.add(repo);
                encounteredUrls.add(repo.getUrl());
            }
        }
        return remoteRepos;
    }

    private Map getManagedVersionMap(MavenProject project) throws InvalidVersionSpecificationException {
        List deps;
        DependencyManagement dependencyManagement = project.getModel().getDependencyManagement();
        HashMap<String, Artifact> map = null;
        if (dependencyManagement != null && (deps = dependencyManagement.getDependencies()) != null && deps.size() > 0) {
            map = new HashMap<String, Artifact>();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding managed dependencies for " + project.getId());
            }
            Iterator i = dependencyManagement.getDependencies().iterator();
            while (i.hasNext()) {
                Dependency d = (Dependency)i.next();
                VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                Artifact artifact = this.factory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("  " + artifact);
                }
                if (null != d.getExclusions() && !d.getExclusions().isEmpty()) {
                    ArrayList<String> exclusions = new ArrayList<String>();
                    Iterator exclItr = d.getExclusions().iterator();
                    while (exclItr.hasNext()) {
                        Exclusion e = (Exclusion)exclItr.next();
                        exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
                    }
                    ExcludesArtifactFilter eaf = new ExcludesArtifactFilter(exclusions);
                    artifact.setDependencyFilter((ArtifactFilter)eaf);
                } else {
                    artifact.setDependencyFilter(null);
                }
                map.put(d.getManagementKey(), artifact);
            }
        } else if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    public void contextualize(Context context) throws ContextException {
        PlexusContainer container = (PlexusContainer)context.get((Object)"plexus");
        for (int i = 0; i < PREFERRED_RESOLVER_HINTS.length; ++i) {
            String hint = PREFERRED_RESOLVER_HINTS[i];
            try {
                this.resolver = (ArtifactResolver)container.lookup(ArtifactResolver.ROLE, hint);
                break;
            }
            catch (ComponentLookupException e) {
                this.getLogger().debug("Cannot find ArtifactResolver with hint: " + hint, (Throwable)e);
                continue;
            }
        }
        if (this.resolver == null) {
            try {
                this.resolver = (ArtifactResolver)container.lookup(ArtifactResolver.ROLE);
            }
            catch (ComponentLookupException e) {
                this.getLogger().debug("Cannot find ArtifactResolver with no hint.", (Throwable)e);
            }
        }
        if (this.resolver == null) {
            throw new ContextException("Failed to lookup a valid ArtifactResolver implementation. Tried hints:\n" + Arrays.asList(PREFERRED_RESOLVER_HINTS));
        }
    }
}

