/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.metadata;

import org.apache.maven.mercury.repository.metadata.Metadata;
import org.apache.maven.mercury.repository.metadata.MetadataException;
import org.apache.maven.mercury.repository.metadata.MetadataOperation;
import org.apache.maven.mercury.repository.metadata.Snapshot;
import org.apache.maven.mercury.repository.metadata.SnapshotOperand;
import org.apache.maven.mercury.repository.metadata.StringOperand;
import org.apache.maven.mercury.repository.metadata.Versioning;
import org.apache.maven.mercury.util.TimeUtil;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

public class SetSnapshotOperation
implements MetadataOperation {
    private static final Language LANG = new DefaultLanguage(SetSnapshotOperation.class);
    private Snapshot snapshot;
    private String snapshotPomName;

    public SetSnapshotOperation(SnapshotOperand data) throws MetadataException {
        this.setOperand(data);
    }

    public SetSnapshotOperation(StringOperand data) throws MetadataException {
        this.setOperand(data);
    }

    public void setOperand(Object data) throws MetadataException {
        if (data != null && data instanceof SnapshotOperand) {
            this.snapshot = ((SnapshotOperand)data).getOperand();
        } else if (data != null && data instanceof StringOperand) {
            this.snapshotPomName = ((StringOperand)data).getOperand();
        } else {
            throw new MetadataException(LANG.getMessage("bad.operand", new String[]{"SnapshotOperand", data == null ? "null" : data.getClass().getName()}));
        }
    }

    public boolean perform(Metadata metadata) throws MetadataException {
        if (metadata == null) {
            return false;
        }
        Versioning vs = metadata.getVersioning();
        if (vs == null) {
            vs = new Versioning();
            metadata.setVersioning(vs);
        }
        if (this.snapshotPomName != null) {
            return this.updateSnapshot(this.snapshotPomName, metadata);
        }
        return this.updateSnapshot(this.snapshot, vs);
    }

    private boolean updateSnapshot(String snapshotVersion, Metadata metadata) {
        Snapshot snapshot = this.buildSnapshot(snapshotVersion, metadata);
        Snapshot oldSnapshot = metadata.getVersioning().getSnapshot();
        if (this.needUpdateSnapshot(oldSnapshot, snapshot)) {
            return this.updateSnapshot(snapshot, metadata.getVersioning());
        }
        return false;
    }

    private boolean updateSnapshot(Snapshot snapshot, Versioning vs) {
        vs.setSnapshot(snapshot);
        vs.setLastUpdated(TimeUtil.getUTCTimestamp());
        return true;
    }

    private boolean needUpdateSnapshot(Snapshot oldSnapshot, Snapshot newSnapshot) {
        if (newSnapshot == null) {
            return false;
        }
        if (oldSnapshot == null) {
            return true;
        }
        return oldSnapshot.getBuildNumber() < newSnapshot.getBuildNumber();
    }

    private Snapshot buildSnapshot(String pomName, Metadata md) {
        if (pomName.endsWith("SNAPSHOT.pom")) {
            return null;
        }
        Snapshot result = new Snapshot();
        int lastHyphenPos = pomName.lastIndexOf(45);
        try {
            int buildNumber = Integer.parseInt(pomName.substring(lastHyphenPos + 1, pomName.length() - 4));
            String timestamp = pomName.substring((md.getArtifactId() + '-' + md.getVersion() + '-').length() - "-SNAPSHOT".length(), lastHyphenPos);
            result.setLocalCopy(false);
            result.setBuildNumber(buildNumber);
            result.setTimestamp(timestamp);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

