/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.builder;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.project.builder.PomClassicDomainModel;
import org.apache.maven.project.builder.PomInterpolatorTag;
import org.apache.maven.project.builder.PomTransformer;
import org.apache.maven.project.builder.ProjectUri;
import org.apache.maven.shared.model.InterpolatorProperty;
import org.apache.maven.shared.model.ModelMarshaller;
import org.apache.maven.shared.model.ModelProperty;
import org.apache.maven.shared.model.ModelTransformerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpolator {
    private static final Map<String, String> aliases = new HashMap<String, String>();

    public static String interpolateXmlString(String xml, List<InterpolatorProperty> interpolatorProperties) throws IOException {
        List modelProperties = ModelMarshaller.marshallXmlToModelProperties((InputStream)new ByteArrayInputStream(xml.getBytes()), (String)ProjectUri.baseUri, (Set)PomTransformer.URIS);
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.put("project.", "pom.");
        ArrayList<InterpolatorProperty> ips = new ArrayList<InterpolatorProperty>(interpolatorProperties);
        ips.addAll(ModelTransformerContext.createInterpolatorProperties((List)modelProperties, (String)ProjectUri.baseUri, aliases, (String)PomInterpolatorTag.PROJECT_PROPERTIES.name(), (boolean)false, (boolean)false));
        for (ModelProperty mp : modelProperties) {
            if (!mp.getUri().startsWith(ProjectUri.properties) || mp.getValue() == null) continue;
            String uri = mp.getUri();
            ips.add(new InterpolatorProperty("${" + uri.substring(uri.lastIndexOf("/") + 1, uri.length()) + "}", mp.getValue()));
        }
        ModelTransformerContext.interpolateModelProperties((List)modelProperties, ips);
        return ModelMarshaller.unmarshalModelPropertiesToXml((List)modelProperties, (String)ProjectUri.baseUri);
    }

    private static String interpolateModelAsString(Model model, List<InterpolatorProperty> interpolatorProperties, File projectDirectory) throws IOException {
        PomClassicDomainModel domainModel = new PomClassicDomainModel(model);
        domainModel.setProjectDirectory(projectDirectory);
        List modelProperties = ModelMarshaller.marshallXmlToModelProperties((InputStream)domainModel.getInputStream(), (String)ProjectUri.baseUri, (Set)PomTransformer.URIS);
        Interpolator.interpolateModelProperties(modelProperties, interpolatorProperties, domainModel);
        return ModelMarshaller.unmarshalModelPropertiesToXml((List)modelProperties, (String)ProjectUri.baseUri);
    }

    public static Model interpolateModel(Model model, List<InterpolatorProperty> interpolatorProperties, File projectDirectory) throws IOException {
        String pomXml = Interpolator.interpolateModelAsString(model, interpolatorProperties, projectDirectory);
        PomClassicDomainModel domainModel = new PomClassicDomainModel(new ByteArrayInputStream(pomXml.getBytes()));
        return domainModel.getModel();
    }

    private static void addProjectAlias(String element, boolean leaf) {
        String suffix = leaf ? "\\}" : "\\.";
        aliases.put("\\$\\{project\\." + element + suffix, "\\$\\{" + element + suffix);
    }

    public static void interpolateModelProperties(List<ModelProperty> modelProperties, List<InterpolatorProperty> interpolatorProperties, PomClassicDomainModel domainModel) throws IOException {
        if (!Interpolator.containsProjectVersion(interpolatorProperties)) {
            aliases.put("\\$\\{project.version\\}", "\\$\\{version\\}");
        }
        ArrayList<ModelProperty> firstPassModelProperties = new ArrayList<ModelProperty>();
        ArrayList<Object> secondPassModelProperties = new ArrayList<Object>();
        ModelProperty buildProperty = new ModelProperty(ProjectUri.Build.xUri, null);
        for (ModelProperty mp : modelProperties) {
            if (mp.getValue() == null || mp.getUri().contains("#property") || mp.getUri().contains("#collection")) continue;
            if (!buildProperty.isParentOf(mp) && !mp.getUri().equals(ProjectUri.Reporting.outputDirectory) || mp.getUri().equals(ProjectUri.Build.finalName)) {
                firstPassModelProperties.add(mp);
                continue;
            }
            secondPassModelProperties.add(mp);
        }
        ArrayList<InterpolatorProperty> standardInterpolatorProperties = new ArrayList<InterpolatorProperty>();
        if (domainModel.isPomInBuild()) {
            String basedir = domainModel.getProjectDirectory().getAbsolutePath();
            standardInterpolatorProperties.add(new InterpolatorProperty("${project.basedir}", basedir, PomInterpolatorTag.PROJECT_PROPERTIES.name()));
            standardInterpolatorProperties.add(new InterpolatorProperty("${basedir}", basedir, PomInterpolatorTag.PROJECT_PROPERTIES.name()));
            standardInterpolatorProperties.add(new InterpolatorProperty("${pom.basedir}", basedir, PomInterpolatorTag.PROJECT_PROPERTIES.name()));
        }
        for (ModelProperty mp : modelProperties) {
            if (!mp.getUri().startsWith(ProjectUri.properties) || mp.getValue() == null) continue;
            String uri = mp.getUri();
            standardInterpolatorProperties.add(new InterpolatorProperty("${" + uri.substring(uri.lastIndexOf("/") + 1, uri.length()) + "}", mp.getValue(), PomInterpolatorTag.PROJECT_PROPERTIES.name()));
        }
        ArrayList<InterpolatorProperty> ips1 = new ArrayList<InterpolatorProperty>(interpolatorProperties);
        ips1.addAll(standardInterpolatorProperties);
        ips1.addAll(ModelTransformerContext.createInterpolatorProperties(firstPassModelProperties, (String)ProjectUri.baseUri, aliases, (String)PomInterpolatorTag.PROJECT_PROPERTIES.name(), (boolean)false, (boolean)false));
        Collections.sort(ips1, new Comparator<InterpolatorProperty>(){

            @Override
            public int compare(InterpolatorProperty o, InterpolatorProperty o1) {
                return PomInterpolatorTag.valueOf((String)o.getTag()).compareTo((Enum)PomInterpolatorTag.valueOf((String)o1.getTag()));
            }
        });
        ModelTransformerContext.interpolateModelProperties(modelProperties, ips1);
        if (domainModel.isPomInBuild()) {
            String basedir = domainModel.getProjectDirectory().getAbsolutePath();
            HashMap<ModelProperty, ModelProperty> buildDirectories = new HashMap<ModelProperty, ModelProperty>();
            for (ModelProperty modelProperty : secondPassModelProperties) {
                File file;
                if (!modelProperty.getUri().startsWith(ProjectUri.Build.xUri) && !modelProperty.getUri().equals(ProjectUri.Reporting.outputDirectory) || (file = new File(modelProperty.getResolvedValue())).isAbsolute() || modelProperty.getResolvedValue().startsWith("${project.build.") || modelProperty.getResolvedValue().equals("${project.basedir}")) continue;
                buildDirectories.put(modelProperty, new ModelProperty(modelProperty.getUri(), new File(basedir, file.getPath()).getAbsolutePath()));
            }
            for (Map.Entry entry : buildDirectories.entrySet()) {
                secondPassModelProperties.remove(entry.getKey());
                secondPassModelProperties.add(entry.getValue());
            }
        }
        ArrayList<InterpolatorProperty> ips2 = new ArrayList<InterpolatorProperty>(interpolatorProperties);
        ips2.addAll(standardInterpolatorProperties);
        ips2.addAll(ModelTransformerContext.createInterpolatorProperties(secondPassModelProperties, (String)ProjectUri.baseUri, aliases, (String)PomInterpolatorTag.PROJECT_PROPERTIES.name(), (boolean)false, (boolean)false));
        ips2.addAll(interpolatorProperties);
        Collections.sort(ips2, new Comparator<InterpolatorProperty>(){

            @Override
            public int compare(InterpolatorProperty o, InterpolatorProperty o1) {
                return PomInterpolatorTag.valueOf((String)o.getTag()).compareTo((Enum)PomInterpolatorTag.valueOf((String)o1.getTag()));
            }
        });
        ModelTransformerContext.interpolateModelProperties(modelProperties, ips2);
    }

    private static boolean containsProjectVersion(List<InterpolatorProperty> interpolatorProperties) {
        InterpolatorProperty versionInterpolatorProperty = new ModelProperty(ProjectUri.version, "").asInterpolatorProperty(ProjectUri.baseUri);
        for (InterpolatorProperty ip : interpolatorProperties) {
            if (!ip.equals((Object)versionInterpolatorProperty)) continue;
            return true;
        }
        return false;
    }

    static {
        aliases.put("\\$\\{project\\.", "\\$\\{pom\\.");
        Interpolator.addProjectAlias("modelVersion", true);
        Interpolator.addProjectAlias("groupId", true);
        Interpolator.addProjectAlias("artifactId", true);
        Interpolator.addProjectAlias("version", true);
        Interpolator.addProjectAlias("packaging", true);
        Interpolator.addProjectAlias("name", true);
        Interpolator.addProjectAlias("description", true);
        Interpolator.addProjectAlias("inceptionYear", true);
        Interpolator.addProjectAlias("url", true);
        Interpolator.addProjectAlias("parent", false);
        Interpolator.addProjectAlias("prerequisites", false);
        Interpolator.addProjectAlias("organization", false);
        Interpolator.addProjectAlias("build", false);
        Interpolator.addProjectAlias("reporting", false);
        Interpolator.addProjectAlias("scm", false);
        Interpolator.addProjectAlias("distributionManagement", false);
        Interpolator.addProjectAlias("issueManagement", false);
        Interpolator.addProjectAlias("ciManagement", false);
    }
}

