package org.apache.maven.plugin;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Base exception.
 *
 * @author <a href="mailto:brett@apache.org">Brett Porter</a>
 * @version $Id: AbstractMojoExecutionException.java 291632 2005-09-26 14:40:17Z brett $
 */
public abstract class AbstractMojoExecutionException
    extends Exception
{
    protected Object source;

    protected String longMessage;

    public AbstractMojoExecutionException( String message )
    {
        super( message );
    }

    public AbstractMojoExecutionException( String message, Throwable cause )
    {
        super( message, cause );
    }

    public String getLongMessage()
    {
        return longMessage;
    }

    public Object getSource()
    {
        return source;
    }
}
