/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.hash;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.maven.buildcache.hash.ReflectionUtils;

public class CloseableBuffer
implements AutoCloseable {
    private static final Cleaner CLEANER = AccessController.doPrivileged(new PrivilegedAction<Cleaner>(){

        @Override
        public Cleaner run() {
            String jsv = System.getProperty("java.specification.version", "9");
            if (jsv.startsWith("1.")) {
                return DirectCleaner.isSupported() ? new DirectCleaner() : new NoopCleaner();
            }
            return UnsafeCleaner.isSupported() ? new UnsafeCleaner() : new NoopCleaner();
        }
    });
    private ByteBuffer buffer;

    public static CloseableBuffer directBuffer(int capacity) {
        return new CloseableBuffer(ByteBuffer.allocateDirect(capacity));
    }

    public static CloseableBuffer mappedBuffer(FileChannel channel, FileChannel.MapMode mode) throws IOException {
        return new CloseableBuffer(channel.map(mode, 0L, channel.size()));
    }

    private CloseableBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void close() {
        boolean done = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return CLEANER.clean(CloseableBuffer.this.buffer);
            }
        });
        if (done) {
            this.buffer = null;
        }
    }

    private static class UnsafeCleaner
    implements Cleaner {
        private static final Method INVOKE_CLEANER = ReflectionUtils.getMethod("sun.misc.Unsafe", "invokeCleaner", ByteBuffer.class);
        private static final Object UNSAFE = ReflectionUtils.getField("sun.misc.Unsafe", "theUnsafe");

        private UnsafeCleaner() {
        }

        public static boolean isSupported() {
            return UNSAFE != null && INVOKE_CLEANER != null;
        }

        @Override
        public boolean clean(ByteBuffer buffer) {
            try {
                INVOKE_CLEANER.invoke(UNSAFE, buffer);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class DirectCleaner
    implements Cleaner {
        private static final Method ATTACHMENT = ReflectionUtils.getMethod("sun.nio.ch.DirectBuffer", "attachment", new Class[0]);
        private static final Method CLEANER = ReflectionUtils.getMethod("sun.nio.ch.DirectBuffer", "cleaner", new Class[0]);
        private static final Method CLEAN = ReflectionUtils.getMethod("sun.misc.Cleaner", "clean", new Class[0]);

        private DirectCleaner() {
        }

        public static boolean isSupported() {
            return ATTACHMENT != null && CLEAN != null && CLEANER != null;
        }

        @Override
        public boolean clean(ByteBuffer buffer) {
            try {
                if (ATTACHMENT.invoke((Object)buffer, new Object[0]) == null) {
                    CLEAN.invoke(CLEANER.invoke((Object)buffer, new Object[0]), new Object[0]);
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    private static class NoopCleaner
    implements Cleaner {
        private NoopCleaner() {
        }

        @Override
        public boolean clean(ByteBuffer buffer) {
            return false;
        }
    }

    private static interface Cleaner {
        public boolean clean(ByteBuffer var1);
    }
}

