/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.maven.doxia.sink.SinkUtils;
import org.codehaus.plexus.util.ReaderFactory;

public class FoConfiguration {
    private MutableAttributeSet attributeSet;
    private final XMLConfiguration config = new XMLConfiguration();
    private List<?> sets;

    public FoConfiguration() {
        this.config.setDelimiterParsingDisabled(true);
        this.loadDefaultConfig();
    }

    public void load(File configFile) throws IOException {
        this.config.clear();
        try {
            this.config.load(configFile);
        }
        catch (ConfigurationException cex) {
            IOException ioe = new IOException();
            ioe.initCause(cex);
            throw ioe;
        }
        this.loadDefaultConfig();
    }

    public String getAttributeString(String attributeId) {
        if (attributeId == null) {
            return "";
        }
        this.reset();
        this.addAttributes(attributeId);
        return SinkUtils.getAttributeString((AttributeSet)this.attributeSet);
    }

    public MutableAttributeSet getAttributeSet(String attributeId) {
        if (attributeId == null || attributeId.length() == 0) {
            return null;
        }
        this.reset();
        this.addAttributes(attributeId);
        if (this.attributeSet.getAttributeCount() == 0) {
            return null;
        }
        return this.attributeSet;
    }

    private void addAttributes(String attributeId) {
        String extend;
        int index = this.sets.indexOf(attributeId);
        String keybase = "xsl:attribute-set(" + String.valueOf(index) + ")";
        Object prop = this.config.getProperty(keybase + ".xsl:attribute");
        if (prop instanceof List) {
            List values = (List)prop;
            List keys = this.config.getList(keybase + ".xsl:attribute[@name]");
            for (int i = 0; i < values.size(); ++i) {
                this.attributeSet.addAttribute(keys.get(i), values.get(i));
            }
        } else if (prop instanceof String) {
            String value = this.config.getString(keybase + ".xsl:attribute");
            String key = this.config.getString(keybase + ".xsl:attribute[@name]");
            this.attributeSet.addAttribute(key, value);
        }
        if ((extend = this.config.getString(keybase + "[@use-attribute-sets]")) != null) {
            this.addAttributes(extend);
        }
    }

    private void loadDefaultConfig() {
        try {
            this.config.load((Reader)ReaderFactory.newXmlReader((InputStream)this.getClass().getResourceAsStream("/fo-styles.xslt")));
        }
        catch (ConfigurationException cex) {
            throw new RuntimeException(cex);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.sets = this.config.getList("xsl:attribute-set[@name]");
        this.reset();
    }

    private void reset() {
        this.attributeSet = new SimpleAttributeSet();
    }
}

