/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.CharDoubleProcedure;
import org.apache.mahout.math.function.CharProcedure;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractCharDoubleMap
extends AbstractSet {
    public boolean containsKey(final char key) {
        return !this.forEachKey(new CharProcedure(){

            public boolean apply(char iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final double value) {
        return !this.forEachPair(new CharDoubleProcedure(){

            public boolean apply(char iterKey, double iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractCharDoubleMap copy() {
        return (AbstractCharDoubleMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractCharDoubleMap)) {
            return false;
        }
        final AbstractCharDoubleMap other = (AbstractCharDoubleMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new CharDoubleProcedure(){

            public boolean apply(char key, double value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new CharDoubleProcedure(){

            public boolean apply(char key, double value) {
                return AbstractCharDoubleMap.this.containsKey(key) && AbstractCharDoubleMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(CharProcedure var1);

    public boolean forEachPair(final CharDoubleProcedure procedure) {
        return this.forEachKey(new CharProcedure(){

            public boolean apply(char key) {
                return procedure.apply(key, AbstractCharDoubleMap.this.get(key));
            }
        });
    }

    public abstract double get(char var1);

    public CharArrayList keys() {
        CharArrayList list = new CharArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final CharArrayList list) {
        list.clear();
        this.forEachKey(new CharProcedure(){

            public boolean apply(char key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(CharArrayList keyList) {
        this.pairsSortedByValue(keyList, new DoubleArrayList(this.size()));
    }

    public void pairsMatching(final CharDoubleProcedure condition, final CharArrayList keyList, final DoubleArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new CharDoubleProcedure(){

            public boolean apply(char key, double value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(CharArrayList keyList, DoubleArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(CharArrayList keyList, DoubleArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final char[] k = keyList.elements();
        final double[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                double t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                char t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(char var1, double var2);

    public abstract boolean removeKey(char var1);

    public String toString() {
        CharArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            char key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        CharArrayList theKeys = new CharArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            char key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public DoubleArrayList values() {
        DoubleArrayList list = new DoubleArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final DoubleArrayList list) {
        list.clear();
        this.forEachKey(new CharProcedure(){

            public boolean apply(char key) {
                list.add(AbstractCharDoubleMap.this.get(key));
                return true;
            }
        });
    }

    public void assign(final DoubleFunction function) {
        this.copy().forEachPair(new CharDoubleProcedure(){

            public boolean apply(char key, double value) {
                AbstractCharDoubleMap.this.put(key, function.apply(value));
                return true;
            }
        });
    }

    public void assign(AbstractCharDoubleMap other) {
        this.clear();
        other.forEachPair(new CharDoubleProcedure(){

            public boolean apply(char key, double value) {
                AbstractCharDoubleMap.this.put(key, value);
                return true;
            }
        });
    }

    public double adjustOrPutValue(char key, double newValue, double incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = this.get(key) + incrValue;
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

