/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PorterStemFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.cn.smart.SentenceTokenizer;
import org.apache.lucene.analysis.cn.smart.WordTokenFilter;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SmartChineseAnalyzer
extends Analyzer {
    private final Set<?> stopWords;
    private static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORD_FILE_COMMENT = "//";
    private final Version matchVersion;

    public static Set<String> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public SmartChineseAnalyzer(Version matchVersion) {
        this(matchVersion, true);
    }

    public SmartChineseAnalyzer(Version matchVersion, boolean useDefaultStopWords) {
        this.stopWords = useDefaultStopWords ? DefaultSetHolder.DEFAULT_STOP_SET : Collections.EMPTY_SET;
        this.matchVersion = matchVersion;
    }

    public SmartChineseAnalyzer(Version matchVersion, Set stopWords) {
        this.stopWords = stopWords == null ? Collections.EMPTY_SET : stopWords;
        this.matchVersion = matchVersion;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new SentenceTokenizer(reader);
        result = new WordTokenFilter((TokenStream)result);
        result = new PorterStemFilter((TokenStream)result);
        if (!this.stopWords.isEmpty()) {
            result = new StopFilter(this.matchVersion, (TokenStream)result, this.stopWords, false);
        }
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            this.setPreviousTokenStream(streams);
            streams.tokenStream = new SentenceTokenizer(reader);
            streams.filteredTokenStream = new WordTokenFilter((TokenStream)streams.tokenStream);
            streams.filteredTokenStream = new PorterStemFilter(streams.filteredTokenStream);
            if (!this.stopWords.isEmpty()) {
                streams.filteredTokenStream = new StopFilter(this.matchVersion, streams.filteredTokenStream, this.stopWords, false);
            }
        } else {
            streams.tokenStream.reset(reader);
            streams.filteredTokenStream.reset();
        }
        return streams.filteredTokenStream;
    }

    private static final class SavedStreams {
        Tokenizer tokenStream;
        TokenStream filteredTokenStream;

        private SavedStreams() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultSetHolder {
        static final Set<String> DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Set<String> loadDefaultStopWordSet() throws IOException {
            InputStream stream = SmartChineseAnalyzer.class.getResourceAsStream(SmartChineseAnalyzer.DEFAULT_STOPWORD_FILE);
            try {
                InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
                Set<String> set = Collections.unmodifiableSet(WordlistLoader.getWordSet((Reader)reader, (String)SmartChineseAnalyzer.STOPWORD_FILE_COMMENT));
                return set;
            }
            finally {
                stream.close();
            }
        }

        static {
            try {
                DEFAULT_STOP_SET = DefaultSetHolder.loadDefaultStopWordSet();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

