/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperStub;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMetricsRegionServer {
    public static MetricsAssertHelper HELPER = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    private MetricsRegionServerWrapperStub wrapper;
    private MetricsRegionServer rsm;
    private MetricsRegionServerSource serverSource;

    @BeforeClass
    public static void classSetUp() {
        HELPER.init();
    }

    @Before
    public void setUp() {
        this.wrapper = new MetricsRegionServerWrapperStub();
        this.rsm = new MetricsRegionServer((MetricsRegionServerWrapper)this.wrapper);
        this.serverSource = this.rsm.getMetricsSource();
    }

    @Test
    public void testWrapperSource() {
        HELPER.assertTag("serverName", "test", (BaseSource)this.serverSource);
        HELPER.assertTag("clusterId", "tClusterId", (BaseSource)this.serverSource);
        HELPER.assertTag("zookeeperQuorum", "zk", (BaseSource)this.serverSource);
        HELPER.assertGauge("regionServerStartTime", 100L, (BaseSource)this.serverSource);
        HELPER.assertGauge("regionCount", 101L, (BaseSource)this.serverSource);
        HELPER.assertGauge("storeCount", 2L, (BaseSource)this.serverSource);
        HELPER.assertGauge("hlogFileCount", 10L, (BaseSource)this.serverSource);
        HELPER.assertGauge("hlogFileSize", 1024000L, (BaseSource)this.serverSource);
        HELPER.assertGauge("storeFileCount", 300L, (BaseSource)this.serverSource);
        HELPER.assertGauge("memstoreSize", 1025L, (BaseSource)this.serverSource);
        HELPER.assertGauge("storeFileSize", 1900L, (BaseSource)this.serverSource);
        HELPER.assertCounter("totalRequestCount", 899L, (BaseSource)this.serverSource);
        HELPER.assertCounter("readRequestCount", 997L, (BaseSource)this.serverSource);
        HELPER.assertCounter("writeRequestCount", 707L, (BaseSource)this.serverSource);
        HELPER.assertCounter("checkMutateFailedCount", 401L, (BaseSource)this.serverSource);
        HELPER.assertCounter("checkMutatePassedCount", 405L, (BaseSource)this.serverSource);
        HELPER.assertGauge("storeFileIndexSize", 406L, (BaseSource)this.serverSource);
        HELPER.assertGauge("staticIndexSize", 407L, (BaseSource)this.serverSource);
        HELPER.assertGauge("staticBloomSize", 408L, (BaseSource)this.serverSource);
        HELPER.assertGauge("mutationsWithoutWALCount", 409L, (BaseSource)this.serverSource);
        HELPER.assertGauge("mutationsWithoutWALSize", 410L, (BaseSource)this.serverSource);
        HELPER.assertGauge("percentFilesLocal", 99L, (BaseSource)this.serverSource);
        HELPER.assertGauge("compactionQueueLength", 411L, (BaseSource)this.serverSource);
        HELPER.assertGauge("flushQueueLength", 412L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCacheFreeSize", 413L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCacheCount", 414L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCacheSize", 415L, (BaseSource)this.serverSource);
        HELPER.assertCounter("blockCacheHitCount", 416L, (BaseSource)this.serverSource);
        HELPER.assertCounter("blockCacheMissCount", 417L, (BaseSource)this.serverSource);
        HELPER.assertCounter("blockCacheEvictionCount", 418L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCountHitPercent", 98L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCacheExpressHitPercent", 97L, (BaseSource)this.serverSource);
        HELPER.assertCounter("updatesBlockedTime", 419L, (BaseSource)this.serverSource);
    }

    @Test
    public void testConstuctor() {
        Assert.assertNotNull((String)"There should be a hadoop1/hadoop2 metrics source", (Object)this.rsm.getMetricsSource());
        Assert.assertNotNull((String)"The RegionServerMetricsWrapper should be accessable", (Object)this.rsm.getRegionServerWrapper());
    }

    @Test
    public void testSlowCount() {
        int i;
        for (i = 0; i < 12; ++i) {
            this.rsm.updateAppend(12L);
            this.rsm.updateAppend(1002L);
        }
        for (i = 0; i < 13; ++i) {
            this.rsm.updateDelete(13L);
            this.rsm.updateDelete(1003L);
        }
        for (i = 0; i < 14; ++i) {
            this.rsm.updateGet(14L);
            this.rsm.updateGet(1004L);
        }
        for (i = 0; i < 15; ++i) {
            this.rsm.updateIncrement(15L);
            this.rsm.updateIncrement(1005L);
        }
        for (i = 0; i < 16; ++i) {
            this.rsm.updatePut(16L);
            this.rsm.updatePut(1006L);
        }
        HELPER.assertCounter("appendNumOps", 24L, (BaseSource)this.serverSource);
        HELPER.assertCounter("deleteNumOps", 26L, (BaseSource)this.serverSource);
        HELPER.assertCounter("getNumOps", 28L, (BaseSource)this.serverSource);
        HELPER.assertCounter("incrementNumOps", 30L, (BaseSource)this.serverSource);
        HELPER.assertCounter("mutateNumOps", 32L, (BaseSource)this.serverSource);
        HELPER.assertCounter("slowAppendCount", 12L, (BaseSource)this.serverSource);
        HELPER.assertCounter("slowDeleteCount", 13L, (BaseSource)this.serverSource);
        HELPER.assertCounter("slowGetCount", 14L, (BaseSource)this.serverSource);
        HELPER.assertCounter("slowIncrementCount", 15L, (BaseSource)this.serverSource);
        HELPER.assertCounter("slowPutCount", 16L, (BaseSource)this.serverSource);
    }
}

