/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.Export;
import org.apache.hadoop.hbase.mapreduce.Import;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.GenericOptionsParser;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={MediumTests.class})
public class TestImportExport {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] ROW1 = Bytes.toBytes((String)"row1");
    private static final byte[] ROW2 = Bytes.toBytes((String)"row2");
    private static final String FAMILYA_STRING = "a";
    private static final String FAMILYB_STRING = "b";
    private static final byte[] FAMILYA = Bytes.toBytes((String)"a");
    private static final byte[] FAMILYB = Bytes.toBytes((String)"b");
    private static final byte[] QUAL = Bytes.toBytes((String)"q");
    private static final String OUTPUT_DIR = "outputdir";
    private static String FQ_OUTPUT_DIR;
    private static final String EXPORT_BATCH_SIZE = "100";
    private static long now;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster();
        UTIL.startMiniMapReduceCluster();
        FQ_OUTPUT_DIR = new Path(OUTPUT_DIR).makeQualified(FileSystem.get((Configuration)UTIL.getConfiguration())).toString();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniMapReduceCluster();
        UTIL.shutdownMiniCluster();
    }

    @Before
    @After
    public void cleanup() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        fs.delete(new Path(OUTPUT_DIR), true);
    }

    boolean runExport(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        GenericOptionsParser opts = new GenericOptionsParser(new Configuration(UTIL.getConfiguration()), args);
        Configuration conf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        Job job = Export.createSubmittableJob((Configuration)conf, (String[])args);
        job.waitForCompletion(false);
        return job.isSuccessful();
    }

    boolean runImport(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        GenericOptionsParser opts = new GenericOptionsParser(new Configuration(UTIL.getConfiguration()), args);
        Configuration conf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        Job job = Import.createSubmittableJob((Configuration)conf, (String[])args);
        job.waitForCompletion(false);
        return job.isSuccessful();
    }

    @Test
    public void testSimpleCase() throws Exception {
        String EXPORT_TABLE = "exportSimpleCase";
        HTable t = UTIL.createTable(Bytes.toBytes((String)EXPORT_TABLE), FAMILYA, 3);
        Put p = new Put(ROW1);
        p.add(FAMILYA, QUAL, now, QUAL);
        p.add(FAMILYA, QUAL, now + 1L, QUAL);
        p.add(FAMILYA, QUAL, now + 2L, QUAL);
        t.put(p);
        p = new Put(ROW2);
        p.add(FAMILYA, QUAL, now, QUAL);
        p.add(FAMILYA, QUAL, now + 1L, QUAL);
        p.add(FAMILYA, QUAL, now + 2L, QUAL);
        t.put(p);
        String[] args = new String[]{EXPORT_TABLE, FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runExport(args));
        String IMPORT_TABLE = "importTableSimpleCase";
        t = UTIL.createTable(Bytes.toBytes((String)IMPORT_TABLE), FAMILYB, 3);
        args = new String[]{"-DHBASE_IMPORTER_RENAME_CFS=a:b", IMPORT_TABLE, FQ_OUTPUT_DIR};
        Assert.assertTrue((boolean)this.runImport(args));
        Get g = new Get(ROW1);
        g.setMaxVersions();
        Result r = t.get(g);
        Assert.assertEquals((long)3L, (long)r.size());
        g = new Get(ROW2);
        g.setMaxVersions();
        r = t.get(g);
        Assert.assertEquals((long)3L, (long)r.size());
    }

    @Test
    public void testMetaExport() throws Exception {
        String EXPORT_TABLE = TableName.META_TABLE_NAME.getNameAsString();
        String[] args = new String[]{EXPORT_TABLE, FQ_OUTPUT_DIR, "1", "0", "0"};
        Assert.assertTrue((boolean)this.runExport(args));
    }

    @Test
    public void testImport94Table() throws Exception {
        URL url = TestImportExport.class.getResource("exportedTableIn94Format");
        Path importPath = new Path(url.getPath());
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        fs.copyFromLocalFile(importPath, new Path(FQ_OUTPUT_DIR + "/" + "exportedTableIn94Format"));
        String IMPORT_TABLE = "importTableExportedFrom94";
        HTable t = UTIL.createTable(Bytes.toBytes((String)IMPORT_TABLE), Bytes.toBytes((String)"f1"), 3);
        String[] args = new String[]{"-Dhbase.import.version=0.94", IMPORT_TABLE, FQ_OUTPUT_DIR};
        Assert.assertTrue((boolean)this.runImport(args));
        Assert.assertEquals((long)5L, (long)UTIL.countRows(t));
        t.close();
    }

    @Test
    public void testExportScannerBatching() throws Exception {
        String BATCH_TABLE = "exportWithBatch";
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)BATCH_TABLE));
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(1));
        UTIL.getHBaseAdmin().createTable(desc);
        HTable t = new HTable(UTIL.getConfiguration(), BATCH_TABLE);
        Put p = new Put(ROW1);
        p.add(FAMILYA, QUAL, now, QUAL);
        p.add(FAMILYA, QUAL, now + 1L, QUAL);
        p.add(FAMILYA, QUAL, now + 2L, QUAL);
        p.add(FAMILYA, QUAL, now + 3L, QUAL);
        p.add(FAMILYA, QUAL, now + 4L, QUAL);
        t.put(p);
        String[] args = new String[]{"-Dhbase.export.scanner.batch=100", BATCH_TABLE, FQ_OUTPUT_DIR};
        Assert.assertTrue((boolean)this.runExport(args));
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        fs.delete(new Path(FQ_OUTPUT_DIR), true);
        t.close();
    }

    @Test
    public void testWithDeletes() throws Exception {
        String EXPORT_TABLE = "exportWithDeletes";
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)EXPORT_TABLE));
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5).setKeepDeletedCells(true));
        UTIL.getHBaseAdmin().createTable(desc);
        HTable t = new HTable(UTIL.getConfiguration(), EXPORT_TABLE);
        Put p = new Put(ROW1);
        p.add(FAMILYA, QUAL, now, QUAL);
        p.add(FAMILYA, QUAL, now + 1L, QUAL);
        p.add(FAMILYA, QUAL, now + 2L, QUAL);
        p.add(FAMILYA, QUAL, now + 3L, QUAL);
        p.add(FAMILYA, QUAL, now + 4L, QUAL);
        t.put(p);
        Delete d = new Delete(ROW1, now + 3L);
        t.delete(d);
        d = new Delete(ROW1);
        d.deleteColumns(FAMILYA, QUAL, now + 2L);
        t.delete(d);
        String[] args = new String[]{"-Dhbase.mapreduce.include.deleted.rows=true", EXPORT_TABLE, FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runExport(args));
        String IMPORT_TABLE = "importWithDeletes";
        desc = new HTableDescriptor(TableName.valueOf((String)IMPORT_TABLE));
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5).setKeepDeletedCells(true));
        UTIL.getHBaseAdmin().createTable(desc);
        t.close();
        t = new HTable(UTIL.getConfiguration(), IMPORT_TABLE);
        args = new String[]{IMPORT_TABLE, FQ_OUTPUT_DIR};
        Assert.assertTrue((boolean)this.runImport(args));
        Scan s = new Scan();
        s.setMaxVersions();
        s.setRaw(true);
        ResultScanner scanner = t.getScanner(s);
        Result r = scanner.next();
        Cell[] res = r.rawCells();
        Assert.assertTrue((boolean)CellUtil.isDeleteFamily((Cell)res[0]));
        Assert.assertEquals((long)(now + 4L), (long)res[1].getTimestamp());
        Assert.assertEquals((long)(now + 3L), (long)res[2].getTimestamp());
        Assert.assertTrue((boolean)CellUtil.isDelete((Cell)res[3]));
        Assert.assertEquals((long)(now + 2L), (long)res[4].getTimestamp());
        Assert.assertEquals((long)(now + 1L), (long)res[5].getTimestamp());
        Assert.assertEquals((long)now, (long)res[6].getTimestamp());
        t.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithMultipleDeleteFamilyMarkersOfSameRowSameFamily() throws Exception {
        String EXPORT_TABLE = "exportWithMultipleDeleteFamilyMarkersOfSameRowSameFamily";
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)EXPORT_TABLE));
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5).setKeepDeletedCells(true));
        UTIL.getHBaseAdmin().createTable(desc);
        HTable exportT = new HTable(UTIL.getConfiguration(), EXPORT_TABLE);
        Put p = new Put(ROW1);
        p.add(FAMILYA, QUAL, now, QUAL);
        exportT.put(p);
        Delete d = new Delete(ROW1, now + 3L);
        exportT.delete(d);
        p = new Put(ROW1);
        p.add(FAMILYA, QUAL, now + 5L, "s".getBytes());
        exportT.put(p);
        d = new Delete(ROW1, now + 7L);
        exportT.delete(d);
        String[] args = new String[]{"-Dhbase.mapreduce.include.deleted.rows=true", EXPORT_TABLE, FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runExport(args));
        String IMPORT_TABLE = "importWithMultipleDeleteFamilyMarkersOfSameRowSameFamily";
        desc = new HTableDescriptor(TableName.valueOf((String)IMPORT_TABLE));
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5).setKeepDeletedCells(true));
        UTIL.getHBaseAdmin().createTable(desc);
        HTable importT = new HTable(UTIL.getConfiguration(), IMPORT_TABLE);
        args = new String[]{IMPORT_TABLE, FQ_OUTPUT_DIR};
        Assert.assertTrue((boolean)this.runImport(args));
        Scan s = new Scan();
        s.setMaxVersions();
        s.setRaw(true);
        ResultScanner importedTScanner = importT.getScanner(s);
        Result importedTResult = importedTScanner.next();
        ResultScanner exportedTScanner = exportT.getScanner(s);
        Result exportedTResult = exportedTScanner.next();
        try {
            Result.compareResults((Result)exportedTResult, (Result)importedTResult);
        }
        catch (Exception e) {
            Assert.fail((String)("Original and imported tables data comparision failed with error:" + e.getMessage()));
        }
        finally {
            exportT.close();
            importT.close();
        }
    }

    @Test
    public void testWithFilter() throws Exception {
        String EXPORT_TABLE = "exportSimpleCase_ImportWithFilter";
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)EXPORT_TABLE));
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5));
        UTIL.getHBaseAdmin().createTable(desc);
        HTable exportTable = new HTable(UTIL.getConfiguration(), EXPORT_TABLE);
        Put p = new Put(ROW1);
        p.add(FAMILYA, QUAL, now, QUAL);
        p.add(FAMILYA, QUAL, now + 1L, QUAL);
        p.add(FAMILYA, QUAL, now + 2L, QUAL);
        p.add(FAMILYA, QUAL, now + 3L, QUAL);
        p.add(FAMILYA, QUAL, now + 4L, QUAL);
        exportTable.put(p);
        p = new Put(ROW2);
        p.add(FAMILYA, QUAL, now, QUAL);
        exportTable.put(p);
        exportTable.flushCommits();
        String[] args = new String[]{EXPORT_TABLE, FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runExport(args));
        String IMPORT_TABLE = "importWithFilter";
        desc = new HTableDescriptor(TableName.valueOf((String)IMPORT_TABLE));
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5));
        UTIL.getHBaseAdmin().createTable(desc);
        HTable importTable = new HTable(UTIL.getConfiguration(), IMPORT_TABLE);
        args = new String[]{"-Dimport.filter.class=" + PrefixFilter.class.getName(), "-Dimport.filter.args=" + Bytes.toString((byte[])ROW1), IMPORT_TABLE, FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runImport(args));
        PrefixFilter filter = new PrefixFilter(ROW1);
        int count = this.getCount(exportTable, (Filter)filter);
        Assert.assertEquals((String)"Unexpected row count between export and import tables", (long)count, (long)this.getCount(importTable, null));
        args = new String[]{"-Dimport.filter.class=" + Filter.class.getName(), "-Dimport.filter.args=" + Bytes.toString((byte[])ROW1) + "", EXPORT_TABLE, FQ_OUTPUT_DIR, "1000"};
        Assert.assertFalse((boolean)this.runImport(args));
        exportTable.close();
        importTable.close();
    }

    private int getCount(HTable table, Filter filter) throws IOException {
        Scan scan = new Scan();
        scan.setFilter(filter);
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            count += res.size();
        }
        results.close();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportMain() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager(newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            Import.main((String[])args);
            Assert.fail((String)"should be SecurityException");
        }
        catch (SecurityException e) {
            Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
            Assert.assertTrue((boolean)data.toString().contains("Wrong number of arguments:"));
            Assert.assertTrue((boolean)data.toString().contains("-Dimport.bulk.output=/path/for/output"));
            Assert.assertTrue((boolean)data.toString().contains("-Dimport.filter.class=<name of filter class>"));
            Assert.assertTrue((boolean)data.toString().contains("-Dimport.bulk.output=/path/for/output"));
            Assert.assertTrue((boolean)data.toString().contains("-Dmapred.reduce.tasks.speculative.execution=false"));
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportMain() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager(newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            Export.main((String[])args);
            Assert.fail((String)"should be SecurityException");
        }
        catch (SecurityException e) {
            Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
            Assert.assertTrue((boolean)data.toString().contains("Wrong number of arguments:"));
            Assert.assertTrue((boolean)data.toString().contains("Usage: Export [-D <property=value>]* <tablename> <outputdir> [<versions> [<starttime> [<endtime>]] [^[regex pattern] or [Prefix] to filter]]"));
            Assert.assertTrue((boolean)data.toString().contains("-D hbase.mapreduce.scan.column.family=<familyName>"));
            Assert.assertTrue((boolean)data.toString().contains("-D hbase.mapreduce.include.deleted.rows=true"));
            Assert.assertTrue((boolean)data.toString().contains("-Dhbase.client.scanner.caching=100"));
            Assert.assertTrue((boolean)data.toString().contains("-Dmapred.map.tasks.speculative.execution=false"));
            Assert.assertTrue((boolean)data.toString().contains("-Dmapred.reduce.tasks.speculative.execution=false"));
            Assert.assertTrue((boolean)data.toString().contains("-Dhbase.export.scanner.batch=10"));
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }

    @Test
    public void testKeyValueImporter() throws Exception {
        Import.KeyValueImporter importer = new Import.KeyValueImporter();
        Configuration configuration = new Configuration();
        Mapper.Context ctx = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        Mockito.when((Object)ctx.getConfiguration()).thenReturn((Object)configuration);
        ((Mapper.Context)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ImmutableBytesWritable writer = (ImmutableBytesWritable)invocation.getArguments()[0];
                KeyValue key = (KeyValue)invocation.getArguments()[1];
                Assert.assertEquals((Object)"Key", (Object)Bytes.toString((byte[])writer.get()));
                Assert.assertEquals((Object)"row", (Object)Bytes.toString((byte[])key.getRow()));
                return null;
            }
        }).when((Object)ctx)).write(Matchers.any(ImmutableBytesWritable.class), Matchers.any(KeyValue.class));
        importer.setup(ctx);
        Result value = (Result)Mockito.mock(Result.class);
        KeyValue[] keys = new KeyValue[]{new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), Bytes.toBytes((String)"value")), new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), Bytes.toBytes((String)"value1"))};
        Mockito.when((Object)value.rawCells()).thenReturn((Object)keys);
        importer.map(new ImmutableBytesWritable(Bytes.toBytes((String)"Key")), value, ctx);
    }

    @Test
    public void testAddFilterAndArguments() throws IOException {
        Configuration configuration = new Configuration();
        ArrayList<String> args = new ArrayList<String>();
        args.add("param1");
        args.add("param2");
        Import.addFilterAndArguments((Configuration)configuration, FilterBase.class, args);
        Assert.assertEquals((Object)"org.apache.hadoop.hbase.filter.FilterBase", (Object)configuration.get("import.filter.class"));
        Assert.assertEquals((Object)"param1,param2", (Object)configuration.get("import.filter.args"));
    }

    @Test
    public void testDurability() throws IOException, InterruptedException, ClassNotFoundException {
        String exportTableName = "exporttestDurability";
        HTable exportTable = UTIL.createTable(Bytes.toBytes((String)exportTableName), FAMILYA, 3);
        Put put = new Put(ROW1);
        put.add(FAMILYA, QUAL, now, QUAL);
        put.add(FAMILYA, QUAL, now + 1L, QUAL);
        put.add(FAMILYA, QUAL, now + 2L, QUAL);
        exportTable.put(put);
        put = new Put(ROW2);
        put.add(FAMILYA, QUAL, now, QUAL);
        put.add(FAMILYA, QUAL, now + 1L, QUAL);
        put.add(FAMILYA, QUAL, now + 2L, QUAL);
        exportTable.put(put);
        String[] args = new String[]{exportTableName, FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runExport(args));
        String importTableName = "importTestDurability1";
        HTable importTable = UTIL.createTable(Bytes.toBytes((String)importTableName), FAMILYA, 3);
        TableWALActionListener walListener = new TableWALActionListener(importTableName);
        HLog hLog = UTIL.getMiniHBaseCluster().getRegionServer(0).getWAL();
        hLog.registerWALActionsListener((WALActionsListener)walListener);
        args = new String[]{"-Dimport.wal.durability=" + Durability.SKIP_WAL.name(), importTableName, FQ_OUTPUT_DIR};
        Assert.assertTrue((boolean)this.runImport(args));
        Assert.assertTrue((!walListener.isWALVisited() ? 1 : 0) != 0);
        Assert.assertTrue((this.getCount(importTable, null) == 2 ? 1 : 0) != 0);
        importTableName = "importTestDurability2";
        importTable = UTIL.createTable(Bytes.toBytes((String)importTableName), FAMILYA, 3);
        hLog.unregisterWALActionsListener((WALActionsListener)walListener);
        walListener = new TableWALActionListener(importTableName);
        hLog.registerWALActionsListener((WALActionsListener)walListener);
        args = new String[]{importTableName, FQ_OUTPUT_DIR};
        Assert.assertTrue((boolean)this.runImport(args));
        Assert.assertTrue((boolean)walListener.isWALVisited());
        Assert.assertTrue((this.getCount(importTable, null) == 2 ? 1 : 0) != 0);
    }

    static {
        now = System.currentTimeMillis();
    }

    private static class TableWALActionListener
    implements WALActionsListener {
        private String tableName;
        private boolean isVisited = false;

        public TableWALActionListener(String tableName) {
            this.tableName = tableName;
        }

        public void preLogRoll(Path oldPath, Path newPath) throws IOException {
        }

        public void postLogRoll(Path oldPath, Path newPath) throws IOException {
        }

        public void preLogArchive(Path oldPath, Path newPath) throws IOException {
        }

        public void postLogArchive(Path oldPath, Path newPath) throws IOException {
        }

        public void logRollRequested(boolean tooFewReplicas) {
        }

        public void logCloseRequested() {
        }

        public void visitLogEntryBeforeWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit) {
        }

        public void visitLogEntryBeforeWrite(HTableDescriptor htd, HLogKey logKey, WALEdit logEdit) {
            if (this.tableName.equalsIgnoreCase(htd.getNameAsString())) {
                this.isVisited = true;
            }
        }

        public boolean isWALVisited() {
            return this.isVisited;
        }
    }
}

