/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.Bytes;

public class RemoveColumnAction
extends Action {
    private final byte[] tableName;
    private final Set<String> protectedColumns;
    private final String tableNameString;
    private HBaseAdmin admin;
    private Random random;

    public RemoveColumnAction(String tableName, Set<String> protectedColumns) {
        this.tableNameString = tableName;
        this.tableName = Bytes.toBytes((String)tableName);
        this.protectedColumns = protectedColumns;
        this.random = new Random();
    }

    @Override
    public void init(Action.ActionContext context) throws IOException {
        super.init(context);
        this.admin = context.getHBaseIntegrationTestingUtility().getHBaseAdmin();
    }

    @Override
    public void perform() throws Exception {
        HTableDescriptor tableDescriptor = this.admin.getTableDescriptor(this.tableName);
        HColumnDescriptor[] columnDescriptors = tableDescriptor.getColumnFamilies();
        if (columnDescriptors.length <= 1) {
            return;
        }
        int index = this.random.nextInt(columnDescriptors.length);
        while (this.protectedColumns != null && this.protectedColumns.contains(columnDescriptors[index].getNameAsString())) {
            index = this.random.nextInt(columnDescriptors.length);
        }
        LOG.debug((Object)("Performing action: Removing " + columnDescriptors[index].getName() + " from " + this.tableNameString));
        tableDescriptor.removeFamily(columnDescriptors[index].getName());
        this.admin.modifyTable(this.tableName, tableDescriptor);
    }
}

