/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.Bytes;

public class AddColumnAction
extends Action {
    private final byte[] tableName;
    private final String tableNameString;
    private HBaseAdmin admin;

    public AddColumnAction(String tableName) {
        this.tableNameString = tableName;
        this.tableName = Bytes.toBytes((String)tableName);
    }

    @Override
    public void init(Action.ActionContext context) throws IOException {
        super.init(context);
        this.admin = context.getHBaseIntegrationTestingUtility().getHBaseAdmin();
    }

    @Override
    public void perform() throws Exception {
        HTableDescriptor tableDescriptor = this.admin.getTableDescriptor(this.tableName);
        HColumnDescriptor columnDescriptor = null;
        while (columnDescriptor == null || tableDescriptor.getFamily(columnDescriptor.getName()) != null) {
            columnDescriptor = new HColumnDescriptor(RandomStringUtils.randomAlphabetic((int)5));
        }
        LOG.debug((Object)("Performing action: Adding " + columnDescriptor + " to " + this.tableNameString));
        tableDescriptor.addFamily(columnDescriptor);
        this.admin.modifyTable(this.tableName, tableDescriptor);
    }
}

