/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.view;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.Html;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class JQueryUI
extends HtmlBlock {
    public static final String ACCORDION = "ui.accordion";
    public static final String ACCORDION_ID = "ui.accordion.id";
    public static final String DATATABLES = "ui.dataTables";
    public static final String DATATABLES_ID = "ui.dataTables.id";
    public static final String DATATABLES_SELECTOR = "ui.dataTables.selector";
    public static final String DIALOG = "ui.dialog";
    public static final String DIALOG_ID = "ui.dialog.id";
    public static final String DIALOG_SELECTOR = "ui.dialog.selector";
    public static final String PROGRESSBAR = "ui.progressbar";
    public static final String PROGRESSBAR_ID = "ui.progressbar.id";
    public static final String _PROGRESSBAR = ".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all";
    public static final String C_PROGRESSBAR = ".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all".replace('.', ' ').trim();
    public static final String _PROGRESSBAR_VALUE = ".ui-progressbar-value.ui-widget-header.ui-corner-left";
    public static final String C_PROGRESSBAR_VALUE = ".ui-progressbar-value.ui-widget-header.ui-corner-left".replace('.', ' ').trim();
    public static final String _INFO_WRAP = ".info-wrap.ui-widget-content.ui-corner-bottom";
    public static final String _TH = ".ui-state-default";
    public static final String C_TH = ".ui-state-default".replace('.', ' ').trim();
    public static final String C_TABLE = "table";
    public static final String _INFO = ".info";
    public static final String _ODD = ".odd";
    public static final String _EVEN = ".even";

    protected void render(HtmlBlock.Block html) {
        html.link(this.root_url(new String[]{"static/jquery/themes-1.9.1/base/jquery-ui.css"})).link(this.root_url(new String[]{"static/dt-1.9.4/css/jui-dt.css"})).script(this.root_url(new String[]{"static/jquery/jquery-1.8.2.min.js"})).script(this.root_url(new String[]{"static/jquery/jquery-ui-1.9.1.custom.min.js"})).script(this.root_url(new String[]{"static/dt-1.9.4/js/jquery.dataTables.min.js"})).script(this.root_url(new String[]{"static/yarn.dt.plugins.js"})).style(new Object[]{"#jsnotice { padding: 0.2em; text-align: center; }", ".ui-progressbar { height: 1em; min-width: 5em }"});
        ArrayList list = Lists.newArrayList();
        this.initAccordions((List)list);
        this.initDataTables((List)list);
        this.initDialogs((List)list);
        this.initProgressBars((List)list);
        if (!list.isEmpty()) {
            html.script().$type("text/javascript")._(new Object[]{"$(function() {"})._(list.toArray())._(new Object[]{"});"})._();
        }
    }

    public static void jsnotice(HamletSpec.HTML html) {
        html.div("#jsnotice.ui-state-error")._(new Object[]{"This page works best with javascript enabled."})._();
        html.script().$type("text/javascript")._(new Object[]{"$('#jsnotice').hide();"})._();
    }

    protected void initAccordions(List<String> list) {
        for (String id : StringHelper.split((CharSequence)this.$("ui.accordion.id"))) {
            if (!Html.isValidId((String)id)) continue;
            String init = this.$(JQueryUI.initID((String)"ui.accordion", (String)id));
            if (init.isEmpty()) {
                init = "{autoHeight: false}";
            }
            list.add(StringHelper.join((Object[])new Object[]{"  $('#", id, "').accordion(", init, ");"}));
        }
    }

    protected void initDataTables(List<String> list) {
        String defaultInit = "{bJQueryUI: true, sPaginationType: 'full_numbers'}";
        String stateSaveInit = "bStateSave : true, \"fnStateSave\": function (oSettings, oData) { sessionStorage.setItem( oSettings.sTableId, JSON.stringify(oData) ); }, \"fnStateLoad\": function (oSettings) { return JSON.parse( sessionStorage.getItem(oSettings.sTableId) );}, ";
        for (String id : StringHelper.split((CharSequence)this.$("ui.dataTables.id"))) {
            if (!Html.isValidId((String)id)) continue;
            String init = this.$(JQueryUI.initID((String)"ui.dataTables", (String)id));
            if (init.isEmpty()) {
                init = defaultInit;
            }
            int pos = init.indexOf(123) + 1;
            init = new StringBuffer(init).insert(pos, stateSaveInit).toString();
            list.add(StringHelper.join((Object[])new Object[]{id, "DataTable =  $('#", id, "').dataTable(", init, ").fnSetFilteringDelay(188);"}));
            String postInit = this.$(JQueryUI.postInitID((String)"ui.dataTables", (String)id));
            if (postInit.isEmpty()) continue;
            list.add(postInit);
        }
        String selector = this.$("ui.dataTables.selector");
        if (!selector.isEmpty()) {
            String init = this.$(JQueryUI.initSelector((String)"ui.dataTables"));
            if (init.isEmpty()) {
                init = defaultInit;
            }
            int pos = init.indexOf(123) + 1;
            init = new StringBuffer(init).insert(pos, stateSaveInit).toString();
            list.add(StringHelper.join((Object[])new Object[]{"  $('", StringEscapeUtils.escapeJavaScript((String)selector), "').dataTable(", init, ").fnSetFilteringDelay(288);"}));
        }
    }

    protected void initDialogs(List<String> list) {
        String defaultInit = "{autoOpen: false, show: transfer, hide: explode}";
        for (String id : StringHelper.split((CharSequence)this.$("ui.dialog.id"))) {
            if (!Html.isValidId((String)id)) continue;
            String init = this.$(JQueryUI.initID((String)"ui.dialog", (String)id));
            if (init.isEmpty()) {
                init = defaultInit;
            }
            String opener = this.$(StringHelper.djoin((Object[])new Object[]{"ui.dialog", id, "opener"}));
            list.add(StringHelper.join((Object[])new Object[]{"  $('#", id, "').dialog(", init, ");"}));
            if (opener.isEmpty() || !Html.isValidId((String)opener)) continue;
            list.add(StringHelper.join((Object[])new Object[]{"  $('#", opener, "').click(function() { ", "$('#", id, "').dialog('open'); return false; });"}));
        }
        String selector = this.$("ui.dialog.selector");
        if (!selector.isEmpty()) {
            String init = this.$(JQueryUI.initSelector((String)"ui.dialog"));
            if (init.isEmpty()) {
                init = defaultInit;
            }
            list.add(StringHelper.join((Object[])new Object[]{"  $('", StringEscapeUtils.escapeJavaScript((String)selector), "').click(function() { $(this).children('.dialog').dialog(", init, "); return false; });"}));
        }
    }

    protected void initProgressBars(List<String> list) {
        for (String id : StringHelper.split((CharSequence)this.$("ui.progressbar.id"))) {
            if (!Html.isValidId((String)id)) continue;
            String init = this.$(JQueryUI.initID((String)"ui.progressbar", (String)id));
            list.add(StringHelper.join((Object[])new Object[]{"  $('#", id, "').progressbar(", init, ");"}));
        }
    }

    public static String initID(String name, String id) {
        return StringHelper.djoin((Object[])new Object[]{name, id, "init"});
    }

    public static String postInitID(String name, String id) {
        return StringHelper.djoin((Object[])new Object[]{name, id, "postinit"});
    }

    public static String initSelector(String name) {
        return StringHelper.djoin((Object[])new Object[]{name, "selector.init"});
    }

    public static StringBuilder tableInit() {
        return new StringBuilder("{bJQueryUI:true, ").append("sPaginationType: 'full_numbers', iDisplayLength:20, ").append("aLengthMenu:[20, 40, 60, 80, 100]");
    }
}

