/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.view;

import com.google.common.base.Joiner;
import java.util.Enumeration;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.webapp.view.TextPage;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class DefaultPage
extends TextPage {
    static final Joiner valJoiner = Joiner.on((String)", ");

    public void render() {
        this.puts(new Object[]{"Request URI: ", this.request().getRequestURI()});
        this.puts(new Object[]{"Query parameters:"});
        Map params = this.request().getParameterMap();
        for (Map.Entry e : params.entrySet()) {
            this.puts(new Object[]{"  ", e.getKey(), "=", valJoiner.join((Object[])e.getValue())});
        }
        this.puts(new Object[]{"More parameters:"});
        for (Map.Entry e : this.moreParams().entrySet()) {
            this.puts(new Object[]{"  ", e.getKey(), "=", e.getValue()});
        }
        this.puts(new Object[]{"Path info: ", this.request().getPathInfo()});
        this.puts(new Object[]{"Path translated: ", this.request().getPathTranslated()});
        this.puts(new Object[]{"Auth type: ", this.request().getAuthType()});
        this.puts(new Object[]{"Remote address: " + this.request().getRemoteAddr()});
        this.puts(new Object[]{"Remote user: ", this.request().getRemoteUser()});
        this.puts(new Object[]{"Servlet attributes:"});
        Enumeration attrNames = this.request().getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String key = (String)attrNames.nextElement();
            this.puts(new Object[]{"  ", key, "=", this.request().getAttribute(key)});
        }
        this.puts(new Object[]{"Headers:"});
        Enumeration headerNames = this.request().getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            this.puts(new Object[]{"  ", key, "=", this.request().getHeader(key)});
        }
    }
}

