/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.hadoop.yarn.util.TestRackResolver;
import org.junit.Assert;
import org.junit.Test;

public class TestRackResolver {
    private static Log LOG = LogFactory.getLog(TestRackResolver.class);
    private static final String invalidHost = "invalidHost";

    @Test
    public void testCaching() {
        Configuration conf = new Configuration();
        conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
        RackResolver.init((Configuration)conf);
        try {
            InetAddress iaddr = InetAddress.getByName("host1");
            MyResolver.resolvedHost1 = iaddr.getHostAddress();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        Node node = RackResolver.resolve((String)"host1");
        Assert.assertEquals((Object)"/rack1", (Object)node.getNetworkLocation());
        node = RackResolver.resolve((String)"host1");
        Assert.assertEquals((Object)"/rack1", (Object)node.getNetworkLocation());
        node = RackResolver.resolve((String)invalidHost);
        Assert.assertEquals((Object)"/default-rack", (Object)node.getNetworkLocation());
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }
}

