/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestYarnUncaughtExceptionHandler {
    private static final YarnUncaughtExceptionHandler exHandler = new YarnUncaughtExceptionHandler();

    @Test
    public void testUncaughtExceptionHandlerWithRuntimeException() throws InterruptedException {
        YarnUncaughtExceptionHandler spyYarnHandler = (YarnUncaughtExceptionHandler)Mockito.spy((Object)exHandler);
        YarnRuntimeException yarnException = new YarnRuntimeException("test-yarn-runtime-exception");
        Thread yarnThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        yarnThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)spyYarnHandler);
        Assert.assertSame((Object)spyYarnHandler, (Object)yarnThread.getUncaughtExceptionHandler());
        yarnThread.start();
        yarnThread.join();
        ((YarnUncaughtExceptionHandler)Mockito.verify((Object)spyYarnHandler)).uncaughtException(yarnThread, (Throwable)yarnException);
    }

    @Test
    public void testUncaughtExceptionHandlerWithError() throws InterruptedException {
        ExitUtil.disableSystemExit();
        YarnUncaughtExceptionHandler spyErrorHandler = (YarnUncaughtExceptionHandler)Mockito.spy((Object)exHandler);
        Error error = new Error("test-error");
        Thread errorThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        errorThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)spyErrorHandler);
        Assert.assertSame((Object)spyErrorHandler, (Object)errorThread.getUncaughtExceptionHandler());
        errorThread.start();
        errorThread.join();
        ((YarnUncaughtExceptionHandler)Mockito.verify((Object)spyErrorHandler)).uncaughtException(errorThread, (Throwable)error);
    }

    @Test
    public void testUncaughtExceptionHandlerWithOutOfMemoryError() throws InterruptedException {
        ExitUtil.disableSystemHalt();
        YarnUncaughtExceptionHandler spyOomHandler = (YarnUncaughtExceptionHandler)Mockito.spy((Object)exHandler);
        OutOfMemoryError oomError = new OutOfMemoryError("out-of-memory-error");
        Thread oomThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        oomThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)spyOomHandler);
        Assert.assertSame((Object)spyOomHandler, (Object)oomThread.getUncaughtExceptionHandler());
        oomThread.start();
        oomThread.join();
        ((YarnUncaughtExceptionHandler)Mockito.verify((Object)spyOomHandler)).uncaughtException(oomThread, (Throwable)oomError);
    }
}

